/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.zip.Adler32;
import java.util.zip.Checksum;
import java.util.zip.InflaterInputStream;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.Version;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.FastInputStream;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.DirectoryFactory;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.ReplicationHandler;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.util.FileUtils;
import org.apache.solr.util.PropertiesInputStream;
import org.apache.solr.util.PropertiesOutputStream;
import org.apache.solr.util.RefCounted;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexFetcher {
    private static final int _100K = 100000;
    public static final String INDEX_PROPERTIES = "index.properties";
    private static final Logger LOG = LoggerFactory.getLogger((String)IndexFetcher.class.getName());
    private final String masterUrl;
    private final ReplicationHandler replicationHandler;
    private volatile long replicationStartTime;
    private final SolrCore solrCore;
    private volatile List<Map<String, Object>> filesToDownload;
    private volatile List<Map<String, Object>> confFilesToDownload;
    private volatile List<Map<String, Object>> filesDownloaded;
    private volatile List<Map<String, Object>> confFilesDownloaded;
    private volatile Map<String, Object> currentFile;
    private volatile DirectoryFileFetcher dirFileFetcher;
    private volatile LocalFsFileFetcher localFileFetcher;
    private volatile ExecutorService fsyncService;
    private volatile boolean stop = false;
    private boolean useInternal = false;
    private boolean useExternal = false;
    private final HttpClient myHttpClient;
    private volatile Exception fsyncException;
    private final Map<String, ReplicationHandler.FileInfo> confFileInfoCache = new HashMap<String, ReplicationHandler.FileInfo>();
    private static final int MAX_RETRIES = 5;
    private static final int NO_CONTENT = 1;
    private static final int ERR = 2;
    public static final String REPLICATION_PROPERTIES = "replication.properties";
    static final String INDEX_REPLICATED_AT = "indexReplicatedAt";
    static final String TIMES_INDEX_REPLICATED = "timesIndexReplicated";
    static final String CONF_FILES_REPLICATED = "confFilesReplicated";
    static final String CONF_FILES_REPLICATED_AT = "confFilesReplicatedAt";
    static final String TIMES_CONFIG_REPLICATED = "timesConfigReplicated";
    static final String LAST_CYCLE_BYTES_DOWNLOADED = "lastCycleBytesDownloaded";
    static final String TIMES_FAILED = "timesFailed";
    static final String REPLICATION_FAILED_AT = "replicationFailedAt";
    static final String PREVIOUS_CYCLE_TIME_TAKEN = "previousCycleTimeInSeconds";
    static final String INDEX_REPLICATED_AT_LIST = "indexReplicatedAtList";
    static final String REPLICATION_FAILED_AT_LIST = "replicationFailedAtList";

    private static HttpClient createHttpClient(SolrCore core, String connTimeout, String readTimeout, String httpBasicAuthUser, String httpBasicAuthPassword, boolean useCompression) {
        ModifiableSolrParams httpClientParams = new ModifiableSolrParams();
        httpClientParams.set("connTimeout", new String[]{connTimeout != null ? connTimeout : "5000"});
        httpClientParams.set("socketTimeout", new String[]{readTimeout != null ? readTimeout : "20000"});
        httpClientParams.set("httpBasicAuthUser", new String[]{httpBasicAuthUser});
        httpClientParams.set("httpBasicAuthPassword", new String[]{httpBasicAuthPassword});
        httpClientParams.set("allowCompression", useCompression);
        return HttpClientUtil.createClient((SolrParams)httpClientParams, (ClientConnectionManager)core.getCoreDescriptor().getCoreContainer().getUpdateShardHandler().getConnectionManager());
    }

    public IndexFetcher(NamedList initArgs, ReplicationHandler handler, SolrCore sc) {
        this.solrCore = sc;
        String masterUrl = (String)initArgs.get("masterUrl");
        if (masterUrl == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "'masterUrl' is required for a slave");
        }
        if (masterUrl.endsWith("/replication")) {
            masterUrl = masterUrl.substring(0, masterUrl.length() - 12);
            LOG.warn("'masterUrl' must be specified without the /replication suffix");
        }
        this.masterUrl = masterUrl;
        this.replicationHandler = handler;
        String compress = (String)initArgs.get("compression");
        this.useInternal = "internal".equals(compress);
        this.useExternal = "external".equals(compress);
        String connTimeout = (String)initArgs.get("connTimeout");
        String readTimeout = (String)initArgs.get("socketTimeout");
        String httpBasicAuthUser = (String)initArgs.get("httpBasicAuthUser");
        String httpBasicAuthPassword = (String)initArgs.get("httpBasicAuthPassword");
        this.myHttpClient = IndexFetcher.createHttpClient(this.solrCore, connTimeout, readTimeout, httpBasicAuthUser, httpBasicAuthPassword, this.useExternal);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    NamedList getLatestVersion() throws IOException {
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("command", new String[]{"indexversion"});
        params.set("wt", new String[]{"javabin"});
        params.set("qt", new String[]{"/replication"});
        QueryRequest req = new QueryRequest((SolrParams)params);
        try (HttpSolrClient client = new HttpSolrClient(this.masterUrl, this.myHttpClient);){
            client.setSoTimeout(60000);
            client.setConnectionTimeout(15000);
            NamedList namedList = client.request((SolrRequest)req);
            return namedList;
        }
        catch (SolrServerException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, e.getMessage(), (Throwable)e);
        }
    }

    private void fetchFileList(long gen) throws IOException {
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("command", new String[]{"filelist"});
        params.set("generation", new String[]{String.valueOf(gen)});
        params.set("wt", new String[]{"javabin"});
        params.set("qt", new String[]{"/replication"});
        QueryRequest req = new QueryRequest((SolrParams)params);
        try (HttpSolrClient client = new HttpSolrClient(this.masterUrl, this.myHttpClient);){
            client.setSoTimeout(60000);
            client.setConnectionTimeout(15000);
            NamedList response = client.request((SolrRequest)req);
            List files = (List)response.get("filelist");
            if (files != null) {
                this.filesToDownload = Collections.synchronizedList(files);
            } else {
                this.filesToDownload = Collections.emptyList();
                LOG.error("No files to download for index generation: " + gen);
            }
            files = (List)response.get("confFiles");
            if (files != null) {
                this.confFilesToDownload = Collections.synchronizedList(files);
            }
        }
        catch (SolrServerException e) {
            throw new IOException(e);
        }
    }

    boolean fetchLatestIndex(boolean forceReplication) throws IOException, InterruptedException {
        return this.fetchLatestIndex(forceReplication, false);
    }

    /*
     * Exception decompiling
     */
    boolean fetchLatestIndex(boolean forceReplication, boolean forceCoreReload) throws IOException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [21[CATCHBLOCK]], but top level block is 14[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup(SolrCore core, Directory tmpIndexDir, Directory indexDir, boolean deleteTmpIdxDir, boolean successfulInstall) throws IOException {
        try {
            if (!successfulInstall) {
                try {
                    this.logReplicationTimeAndConfFiles(null, successfulInstall);
                }
                catch (Exception e) {
                    LOG.error("caught", (Throwable)e);
                }
            }
            core.getUpdateHandler().getSolrCoreState().setLastReplicateIndexSuccess(successfulInstall);
            this.confFilesToDownload = null;
            this.confFilesDownloaded = null;
            this.filesDownloaded = null;
            this.filesToDownload = null;
            this.replicationStartTime = 0L;
            this.dirFileFetcher = null;
            this.localFileFetcher = null;
            if (this.fsyncService != null && !this.fsyncService.isShutdown()) {
                this.fsyncService.shutdownNow();
            }
            this.fsyncService = null;
            this.stop = false;
            this.fsyncException = null;
        }
        finally {
            if (deleteTmpIdxDir && tmpIndexDir != null) {
                try {
                    core.getDirectoryFactory().doneWithDirectory(tmpIndexDir);
                    core.getDirectoryFactory().remove(tmpIndexDir);
                }
                catch (IOException e) {
                    SolrException.log((Logger)LOG, (String)("Error removing directory " + tmpIndexDir), (Throwable)e);
                }
            }
            if (tmpIndexDir != null) {
                core.getDirectoryFactory().release(tmpIndexDir);
            }
            if (indexDir != null) {
                core.getDirectoryFactory().release(indexDir);
            }
        }
    }

    private boolean hasUnusedFiles(Directory indexDir, IndexCommit commit) throws IOException {
        String[] allFiles;
        String segmentsFileName = commit.getSegmentsFileName();
        SegmentInfos infos = SegmentInfos.readCommit((Directory)indexDir, (String)segmentsFileName);
        HashSet currentFiles = new HashSet(infos.files(true));
        for (String file : allFiles = indexDir.listAll()) {
            if (file.equals(segmentsFileName) || currentFiles.contains(file) || file.endsWith(".lock")) continue;
            LOG.info("Found unused file: " + file);
            return true;
        }
        return false;
    }

    private void terminateAndWaitFsyncService() throws Exception {
        if (this.fsyncService.isTerminated()) {
            return;
        }
        this.fsyncService.shutdown();
        this.fsyncService.awaitTermination(3600L, TimeUnit.SECONDS);
        Exception fsyncExceptionCopy = this.fsyncException;
        if (fsyncExceptionCopy != null) {
            throw fsyncExceptionCopy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void logReplicationTimeAndConfFiles(Collection<Map<String, Object>> modifiedConfFiles, boolean successfulInstall) throws IOException {
        ArrayList<String> confFiles = new ArrayList<String>();
        if (modifiedConfFiles != null && !modifiedConfFiles.isEmpty()) {
            for (Map<String, Object> map1 : modifiedConfFiles) {
                confFiles.add((String)map1.get("name"));
            }
        }
        Properties props = this.replicationHandler.loadReplicationProperties();
        long replicationTime = System.currentTimeMillis();
        long replicationTimeTaken = (replicationTime - this.getReplicationStartTime()) / 1000L;
        Directory dir = null;
        try {
            dir = this.solrCore.getDirectoryFactory().get(this.solrCore.getDataDir(), DirectoryFactory.DirContext.META_DATA, this.solrCore.getSolrConfig().indexConfig.lockType);
            int indexCount = 1;
            int confFilesCount = 1;
            if (props.containsKey(TIMES_INDEX_REPLICATED)) {
                indexCount = Integer.valueOf(props.getProperty(TIMES_INDEX_REPLICATED)) + 1;
            }
            StringBuilder sb = this.readToStringBuilder(replicationTime, props.getProperty(INDEX_REPLICATED_AT_LIST));
            props.setProperty(INDEX_REPLICATED_AT_LIST, sb.toString());
            props.setProperty(INDEX_REPLICATED_AT, String.valueOf(replicationTime));
            props.setProperty(PREVIOUS_CYCLE_TIME_TAKEN, String.valueOf(replicationTimeTaken));
            props.setProperty(TIMES_INDEX_REPLICATED, String.valueOf(indexCount));
            if (modifiedConfFiles != null && !modifiedConfFiles.isEmpty()) {
                props.setProperty(CONF_FILES_REPLICATED, ((Object)confFiles).toString());
                props.setProperty(CONF_FILES_REPLICATED_AT, String.valueOf(replicationTime));
                if (props.containsKey(TIMES_CONFIG_REPLICATED)) {
                    confFilesCount = Integer.valueOf(props.getProperty(TIMES_CONFIG_REPLICATED)) + 1;
                }
                props.setProperty(TIMES_CONFIG_REPLICATED, String.valueOf(confFilesCount));
            }
            props.setProperty(LAST_CYCLE_BYTES_DOWNLOADED, String.valueOf(this.getTotalBytesDownloaded()));
            if (!successfulInstall) {
                int numFailures = 1;
                if (props.containsKey(TIMES_FAILED)) {
                    numFailures = Integer.valueOf(props.getProperty(TIMES_FAILED)) + 1;
                }
                props.setProperty(TIMES_FAILED, String.valueOf(numFailures));
                props.setProperty(REPLICATION_FAILED_AT, String.valueOf(replicationTime));
                sb = this.readToStringBuilder(replicationTime, props.getProperty(REPLICATION_FAILED_AT_LIST));
                props.setProperty(REPLICATION_FAILED_AT_LIST, sb.toString());
            }
            IndexOutput out = dir.createOutput(REPLICATION_PROPERTIES, DirectoryFactory.IOCONTEXT_NO_CACHE);
            OutputStreamWriter outFile = new OutputStreamWriter((OutputStream)new PropertiesOutputStream(out), StandardCharsets.UTF_8);
            try {
                props.store(outFile, "Replication details");
                dir.sync(Collections.singleton(REPLICATION_PROPERTIES));
            }
            finally {
                org.apache.commons.io.IOUtils.closeQuietly((Writer)outFile);
            }
            if (dir == null) return;
        }
        catch (Exception e) {
            try {
                LOG.warn("Exception while updating statistics", (Throwable)e);
                if (dir == null) return;
            }
            catch (Throwable throwable) {
                if (dir == null) throw throwable;
                this.solrCore.getDirectoryFactory().release(dir);
                throw throwable;
            }
            this.solrCore.getDirectoryFactory().release(dir);
            return;
        }
        this.solrCore.getDirectoryFactory().release(dir);
        return;
    }

    long getTotalBytesDownloaded() {
        long bytesDownloaded = 0L;
        for (Map<String, Object> file : this.getFilesDownloaded()) {
            bytesDownloaded += ((Long)file.get("size")).longValue();
        }
        for (Map<String, Object> file : this.getConfFilesDownloaded()) {
            bytesDownloaded += ((Long)file.get("size")).longValue();
        }
        Map<String, Object> currentFile = this.getCurrentFile();
        if (currentFile != null && currentFile.containsKey("bytesDownloaded")) {
            bytesDownloaded += ((Long)currentFile.get("bytesDownloaded")).longValue();
        }
        return bytesDownloaded;
    }

    private StringBuilder readToStringBuilder(long replicationTime, String str) {
        StringBuilder sb = new StringBuilder();
        ArrayList l = new ArrayList();
        if (str != null && str.length() != 0) {
            String[] ss = str.split(",");
            Collections.addAll(l, ss);
        }
        sb.append(replicationTime);
        if (!l.isEmpty()) {
            for (int i = 0; (i < l.size() || i < 9) && i != l.size() && i != 9; ++i) {
                String s = (String)l.get(i);
                sb.append(",").append(s);
            }
        }
        return sb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openNewSearcherAndUpdateCommitPoint() throws IOException {
        IndexCommit commitPoint;
        LocalSolrQueryRequest req = new LocalSolrQueryRequest(this.solrCore, (SolrParams)new ModifiableSolrParams());
        RefCounted<SolrIndexSearcher> searcher = null;
        try {
            Future[] waitSearcher = new Future[1];
            searcher = this.solrCore.getSearcher(true, true, waitSearcher, true);
            if (waitSearcher[0] != null) {
                try {
                    waitSearcher[0].get();
                }
                catch (InterruptedException | ExecutionException e) {
                    SolrException.log((Logger)LOG, (Throwable)e);
                }
            }
            commitPoint = searcher.get().getIndexReader().getIndexCommit();
        }
        finally {
            req.close();
            if (searcher != null) {
                searcher.decref();
            }
        }
        this.replicationHandler.indexCommitPoint = commitPoint;
    }

    private void reloadCore() {
        final CountDownLatch latch = new CountDownLatch(1);
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    IndexFetcher.this.solrCore.getCoreDescriptor().getCoreContainer().reload(IndexFetcher.this.solrCore.getName());
                }
                catch (Exception e) {
                    LOG.error("Could not reload core ", (Throwable)e);
                }
                finally {
                    latch.countDown();
                }
            }
        }.start();
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted while waiting for core reload to finish", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadConfFiles(List<Map<String, Object>> confFilesToDownload, long latestGeneration) throws Exception {
        LOG.info("Starting download of configuration files from master: " + confFilesToDownload);
        this.confFilesDownloaded = Collections.synchronizedList(new ArrayList());
        File tmpconfDir = new File(this.solrCore.getResourceLoader().getConfigDir(), "conf." + this.getDateAsStr(new Date()));
        try {
            boolean status = tmpconfDir.mkdirs();
            if (!status) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failed to create temporary config folder: " + tmpconfDir.getName());
            }
            for (Map<String, Object> file : confFilesToDownload) {
                String saveAs = (String)(file.get("alias") == null ? file.get("name") : file.get("alias"));
                this.localFileFetcher = new LocalFsFileFetcher(tmpconfDir, file, saveAs, true, latestGeneration);
                this.currentFile = file;
                this.localFileFetcher.fetchFile();
                this.confFilesDownloaded.add(new HashMap<String, Object>(file));
            }
            this.terminateAndWaitFsyncService();
            this.copyTmpConfFiles2Conf(tmpconfDir);
        }
        finally {
            IndexFetcher.delTree(tmpconfDir);
        }
    }

    private void downloadIndexFiles(boolean downloadCompleteIndex, Directory indexDir, Version version, Directory tmpIndexDir, long latestGeneration) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Download files to dir: " + Arrays.asList(indexDir.listAll()));
        }
        for (Map<String, Object> file : this.filesToDownload) {
            String filename = (String)file.get("name");
            long size = (Long)file.get("size");
            CompareResult compareResult = IndexFetcher.compareFile(indexDir, version, filename, size, (Long)file.get("checksum"));
            if (!compareResult.equal || downloadCompleteIndex || this.filesToAlwaysDownloadIfNoChecksums(filename, size, compareResult)) {
                this.dirFileFetcher = new DirectoryFileFetcher(tmpIndexDir, file, (String)file.get("name"), false, latestGeneration);
                this.currentFile = file;
                this.dirFileFetcher.fetchFile();
                this.filesDownloaded.add(new HashMap<String, Object>(file));
                continue;
            }
            LOG.info("Skipping download for " + file.get("name") + " because it already exists");
        }
    }

    private boolean filesToAlwaysDownloadIfNoChecksums(String filename, long size, CompareResult compareResult) {
        return !compareResult.checkSummed && (filename.endsWith(".si") || filename.endsWith(".liv") || filename.startsWith("segments_") || size < 100000L);
    }

    protected static Version checkOldestVersion(SegmentInfos infos) {
        Version oldestVersion = Version.LUCENE_CURRENT;
        for (SegmentCommitInfo commitInfo : infos) {
            Version version = commitInfo.info.getVersion();
            if (!oldestVersion.onOrAfter(version)) continue;
            oldestVersion = version;
        }
        return oldestVersion;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static CompareResult compareFile(Directory indexDir, Version version, String filename, Long backupIndexFileLen, Long backupIndexFileChecksum) {
        CompareResult compareResult = new CompareResult();
        try (IndexInput indexInput = indexDir.openInput(filename, IOContext.READONCE);){
            long indexFileLen = indexInput.length();
            long indexFileChecksum = 0L;
            if (backupIndexFileChecksum != null && version.onOrAfter(Version.LUCENE_4_8_0)) {
                try {
                    indexFileChecksum = CodecUtil.retrieveChecksum((IndexInput)indexInput);
                    compareResult.checkSummed = true;
                }
                catch (Exception e) {
                    LOG.warn("Could not retrieve checksum from file.", (Throwable)e);
                }
            }
            if (!compareResult.checkSummed) {
                if (indexFileLen == backupIndexFileLen) {
                    compareResult.equal = true;
                    CompareResult compareResult2 = compareResult;
                    return compareResult2;
                }
                LOG.warn("File {} did not match. expected length is {} and actual length is {}", new Object[]{filename, backupIndexFileLen, indexFileLen});
                compareResult.equal = false;
                CompareResult compareResult3 = compareResult;
                return compareResult3;
            }
            if (indexFileLen == backupIndexFileLen && indexFileChecksum == backupIndexFileChecksum) {
                compareResult.equal = true;
                CompareResult compareResult4 = compareResult;
                return compareResult4;
            }
            LOG.warn("File {} did not match. expected checksum is {} and actual is checksum {}. expected length is {} and actual length is {}", new Object[]{filename, backupIndexFileChecksum, indexFileChecksum, backupIndexFileLen, indexFileLen});
            compareResult.equal = false;
            CompareResult compareResult5 = compareResult;
            return compareResult5;
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            compareResult.equal = false;
            return compareResult;
        }
        catch (IOException e) {
            LOG.error("Could not read file " + filename + ". Downloading it again", (Throwable)e);
            compareResult.equal = false;
            return compareResult;
        }
    }

    private static boolean slowFileExists(Directory dir, String fileName) throws IOException {
        try {
            dir.openInput(fileName, IOContext.DEFAULT).close();
            return true;
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            return false;
        }
    }

    private boolean isIndexStale(Directory dir, Version indexVersion) throws IOException {
        for (Map<String, Object> file : this.filesToDownload) {
            String filename = (String)file.get("name");
            Long length = (Long)file.get("size");
            Long checksum = (Long)file.get("checksum");
            if (!IndexFetcher.slowFileExists(dir, filename)) continue;
            if (checksum != null) {
                if (IndexFetcher.compareFile((Directory)dir, (Version)indexVersion, (String)filename, (Long)length, (Long)checksum).equal) continue;
                return true;
            }
            if (length.longValue() == dir.fileLength(filename)) continue;
            LOG.warn("File {} did not match. expected length is {} and actual length is {}", new Object[]{filename, length, dir.fileLength(filename)});
            return true;
        }
        return false;
    }

    private boolean moveAFile(Directory tmpIdxDir, Directory indexDir, String fname) {
        LOG.debug("Moving file: {}", (Object)fname);
        boolean success = false;
        try {
            if (IndexFetcher.slowFileExists(indexDir, fname)) {
                LOG.info("Skipping move file - it already exists:" + fname);
                return true;
            }
        }
        catch (IOException e) {
            SolrException.log((Logger)LOG, (String)"could not check if a file exists", (Throwable)e);
            return false;
        }
        try {
            this.solrCore.getDirectoryFactory().move(tmpIdxDir, indexDir, fname, DirectoryFactory.IOCONTEXT_NO_CACHE);
            success = true;
        }
        catch (IOException e) {
            SolrException.log((Logger)LOG, (String)"Could not move file", (Throwable)e);
        }
        return success;
    }

    private boolean moveIndexFiles(Directory tmpIdxDir, Directory indexDir) {
        if (LOG.isDebugEnabled()) {
            try {
                LOG.info("From dir files:" + Arrays.asList(tmpIdxDir.listAll()));
                LOG.info("To dir files:" + Arrays.asList(indexDir.listAll()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        String segmentsFile = null;
        for (Map<String, Object> f : this.filesDownloaded) {
            String fname = (String)f.get("name");
            if (fname.startsWith("segments_")) {
                segmentsFile = fname;
                continue;
            }
            if (this.moveAFile(tmpIdxDir, indexDir, fname)) continue;
            return false;
        }
        return segmentsFile == null || this.moveAFile(tmpIdxDir, indexDir, segmentsFile);
    }

    private List<File> makeTmpConfDirFileList(File dir, List<File> fileList) {
        File[] files;
        for (File file : files = dir.listFiles()) {
            if (file.isFile()) {
                fileList.add(file);
                continue;
            }
            if (!file.isDirectory()) continue;
            fileList = this.makeTmpConfDirFileList(file, fileList);
        }
        return fileList;
    }

    private void copyTmpConfFiles2Conf(File tmpconfDir) {
        boolean status = false;
        File confDir = new File(this.solrCore.getResourceLoader().getConfigDir());
        for (File file : this.makeTmpConfDirFileList(tmpconfDir, new ArrayList<File>())) {
            File oldFile = new File(confDir, file.getPath().substring(tmpconfDir.getPath().length(), file.getPath().length()));
            if (!oldFile.getParentFile().exists() && !(status = oldFile.getParentFile().mkdirs())) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to mkdirs: " + oldFile.getParentFile());
            }
            if (oldFile.exists()) {
                File backupFile = new File(oldFile.getPath() + "." + this.getDateAsStr(new Date(oldFile.lastModified())));
                if (!backupFile.getParentFile().exists() && !(status = backupFile.getParentFile().mkdirs())) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to mkdirs: " + backupFile.getParentFile());
                }
                status = oldFile.renameTo(backupFile);
                if (!status) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to rename: " + oldFile + " to: " + backupFile);
                }
            }
            if (status = file.renameTo(oldFile)) continue;
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to rename: " + file + " to: " + oldFile);
        }
    }

    private String getDateAsStr(Date d) {
        return new SimpleDateFormat("yyyyMMddHHmmssSSS", Locale.ROOT).format(d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static boolean modifyIndexProps(SolrCore solrCore, String tmpIdxDirName) {
        boolean bl;
        LOG.info("New index installed. Updating index properties... index=" + tmpIdxDirName);
        Properties p = new Properties();
        Directory dir = null;
        try {
            dir = solrCore.getDirectoryFactory().get(solrCore.getDataDir(), DirectoryFactory.DirContext.META_DATA, solrCore.getSolrConfig().indexConfig.lockType);
            if (IndexFetcher.slowFileExists(dir, INDEX_PROPERTIES)) {
                IndexInput input = dir.openInput(INDEX_PROPERTIES, DirectoryFactory.IOCONTEXT_NO_CACHE);
                PropertiesInputStream is = new PropertiesInputStream(input);
                try {
                    p.load(new InputStreamReader((InputStream)is, StandardCharsets.UTF_8));
                }
                catch (Exception e) {
                    LOG.error("Unable to load index.properties", (Throwable)e);
                }
                finally {
                    org.apache.commons.io.IOUtils.closeQuietly((InputStream)is);
                }
            }
            try {
                dir.deleteFile(INDEX_PROPERTIES);
            }
            catch (IOException e) {
                // empty catch block
            }
            IndexOutput out = dir.createOutput(INDEX_PROPERTIES, DirectoryFactory.IOCONTEXT_NO_CACHE);
            p.put("index", tmpIdxDirName);
            OutputStreamWriter os = null;
            try {
                os = new OutputStreamWriter((OutputStream)new PropertiesOutputStream(out), StandardCharsets.UTF_8);
                p.store(os, INDEX_PROPERTIES);
                dir.sync(Collections.singleton(INDEX_PROPERTIES));
            }
            catch (Exception e) {
                try {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to write index.properties", (Throwable)e);
                }
                catch (Throwable throwable) {
                    org.apache.commons.io.IOUtils.closeQuietly(os);
                    throw throwable;
                }
            }
            org.apache.commons.io.IOUtils.closeQuietly((Writer)os);
            bl = true;
            if (dir == null) return bl;
        }
        catch (IOException e1) {
            try {
                throw new RuntimeException(e1);
            }
            catch (Throwable throwable) {
                if (dir == null) throw throwable;
                try {
                    solrCore.getDirectoryFactory().release(dir);
                    throw throwable;
                }
                catch (IOException e) {
                    SolrException.log((Logger)LOG, (String)"", (Throwable)e);
                }
                throw throwable;
            }
        }
        try {
            solrCore.getDirectoryFactory().release(dir);
            return bl;
        }
        catch (IOException e) {
            SolrException.log((Logger)LOG, (String)"", (Throwable)e);
        }
        return bl;
    }

    private Collection<Map<String, Object>> getModifiedConfFiles(List<Map<String, Object>> confFilesToDownload) {
        if (confFilesToDownload == null || confFilesToDownload.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        HashMap<String, Map<String, Object>> nameVsFile = new HashMap<String, Map<String, Object>>();
        NamedList names = new NamedList();
        for (Map<String, Object> map : confFilesToDownload) {
            String name = (String)(map.get("alias") == null ? map.get("name") : map.get("alias"));
            nameVsFile.put(name, map);
            names.add(name, null);
        }
        List<Map<String, Object>> localFilesInfo = this.replicationHandler.getConfFileInfoFromCache((NamedList<String>)names, this.confFileInfoCache);
        for (Map<String, Object> fileInfo : localFilesInfo) {
            String name = (String)fileInfo.get("name");
            Map m = (Map)nameVsFile.get(name);
            if (m == null || !m.get("checksum").equals(fileInfo.get("checksum"))) continue;
            nameVsFile.remove(name);
        }
        return nameVsFile.isEmpty() ? Collections.EMPTY_LIST : nameVsFile.values();
    }

    static Throwable delete(File file) {
        try {
            Files.delete(file.toPath());
            return null;
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (Throwable other) {
            return other;
        }
    }

    static boolean delTree(File dir) {
        try {
            IOUtils.rm((Path[])new Path[]{dir.toPath()});
            return true;
        }
        catch (IOException e) {
            LOG.warn("Unable to delete directory : " + dir, (Throwable)e);
            return false;
        }
    }

    void abortFetch() {
        this.stop = true;
    }

    long getReplicationStartTime() {
        return this.replicationStartTime;
    }

    long getReplicationTimeElapsed() {
        long timeElapsed = 0L;
        if (this.getReplicationStartTime() > 0L) {
            timeElapsed = TimeUnit.SECONDS.convert(System.currentTimeMillis() - this.getReplicationStartTime(), TimeUnit.MILLISECONDS);
        }
        return timeElapsed;
    }

    List<Map<String, Object>> getConfFilesToDownload() {
        List<Map<String, Object>> tmp = this.confFilesToDownload;
        return tmp == null ? Collections.EMPTY_LIST : new ArrayList<Map<String, Object>>(tmp);
    }

    List<Map<String, Object>> getConfFilesDownloaded() {
        List<Map<String, Object>> tmp = this.confFilesDownloaded;
        return tmp == null ? Collections.EMPTY_LIST : new ArrayList<Map<String, Object>>(tmp);
    }

    List<Map<String, Object>> getFilesToDownload() {
        List<Map<String, Object>> tmp = this.filesToDownload;
        return tmp == null ? Collections.EMPTY_LIST : new ArrayList<Map<String, Object>>(tmp);
    }

    List<Map<String, Object>> getFilesDownloaded() {
        List<Map<String, Object>> tmp = this.filesDownloaded;
        return tmp == null ? Collections.EMPTY_LIST : new ArrayList<Map<String, Object>>(tmp);
    }

    Map<String, Object> getCurrentFile() {
        Map<String, Object> tmp = this.currentFile;
        DirectoryFileFetcher tmpFileFetcher = this.dirFileFetcher;
        if (tmp == null) {
            return null;
        }
        tmp = new HashMap<String, Object>(tmp);
        if (tmpFileFetcher != null) {
            tmp.put("bytesDownloaded", tmpFileFetcher.getBytesDownloaded());
        }
        return tmp;
    }

    NamedList getDetails() throws IOException, SolrServerException {
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("command", new String[]{"details"});
        params.set("slave", false);
        params.set("qt", new String[]{"/replication"});
        try (HttpSolrClient client = new HttpSolrClient(this.masterUrl, this.myHttpClient);){
            client.setSoTimeout(60000);
            client.setConnectionTimeout(15000);
            QueryRequest request = new QueryRequest((SolrParams)params);
            NamedList namedList = client.request((SolrRequest)request);
            return namedList;
        }
    }

    public void destroy() {
        this.abortFetch();
    }

    String getMasterUrl() {
        return this.masterUrl;
    }

    private class LocalFsFileFetcher
    extends FileFetcher {
        LocalFsFileFetcher(File dir, Map<String, Object> fileDetails, String saveAs, boolean isConf, long latestGen) throws IOException {
            super(new LocalFsFile(dir, saveAs), fileDetails, saveAs, isConf, latestGen);
        }
    }

    private class LocalFsFile
    implements FileInterface {
        private File copy2Dir;
        FileChannel fileChannel;
        private FileOutputStream fileOutputStream;
        File file;

        LocalFsFile(File dir, String saveAs) throws IOException {
            this.copy2Dir = dir;
            this.file = new File(this.copy2Dir, saveAs);
            File parentDir = this.file.getParentFile();
            if (!parentDir.exists() && !parentDir.mkdirs()) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failed to create (sub)directory for file: " + saveAs);
            }
            this.fileOutputStream = new FileOutputStream(this.file);
            this.fileChannel = this.fileOutputStream.getChannel();
        }

        @Override
        public void sync() throws IOException {
            FileUtils.sync(this.file);
        }

        @Override
        public void write(byte[] buf, int packetSize) throws IOException {
            this.fileChannel.write(ByteBuffer.wrap(buf, 0, packetSize));
        }

        @Override
        public void close() throws Exception {
            this.fileOutputStream.close();
        }

        @Override
        public void delete() throws Exception {
            Files.delete(this.file.toPath());
        }
    }

    private class DirectoryFileFetcher
    extends FileFetcher {
        DirectoryFileFetcher(Directory tmpIndexDir, Map<String, Object> fileDetails, String saveAs, boolean isConf, long latestGen) throws IOException {
            super(new DirectoryFile(tmpIndexDir, saveAs), fileDetails, saveAs, isConf, latestGen);
        }
    }

    private class DirectoryFile
    implements FileInterface {
        private final String saveAs;
        private Directory copy2Dir;
        private IndexOutput outStream;

        DirectoryFile(Directory tmpIndexDir, String saveAs) throws IOException {
            this.saveAs = saveAs;
            this.copy2Dir = tmpIndexDir;
            this.outStream = this.copy2Dir.createOutput(this.saveAs, DirectoryFactory.IOCONTEXT_NO_CACHE);
        }

        @Override
        public void sync() throws IOException {
            this.copy2Dir.sync(Collections.singleton(this.saveAs));
        }

        @Override
        public void write(byte[] buf, int packetSize) throws IOException {
            this.outStream.writeBytes(buf, 0, packetSize);
        }

        @Override
        public void close() throws Exception {
            this.outStream.close();
        }

        @Override
        public void delete() throws Exception {
            this.copy2Dir.deleteFile(this.saveAs);
        }
    }

    private class FileFetcher {
        private final FileInterface file;
        private boolean includeChecksum = true;
        private String fileName;
        private String saveAs;
        private boolean isConf;
        private Long indexGen;
        private long size;
        private long bytesDownloaded = 0L;
        private byte[] buf = new byte[0x100000];
        private Checksum checksum;
        private int errorCount = 0;
        private boolean aborted = false;

        FileFetcher(FileInterface file, Map<String, Object> fileDetails, String saveAs, boolean isConf, long latestGen) throws IOException {
            this.file = file;
            this.fileName = (String)fileDetails.get("name");
            this.size = (Long)fileDetails.get("size");
            this.isConf = isConf;
            this.saveAs = saveAs;
            this.indexGen = latestGen;
            if (this.includeChecksum) {
                this.checksum = new Adler32();
            }
        }

        public long getBytesDownloaded() {
            return this.bytesDownloaded;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void fetchFile() throws Exception {
            try {
                FastInputStream is;
                while (true) {
                    is = this.getStream();
                    int result = this.fetchPackets(is);
                    if (result != 0 && result != 1) break block6;
                    break;
                }
                {
                    catch (Throwable throwable) {
                        org.apache.commons.io.IOUtils.closeQuietly((InputStream)is);
                        throw throwable;
                    }
                }
                {
                    block6: {
                        org.apache.commons.io.IOUtils.closeQuietly((InputStream)is);
                        this.cleanup();
                        IndexFetcher.this.fsyncService.submit(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    FileFetcher.this.file.sync();
                                }
                                catch (IOException e) {
                                    IndexFetcher.this.fsyncException = e;
                                }
                            }
                        });
                        return;
                    }
                    org.apache.commons.io.IOUtils.closeQuietly((InputStream)is);
                    continue;
                }
            }
            catch (Throwable throwable) {
                this.cleanup();
                IndexFetcher.this.fsyncService.submit(new /* invalid duplicate definition of identical inner class */);
                throw throwable;
            }
        }

        private int fetchPackets(FastInputStream fis) throws Exception {
            byte[] intbytes = new byte[4];
            byte[] longbytes = new byte[8];
            try {
                while (true) {
                    if (IndexFetcher.this.stop) {
                        IndexFetcher.this.stop = false;
                        this.aborted = true;
                        throw new ReplicationHandlerException("User aborted replication");
                    }
                    long checkSumServer = -1L;
                    fis.readFully(intbytes);
                    int packetSize = this.readInt(intbytes);
                    if (packetSize <= 0) {
                        LOG.warn("No content received for file: {}", (Object)this.fileName);
                        return 1;
                    }
                    if (this.buf.length < packetSize) {
                        this.buf = new byte[packetSize];
                    }
                    if (this.checksum != null) {
                        fis.readFully(longbytes);
                        checkSumServer = this.readLong(longbytes);
                    }
                    fis.readFully(this.buf, 0, packetSize);
                    if (this.includeChecksum) {
                        this.checksum.reset();
                        this.checksum.update(this.buf, 0, packetSize);
                        long checkSumClient = this.checksum.getValue();
                        if (checkSumClient != checkSumServer) {
                            LOG.error("Checksum not matched between client and server for file: {}", (Object)this.fileName);
                            return 1;
                        }
                    }
                    this.file.write(this.buf, packetSize);
                    this.bytesDownloaded += (long)packetSize;
                    LOG.debug("Fetched and wrote {} bytes of file: {}", (Object)this.bytesDownloaded, (Object)this.fileName);
                    if (this.bytesDownloaded >= this.size) {
                        return 0;
                    }
                    this.errorCount = 0;
                }
            }
            catch (ReplicationHandlerException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.warn("Error in fetching file: {} (downloaded {} of {} bytes)", new Object[]{this.fileName, this.bytesDownloaded, this.size, e});
                ++this.errorCount;
                if (this.errorCount > 5) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failed to fetch file: " + this.fileName + " (downloaded " + this.bytesDownloaded + " of " + this.size + " bytes" + ", error count: " + this.errorCount + " > " + 5 + ")", (Throwable)e);
                }
                return 2;
            }
        }

        private int readInt(byte[] b) {
            return (b[0] & 0xFF) << 24 | (b[1] & 0xFF) << 16 | (b[2] & 0xFF) << 8 | b[3] & 0xFF;
        }

        private long readLong(byte[] b) {
            return (long)(b[0] & 0xFF) << 56 | (long)(b[1] & 0xFF) << 48 | (long)(b[2] & 0xFF) << 40 | (long)(b[3] & 0xFF) << 32 | (long)(b[4] & 0xFF) << 24 | (long)((b[5] & 0xFF) << 16) | (long)((b[6] & 0xFF) << 8) | (long)(b[7] & 0xFF);
        }

        private void cleanup() {
            try {
                this.file.close();
            }
            catch (Exception e) {
                LOG.error("Error closing file: {}", (Object)this.saveAs, (Object)e);
            }
            if (this.bytesDownloaded != this.size) {
                try {
                    this.file.delete();
                }
                catch (Exception e) {
                    LOG.error("Error deleting file: {}", (Object)this.saveAs, (Object)e);
                }
                if (!this.aborted) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to download " + this.fileName + " completely. Downloaded " + this.bytesDownloaded + "!=" + this.size);
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private FastInputStream getStream() throws IOException {
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.set("command", new String[]{"filecontent"});
            params.set("generation", new String[]{Long.toString(this.indexGen)});
            params.set("qt", new String[]{"/replication"});
            if (this.isConf) {
                params.set("cf", new String[]{this.fileName});
            } else {
                params.set("file", new String[]{this.fileName});
            }
            if (IndexFetcher.this.useInternal) {
                params.set("compression", new String[]{"true"});
            }
            if (this.includeChecksum) {
                params.set("checksum", true);
            }
            params.set("wt", new String[]{"filestream"});
            if (this.bytesDownloaded > 0L) {
                params.set("offset", new String[]{Long.toString(this.bytesDownloaded)});
            }
            InputStream is = null;
            try (HttpSolrClient client = new HttpSolrClient(IndexFetcher.this.masterUrl, IndexFetcher.this.myHttpClient, null);){
                client.setSoTimeout(60000);
                client.setConnectionTimeout(15000);
                QueryRequest req = new QueryRequest((SolrParams)params);
                NamedList response = client.request((SolrRequest)req);
                is = (InputStream)response.get("stream");
                if (IndexFetcher.this.useInternal) {
                    is = new InflaterInputStream(is);
                }
                FastInputStream fastInputStream = new FastInputStream(is);
                return fastInputStream;
            }
            catch (Exception e) {
                org.apache.commons.io.IOUtils.closeQuietly(is);
                throw new IOException("Could not download file '" + this.fileName + "'", e);
            }
        }
    }

    private static interface FileInterface {
        public void sync() throws IOException;

        public void write(byte[] var1, int var2) throws IOException;

        public void close() throws Exception;

        public void delete() throws Exception;
    }

    private static class ReplicationHandlerException
    extends InterruptedException {
        public ReplicationHandlerException(String message) {
            super(message);
        }
    }

    protected static class CompareResult {
        boolean equal = false;
        boolean checkSummed = false;

        protected CompareResult() {
        }
    }
}

