/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.reflect;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Preconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableList;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableList$Builder;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableSet;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableSet$Builder;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.reflect.TypeCapture;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.reflect.TypeResolver;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.reflect.TypeToken$1;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.reflect.TypeToken$4;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.reflect.TypeToken$SimpleTypeToken;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.reflect.TypeToken$TypeSet;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.reflect.Types;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import javax.annotation.Nullable;

public abstract class TypeToken
extends TypeCapture
implements Serializable {
    private final Type runtimeType;
    private transient TypeResolver typeResolver;

    protected TypeToken() {
        this.runtimeType = this.capture();
        Preconditions.checkState(!(this.runtimeType instanceof TypeVariable), "Cannot construct a TypeToken for a type variable.\nYou probably meant to call new TypeToken<%s>(getClass()) that can resolve the type variable for you.\nIf you do need to create a TypeToken of a type variable, please use TypeToken.of() instead.", this.runtimeType);
    }

    private TypeToken(Type type) {
        this.runtimeType = (Type)Preconditions.checkNotNull(type);
    }

    public static TypeToken of(Class clazz) {
        return new TypeToken$SimpleTypeToken(clazz);
    }

    public static TypeToken of(Type type) {
        return new TypeToken$SimpleTypeToken(type);
    }

    public final Class getRawType() {
        Class clazz;
        Class clazz2 = clazz = TypeToken.getRawType(this.runtimeType);
        return clazz2;
    }

    private ImmutableSet getImmediateRawTypes() {
        ImmutableSet immutableSet = TypeToken.getRawTypes(this.runtimeType);
        return immutableSet;
    }

    public final TypeToken resolveType(Type type) {
        Preconditions.checkNotNull(type);
        TypeResolver typeResolver = this.typeResolver;
        if (typeResolver == null) {
            typeResolver = this.typeResolver = TypeResolver.accordingTo(this.runtimeType);
        }
        return TypeToken.of(typeResolver.resolveType(type));
    }

    private TypeToken resolveSupertype(Type type) {
        TypeToken typeToken = this.resolveType(type);
        typeToken.typeResolver = this.typeResolver;
        return typeToken;
    }

    @Nullable
    final TypeToken getGenericSuperclass() {
        if (this.runtimeType instanceof TypeVariable) {
            return this.boundAsSuperclass(((TypeVariable)this.runtimeType).getBounds()[0]);
        }
        if (this.runtimeType instanceof WildcardType) {
            return this.boundAsSuperclass(((WildcardType)this.runtimeType).getUpperBounds()[0]);
        }
        Type type = this.getRawType().getGenericSuperclass();
        if (type == null) {
            return null;
        }
        TypeToken typeToken = this.resolveSupertype(type);
        return typeToken;
    }

    @Nullable
    private TypeToken boundAsSuperclass(Type type) {
        TypeToken typeToken = TypeToken.of(type);
        if (typeToken.getRawType().isInterface()) {
            return null;
        }
        TypeToken typeToken2 = typeToken;
        return typeToken2;
    }

    final ImmutableList getGenericInterfaces() {
        if (this.runtimeType instanceof TypeVariable) {
            return this.boundsAsInterfaces(((TypeVariable)this.runtimeType).getBounds());
        }
        if (this.runtimeType instanceof WildcardType) {
            return this.boundsAsInterfaces(((WildcardType)this.runtimeType).getUpperBounds());
        }
        ImmutableList$Builder immutableList$Builder = ImmutableList.builder();
        for (Type type : this.getRawType().getGenericInterfaces()) {
            TypeToken typeToken = this.resolveSupertype(type);
            immutableList$Builder.add(typeToken);
        }
        return immutableList$Builder.build();
    }

    private ImmutableList boundsAsInterfaces(Type[] typeArray) {
        ImmutableList$Builder immutableList$Builder = ImmutableList.builder();
        for (Type type : typeArray) {
            TypeToken typeToken = TypeToken.of(type);
            if (!typeToken.getRawType().isInterface()) continue;
            immutableList$Builder.add(typeToken);
        }
        return immutableList$Builder.build();
    }

    public final TypeToken$TypeSet getTypes() {
        return new TypeToken$TypeSet(this);
    }

    public boolean equals(@Nullable Object object) {
        if (object instanceof TypeToken) {
            TypeToken typeToken = (TypeToken)object;
            return this.runtimeType.equals(typeToken.runtimeType);
        }
        return false;
    }

    public int hashCode() {
        return this.runtimeType.hashCode();
    }

    public String toString() {
        return Types.toString(this.runtimeType);
    }

    static Class getRawType(Type type) {
        return (Class)TypeToken.getRawTypes(type).iterator().next();
    }

    static ImmutableSet getRawTypes(Type type) {
        Preconditions.checkNotNull(type);
        ImmutableSet$Builder immutableSet$Builder = ImmutableSet.builder();
        new TypeToken$4(immutableSet$Builder).visit(type);
        return immutableSet$Builder.build();
    }

    static /* synthetic */ ImmutableSet access$200(TypeToken typeToken) {
        return typeToken.getImmediateRawTypes();
    }

    static /* synthetic */ Type access$400(TypeToken typeToken) {
        return typeToken.runtimeType;
    }

    /* synthetic */ TypeToken(Type type, TypeToken$1 typeToken$1) {
        this(type);
    }
}

