/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core;

import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.Attribute;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.AttributeException;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Contact;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Context;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Converter;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Decorator;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Expression;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Introspector;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Primitive;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Qualifier;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.TemplateLabel;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.stream.Style;
import java.lang.annotation.Annotation;

class AttributeLabel
extends TemplateLabel {
    private Decorator decorator;
    private Introspector detail;
    private Attribute label;
    private Class type;
    private String name;
    private String empty;

    public AttributeLabel(Contact contact, Attribute attribute) {
        this.detail = new Introspector(contact, this);
        this.decorator = new Qualifier(contact);
        this.type = contact.getType();
        this.empty = attribute.empty();
        this.name = attribute.name();
        this.label = attribute;
    }

    public Decorator getDecorator() {
        return this.decorator;
    }

    public Converter getConverter(Context context) {
        String string = this.getEmpty(context);
        Contact contact = this.getContact();
        if (!context.isPrimitive(contact)) {
            throw new AttributeException("Cannot use %s to represent %s", this.label, contact);
        }
        return new Primitive(context, contact, string);
    }

    public String getEmpty(Context context) {
        if (this.detail.isEmpty(this.empty)) {
            return null;
        }
        return this.empty;
    }

    public String getName(Context context) {
        Style style = context.getStyle();
        String string = this.detail.getName();
        return style.getAttribute(string);
    }

    public String getPath(Context context) {
        Expression expression = this.getExpression();
        String string = this.getName(context);
        return expression.getAttribute(string);
    }

    public String getName() {
        return this.detail.getName();
    }

    public String getPath() {
        Expression expression = this.getExpression();
        String string = this.getName();
        return expression.getAttribute(string);
    }

    public Expression getExpression() {
        return this.detail.getExpression();
    }

    public Annotation getAnnotation() {
        return this.label;
    }

    public String getOverride() {
        return this.name;
    }

    public Contact getContact() {
        return this.detail.getContact();
    }

    public Class getType() {
        return this.type;
    }

    public boolean isAttribute() {
        return true;
    }

    public boolean isRequired() {
        return this.label.required();
    }

    public boolean isData() {
        return false;
    }

    public String toString() {
        return this.detail.toString();
    }
}

