/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.util.HashMap;
import java.util.Map;

public abstract class FieldProperties {
    protected static final int INDEXED = 1;
    protected static final int TOKENIZED = 2;
    protected static final int STORED = 4;
    protected static final int BINARY = 8;
    protected static final int OMIT_NORMS = 16;
    protected static final int OMIT_TF_POSITIONS = 32;
    protected static final int STORE_TERMVECTORS = 64;
    protected static final int STORE_TERMPOSITIONS = 128;
    protected static final int STORE_TERMOFFSETS = 256;
    protected static final int MULTIVALUED = 512;
    protected static final int SORT_MISSING_FIRST = 1024;
    protected static final int SORT_MISSING_LAST = 2048;
    protected static final int REQUIRED = 4096;
    protected static final int OMIT_POSITIONS = 8192;
    protected static final int STORE_OFFSETS = 16384;
    protected static final int DOC_VALUES = 32768;
    protected static final int STORE_TERMPAYLOADS = 65536;
    static final String[] propertyNames = new String[]{"indexed", "tokenized", "stored", "binary", "omitNorms", "omitTermFreqAndPositions", "termVectors", "termPositions", "termOffsets", "multiValued", "sortMissingFirst", "sortMissingLast", "required", "omitPositions", "storeOffsetsWithPositions", "docValues", "termPayloads"};
    static final Map<String, Integer> propertyMap = new HashMap<String, Integer>();

    static String getPropertyName(int property) {
        return propertyNames[Integer.numberOfTrailingZeros(property)];
    }

    static int propertyNameToInt(String name, boolean failOnError) {
        for (int i = 0; i < propertyNames.length; ++i) {
            if (!propertyNames[i].equals(name)) continue;
            return 1 << i;
        }
        if (failOnError && !"default".equals(name)) {
            throw new IllegalArgumentException("Invalid field property: " + name);
        }
        return 0;
    }

    static String propertiesToString(int properties) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        while (properties != 0) {
            if (!first) {
                sb.append(',');
            }
            first = false;
            int bitpos = Integer.numberOfTrailingZeros(properties);
            sb.append(FieldProperties.getPropertyName(1 << bitpos));
            properties &= ~(1 << bitpos);
        }
        return sb.toString();
    }

    static boolean on(int bitfield, int props) {
        return (bitfield & props) != 0;
    }

    static boolean off(int bitfield, int props) {
        return (bitfield & props) == 0;
    }

    static int parseProperties(Map<String, ?> properties, boolean which, boolean failOnError) {
        int props = 0;
        for (Map.Entry<String, ?> entry : properties.entrySet()) {
            boolean boolVal;
            Object val = entry.getValue();
            if (val == null || (boolVal = val instanceof Boolean ? (Boolean)val : Boolean.parseBoolean(val.toString())) != which) continue;
            props |= FieldProperties.propertyNameToInt(entry.getKey(), failOnError);
        }
        return props;
    }

    static {
        for (String prop : propertyNames) {
            propertyMap.put(prop, FieldProperties.propertyNameToInt(prop, true));
        }
    }
}

