/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.rest.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.rest.BaseSolrResource;
import org.apache.solr.rest.GETable;
import org.apache.solr.rest.POSTable;
import org.apache.solr.rest.schema.BaseFieldTypeResource;
import org.apache.solr.rest.schema.FieldTypeResource;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.ManagedIndexSchema;
import org.apache.solr.schema.SchemaField;
import org.noggit.ObjectBuilder;
import org.restlet.data.MediaType;
import org.restlet.representation.Representation;
import org.restlet.resource.ResourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldTypeCollectionResource
extends BaseFieldTypeResource
implements GETable,
POSTable {
    private static final Logger log = LoggerFactory.getLogger(FieldTypeCollectionResource.class);
    private Map<String, List<String>> fieldsByFieldType;
    private Map<String, List<String>> dynamicFieldsByFieldType;

    @Override
    public void doInit() throws ResourceException {
        super.doInit();
        if (this.isExisting()) {
            this.fieldsByFieldType = this.getFieldsByFieldType();
            this.dynamicFieldsByFieldType = this.getDynamicFieldsByFieldType();
        }
    }

    @Override
    public Representation get() {
        try {
            ArrayList<SimpleOrderedMap<Object>> props = new ArrayList<SimpleOrderedMap<Object>>();
            TreeMap<String, FieldType> sortedFieldTypes = new TreeMap<String, FieldType>(this.getSchema().getFieldTypes());
            for (FieldType fieldType : sortedFieldTypes.values()) {
                props.add(this.getFieldTypeProperties(fieldType));
            }
            this.getSolrResponse().add("fieldTypes", props);
        }
        catch (Exception e) {
            this.getSolrResponse().setException(e);
        }
        this.handlePostExecution(log);
        return new BaseSolrResource.SolrOutputRepresentation();
    }

    @Override
    protected List<String> getFieldsWithFieldType(FieldType fieldType) {
        List<String> fields = this.fieldsByFieldType.get(fieldType.getTypeName());
        if (null == fields) {
            fields = Collections.emptyList();
        }
        return fields;
    }

    @Override
    protected List<String> getDynamicFieldsWithFieldType(FieldType fieldType) {
        List<String> dynamicFields = this.dynamicFieldsByFieldType.get(fieldType.getTypeName());
        if (null == dynamicFields) {
            dynamicFields = Collections.emptyList();
        }
        return dynamicFields;
    }

    private Map<String, List<String>> getFieldsByFieldType() {
        HashMap<String, List<String>> fieldsByFieldType = new HashMap<String, List<String>>();
        for (SchemaField schemaField : this.getSchema().getFields().values()) {
            String fieldType = schemaField.getType().getTypeName();
            ArrayList<String> fields = (ArrayList<String>)fieldsByFieldType.get(fieldType);
            if (null == fields) {
                fields = new ArrayList<String>();
                fieldsByFieldType.put(fieldType, fields);
            }
            fields.add(schemaField.getName());
        }
        for (List fields : fieldsByFieldType.values()) {
            Collections.sort(fields);
        }
        return fieldsByFieldType;
    }

    private Map<String, List<String>> getDynamicFieldsByFieldType() {
        HashMap<String, List<String>> dynamicFieldsByFieldType = new HashMap<String, List<String>>();
        for (SchemaField schemaField : this.getSchema().getDynamicFieldPrototypes()) {
            String fieldType = schemaField.getType().getTypeName();
            ArrayList<String> dynamicFields = (ArrayList<String>)dynamicFieldsByFieldType.get(fieldType);
            if (null == dynamicFields) {
                dynamicFields = new ArrayList<String>();
                dynamicFieldsByFieldType.put(fieldType, dynamicFields);
            }
            dynamicFields.add(schemaField.getName());
        }
        return dynamicFieldsByFieldType;
    }

    @Override
    public Representation post(Representation entity) {
        try {
            if (!this.getSchema().isMutable()) {
                String message = "This IndexSchema is not mutable.";
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "This IndexSchema is not mutable.");
            }
            if (null == entity.getMediaType()) {
                entity.setMediaType(MediaType.APPLICATION_JSON);
            }
            if (!entity.getMediaType().equals((Object)MediaType.APPLICATION_JSON, true)) {
                String message = "Only media type " + MediaType.APPLICATION_JSON.toString() + " is accepted." + "  Request has media type " + entity.getMediaType().toString() + ".";
                log.error(message);
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, message);
            }
            Object object = ObjectBuilder.fromJSON((String)entity.getText());
            if (!(object instanceof List)) {
                String message = "Invalid JSON type " + object.getClass().getName() + ", expected List of field type definitions in the form of" + " (ignore the backslashes): [{\"name\":\"text_general\",\"class\":\"solr.TextField\", ...}, {...}, ...]";
                log.error(message);
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, message);
            }
            List fieldTypeList = (List)object;
            if (fieldTypeList.size() > 0) {
                this.addOrUpdateFieldTypes(fieldTypeList);
            }
        }
        catch (Exception e) {
            this.getSolrResponse().setException(e);
        }
        this.handlePostExecution(log);
        return new BaseSolrResource.SolrOutputRepresentation();
    }

    /*
     * WARNING - void declaration
     */
    protected void addOrUpdateFieldTypes(List<Map<String, Object>> fieldTypeList) throws Exception {
        ArrayList<FieldType> newFieldTypes = new ArrayList<FieldType>(fieldTypeList.size());
        ManagedIndexSchema oldSchema = (ManagedIndexSchema)this.getSchema();
        for (Map<String, Object> map : fieldTypeList) {
            void var5_5;
            if (1 == map.size() && map.containsKey("fieldType")) {
                Map map2 = (Map)map.get("fieldType");
            }
            FieldType newFieldType = FieldTypeResource.buildFieldTypeFromJson(oldSchema, (String)var5_5.get("name"), (Map<String, Object>)var5_5);
            newFieldTypes.add(newFieldType);
        }
        this.addNewFieldTypes(newFieldTypes, oldSchema);
    }
}

