/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.processor.IgnoreCommitOptimizeUpdateProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IgnoreCommitOptimizeUpdateProcessorFactory
extends UpdateRequestProcessorFactory {
    public static final Logger log = LoggerFactory.getLogger(IgnoreCommitOptimizeUpdateProcessorFactory.class);
    private static final String DEFAULT_RESPONSE_MSG = "Explicit commit/optimize requests are forbidden!";
    protected SolrException.ErrorCode errorCode;
    protected String responseMsg;
    protected boolean ignoreOptimizeOnly = false;

    @Override
    public void init(NamedList args) {
        SolrParams params;
        SolrParams solrParams = params = args != null ? SolrParams.toSolrParams((NamedList)args) : null;
        if (params == null) {
            this.errorCode = SolrException.ErrorCode.FORBIDDEN;
            this.responseMsg = DEFAULT_RESPONSE_MSG;
            this.ignoreOptimizeOnly = false;
            return;
        }
        this.ignoreOptimizeOnly = params.getBool("ignoreOptimizeOnly", false);
        int statusCode = params.getInt("statusCode", SolrException.ErrorCode.FORBIDDEN.code);
        if (statusCode == 200) {
            this.errorCode = null;
            this.responseMsg = params.get("responseMessage");
        } else {
            this.errorCode = SolrException.ErrorCode.getErrorCode((int)statusCode);
            if (this.errorCode == SolrException.ErrorCode.UNKNOWN) {
                StringBuilder validCodes = new StringBuilder();
                int appended = 0;
                for (SolrException.ErrorCode code : SolrException.ErrorCode.values()) {
                    if (code == SolrException.ErrorCode.UNKNOWN) continue;
                    if (appended++ > 0) {
                        validCodes.append(", ");
                    }
                    validCodes.append(code.code);
                }
                throw new IllegalArgumentException("Configured status code " + statusCode + " not supported! Please choose one of: " + validCodes.toString());
            }
            this.responseMsg = params.get("responseMessage", DEFAULT_RESPONSE_MSG);
        }
    }

    @Override
    public UpdateRequestProcessor getInstance(SolrQueryRequest req, SolrQueryResponse rsp, UpdateRequestProcessor next) {
        return new IgnoreCommitOptimizeUpdateProcessor(rsp, this, next);
    }
}

