/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.mlt;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queries.mlt.MoreLikeThis;
import org.apache.lucene.search.Query;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrQueryRequestBase;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.QParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudMLTQParser
extends QParser {
    private static Logger log = LoggerFactory.getLogger(CloudMLTQParser.class);

    public CloudMLTQParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        super(qstr, localParams, params, req);
    }

    @Override
    public Query parse() {
        String id = this.localParams.get("v");
        SolrDocument doc = this.getDocument(id);
        if (doc == null) {
            new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Error completing MLT request. Could not fetch document with id [" + id + "]");
        }
        MoreLikeThis mlt = new MoreLikeThis((IndexReader)this.req.getSearcher().getIndexReader());
        mlt.setMinTermFreq(this.localParams.getInt("mintf", 1));
        mlt.setMinDocFreq(this.localParams.getInt("mindf", 0));
        if (this.localParams.get("minwl") != null) {
            mlt.setMinWordLen(this.localParams.getInt("minwl").intValue());
        }
        if (this.localParams.get("maxwl") != null) {
            mlt.setMaxWordLen(this.localParams.getInt("maxwl").intValue());
        }
        mlt.setAnalyzer(this.req.getSchema().getIndexAnalyzer());
        String[] qf = this.localParams.getParams("qf");
        HashMap<String, Collection> filteredDocument = new HashMap<String, Collection>();
        if (qf != null) {
            mlt.setFieldNames(qf);
            for (String field : qf) {
                filteredDocument.put(field, doc.getFieldValues(field));
            }
        } else {
            Map<String, SchemaField> fields = this.req.getSchema().getFields();
            ArrayList<String> fieldNames = new ArrayList<String>();
            for (String field : doc.getFieldNames()) {
                if (!fields.get(field).stored() || !fields.get(field).getType().isExplicitAnalyzer()) continue;
                fieldNames.add(field);
                filteredDocument.put(field, doc.getFieldValues(field));
            }
            mlt.setFieldNames(fieldNames.toArray(new String[fieldNames.size()]));
        }
        try {
            return mlt.like(filteredDocument);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Bad Request");
        }
    }

    private SolrDocument getDocument(String id) {
        SolrCore core = this.req.getCore();
        SolrQueryResponse rsp = new SolrQueryResponse();
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.add("id", new String[]{id});
        SolrQueryRequestBase request = new SolrQueryRequestBase(core, (SolrParams)params){};
        core.getRequestHandler("/get").handleRequest(request, rsp);
        NamedList response = rsp.getValues();
        return (SolrDocument)response.get("doc");
    }
}

