/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.rest.schema;

import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.solr.common.SolrException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FieldTypeXmlAdapter {
    public static Node toNode(Map<String, ?> json) {
        DocumentBuilder docBuilder;
        try {
            docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
        Document doc = docBuilder.newDocument();
        Element fieldType = doc.createElement("fieldType");
        FieldTypeXmlAdapter.appendAttrs(fieldType, json);
        Element analyzer = FieldTypeXmlAdapter.transformAnalyzer(doc, json, "analyzer", null);
        if (analyzer != null) {
            fieldType.appendChild(analyzer);
        }
        if ((analyzer = FieldTypeXmlAdapter.transformAnalyzer(doc, json, "indexAnalyzer", "index")) != null) {
            fieldType.appendChild(analyzer);
        }
        if ((analyzer = FieldTypeXmlAdapter.transformAnalyzer(doc, json, "queryAnalyzer", "query")) != null) {
            fieldType.appendChild(analyzer);
        }
        if ((analyzer = FieldTypeXmlAdapter.transformAnalyzer(doc, json, "multiTermAnalyzer", "multiterm")) != null) {
            fieldType.appendChild(analyzer);
        }
        return fieldType;
    }

    protected static Element transformAnalyzer(Document doc, Map<String, ?> json, String jsonFieldName, String analyzerType) {
        Object jsonField = json.get(jsonFieldName);
        if (jsonField == null) {
            return null;
        }
        if (!(jsonField instanceof Map)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid fieldType definition! Expected JSON object for " + jsonFieldName + " not a " + jsonField.getClass().getName());
        }
        return FieldTypeXmlAdapter.createAnalyzerElement(doc, analyzerType, (Map)jsonField);
    }

    protected static Element createAnalyzerElement(Document doc, String type, Map<String, ?> json) {
        Map tokenizerJson;
        List charFilters;
        Element analyzer = doc.createElement("analyzer");
        if (type != null) {
            analyzer.setAttribute("type", type);
        }
        if ((charFilters = (List)json.get("charFilters")) != null) {
            FieldTypeXmlAdapter.appendFilterElements(doc, analyzer, "charFilter", charFilters);
        }
        if ((tokenizerJson = (Map)json.get("tokenizer")) == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Analyzer must define a tokenizer!");
        }
        String tokClass = (String)tokenizerJson.get("class");
        if (tokClass == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Every tokenizer must define a class property!");
        }
        analyzer.appendChild(FieldTypeXmlAdapter.appendAttrs(doc.createElement("tokenizer"), tokenizerJson));
        List filters = (List)json.get("filters");
        if (filters != null) {
            FieldTypeXmlAdapter.appendFilterElements(doc, analyzer, "filter", filters);
        }
        return analyzer;
    }

    protected static void appendFilterElements(Document doc, Element analyzer, String filterName, List<Map<String, ?>> filters) {
        for (Map<String, ?> next : filters) {
            String filterClass = (String)next.get("class");
            if (filterClass == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Every " + filterName + " must define a class property!");
            }
            analyzer.appendChild(FieldTypeXmlAdapter.appendAttrs(doc.createElement(filterName), next));
        }
    }

    protected static Element appendAttrs(Element elm, Map<String, ?> json) {
        for (Map.Entry<String, ?> entry : json.entrySet()) {
            Object val = entry.getValue();
            if (val == null || val instanceof Map) continue;
            elm.setAttribute(entry.getKey(), val.toString());
        }
        return elm;
    }
}

