/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.response;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.common.EnumFieldValue;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.util.Base64;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.ResponseWriterUtil;
import org.apache.solr.response.ResultContext;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.response.WriteableValue;
import org.apache.solr.response.transform.DocTransformer;
import org.apache.solr.response.transform.TransformContext;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.TrieDateField;
import org.apache.solr.search.DocList;
import org.apache.solr.search.ReturnFields;
import org.apache.solr.util.FastWriter;

public abstract class TextResponseWriter {
    static final char[] indentChars = new char[81];
    protected final FastWriter writer;
    protected final IndexSchema schema;
    protected final SolrQueryRequest req;
    protected final SolrQueryResponse rsp;
    protected ReturnFields returnFields;
    protected int level;
    protected boolean doIndent;
    protected Calendar cal;

    public TextResponseWriter(Writer writer, SolrQueryRequest req, SolrQueryResponse rsp) {
        this.writer = FastWriter.wrap(writer);
        this.schema = req.getSchema();
        this.req = req;
        this.rsp = rsp;
        String indent = req.getParams().get("indent");
        if (indent != null && !"".equals(indent) && !"off".equals(indent)) {
            this.doIndent = true;
        }
        this.returnFields = rsp.getReturnFields();
    }

    public void close() throws IOException {
        this.writer.flushBuffer();
    }

    public Writer getWriter() {
        return this.writer;
    }

    public void indent() throws IOException {
        if (this.doIndent) {
            this.indent(this.level);
        }
    }

    public void indent(int lev) throws IOException {
        this.writer.write(indentChars, 0, Math.min((lev << 1) + 1, indentChars.length));
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public int level() {
        return this.level;
    }

    public int incLevel() {
        return ++this.level;
    }

    public int decLevel() {
        return --this.level;
    }

    public void setIndent(boolean doIndent) {
        this.doIndent = doIndent;
    }

    public abstract void writeNamedList(String var1, NamedList var2) throws IOException;

    public final void writeVal(String name, Object val) throws IOException {
        if (val == null) {
            this.writeNull(name);
        } else if (val instanceof String) {
            this.writeStr(name, val.toString(), true);
        } else if (val instanceof IndexableField) {
            IndexableField f = (IndexableField)val;
            SchemaField sf = this.schema.getFieldOrNull(f.name());
            if (sf != null) {
                sf.getType().write(this, name, f);
            } else {
                this.writeStr(name, f.stringValue(), true);
            }
        } else if (val instanceof Number) {
            if (val instanceof Integer) {
                this.writeInt(name, val.toString());
            } else if (val instanceof Long) {
                this.writeLong(name, val.toString());
            } else if (val instanceof Float) {
                this.writeFloat(name, ((Float)val).floatValue());
            } else if (val instanceof Double) {
                this.writeDouble(name, (Double)val);
            } else if (val instanceof Short) {
                this.writeInt(name, val.toString());
            } else if (val instanceof Byte) {
                this.writeInt(name, val.toString());
            } else {
                this.writeStr(name, val.getClass().getName() + ':' + val.toString(), true);
            }
        } else if (val instanceof Boolean) {
            this.writeBool(name, val.toString());
        } else if (val instanceof Date) {
            this.writeDate(name, (Date)val);
        } else if (val instanceof Document) {
            SolrDocument doc = this.toSolrDocument((Document)val);
            DocTransformer transformer = this.returnFields.getTransformer();
            if (transformer != null) {
                TransformContext context = new TransformContext();
                context.req = this.req;
                transformer.setContext(context);
                transformer.transform(doc, -1);
            }
            this.writeSolrDocument(name, doc, this.returnFields, 0);
        } else if (val instanceof SolrDocument) {
            this.writeSolrDocument(name, (SolrDocument)val, this.returnFields, 0);
        } else if (val instanceof ResultContext) {
            this.writeDocuments(name, (ResultContext)val, this.returnFields);
        } else if (val instanceof DocList) {
            ResultContext ctx = new ResultContext();
            ctx.docs = (DocList)val;
            this.writeDocuments(name, ctx, this.returnFields);
        } else if (val instanceof SolrDocumentList) {
            this.writeSolrDocumentList(name, (SolrDocumentList)val, this.returnFields);
        } else if (val instanceof Map) {
            this.writeMap(name, (Map)val, false, true);
        } else if (val instanceof NamedList) {
            this.writeNamedList(name, (NamedList)val);
        } else if (val instanceof TupleStream) {
            this.writeTupleStream((TupleStream)val);
        } else if (val instanceof Iterable) {
            this.writeArray(name, ((Iterable)val).iterator());
        } else if (val instanceof Object[]) {
            this.writeArray(name, (Object[])val);
        } else if (val instanceof Iterator) {
            this.writeArray(name, (Iterator)val);
        } else if (val instanceof byte[]) {
            byte[] arr = (byte[])val;
            this.writeByteArr(name, arr, 0, arr.length);
        } else if (val instanceof BytesRef) {
            BytesRef arr = (BytesRef)val;
            this.writeByteArr(name, arr.bytes, arr.offset, arr.length);
        } else if (val instanceof EnumFieldValue) {
            this.writeStr(name, val.toString(), true);
        } else if (val instanceof WriteableValue) {
            ((WriteableValue)val).write(name, this);
        } else {
            this.writeStr(name, val.getClass().getName() + ':' + val.toString(), true);
        }
    }

    public abstract void writeStartDocumentList(String var1, long var2, int var4, long var5, Float var7) throws IOException;

    public abstract void writeSolrDocument(String var1, SolrDocument var2, ReturnFields var3, int var4) throws IOException;

    public abstract void writeEndDocumentList() throws IOException;

    public final void writeSolrDocumentList(String name, SolrDocumentList docs, ReturnFields returnFields) throws IOException {
        this.writeStartDocumentList(name, docs.getStart(), docs.size(), docs.getNumFound(), docs.getMaxScore());
        for (int i = 0; i < docs.size(); ++i) {
            this.writeSolrDocument(null, (SolrDocument)docs.get(i), returnFields, i);
        }
        this.writeEndDocumentList();
    }

    public final SolrDocument toSolrDocument(Document doc) {
        return ResponseWriterUtil.toSolrDocument(doc, this.schema);
    }

    public final void writeDocuments(String name, ResultContext res, ReturnFields fields) throws IOException {
        DocList ids = res.docs;
        TransformContext context = new TransformContext();
        context.query = res.query;
        context.wantsScores = fields.wantsScore() && ids.hasScores();
        context.req = this.req;
        this.writeStartDocumentList(name, ids.offset(), ids.size(), ids.matches(), context.wantsScores ? new Float(ids.maxScore()) : null);
        DocTransformer transformer = fields.getTransformer();
        context.searcher = this.req.getSearcher();
        context.iterator = ids.iterator();
        if (transformer != null) {
            transformer.setContext(context);
        }
        int sz = ids.size();
        Set<String> fnames = fields.getLuceneFieldNames();
        for (int i = 0; i < sz; ++i) {
            int id = context.iterator.nextDoc();
            Document doc = context.searcher.doc(id, fnames);
            SolrDocument sdoc = this.toSolrDocument(doc);
            if (transformer != null) {
                transformer.transform(sdoc, id);
            }
            this.writeSolrDocument(null, sdoc, this.returnFields, i);
        }
        if (transformer != null) {
            transformer.setContext(null);
        }
        this.writeEndDocumentList();
    }

    public abstract void writeStr(String var1, String var2, boolean var3) throws IOException;

    public abstract void writeMap(String var1, Map var2, boolean var3, boolean var4) throws IOException;

    public void writeArray(String name, Object[] val) throws IOException {
        this.writeArray(name, Arrays.asList(val).iterator());
    }

    public abstract void writeArray(String var1, Iterator var2) throws IOException;

    public abstract void writeNull(String var1) throws IOException;

    public abstract void writeInt(String var1, String var2) throws IOException;

    public void writeInt(String name, int val) throws IOException {
        this.writeInt(name, Integer.toString(val));
    }

    public abstract void writeLong(String var1, String var2) throws IOException;

    public void writeLong(String name, long val) throws IOException {
        this.writeLong(name, Long.toString(val));
    }

    public abstract void writeBool(String var1, String var2) throws IOException;

    public void writeBool(String name, boolean val) throws IOException {
        this.writeBool(name, Boolean.toString(val));
    }

    public abstract void writeFloat(String var1, String var2) throws IOException;

    public void writeFloat(String name, float val) throws IOException {
        String s = Float.toString(val);
        if (val > Float.NEGATIVE_INFINITY && val < Float.POSITIVE_INFINITY) {
            this.writeFloat(name, s);
        } else {
            this.writeStr(name, s, false);
        }
    }

    public void writeTupleStream(TupleStream tupleStream) throws IOException {
        Tuple tuple;
        tupleStream.open();
        this.writeStartDocumentList("response", -1L, -1, -1L, null);
        boolean isFirst = true;
        do {
            tuple = tupleStream.read();
            if (!isFirst) {
                this.writer.write(",");
            }
            this.writeMap(null, tuple.fields, false, true);
            isFirst = false;
        } while (!tuple.EOF);
        this.writeEndDocumentList();
        tupleStream.close();
    }

    public abstract void writeDouble(String var1, String var2) throws IOException;

    public void writeDouble(String name, double val) throws IOException {
        String s = Double.toString(val);
        if (val > Double.NEGATIVE_INFINITY && val < Double.POSITIVE_INFINITY) {
            this.writeDouble(name, s);
        } else {
            this.writeStr(name, s, false);
        }
    }

    public void writeDate(String name, Date val) throws IOException {
        this.writeDate(name, TrieDateField.formatExternal(val));
    }

    public abstract void writeDate(String var1, String var2) throws IOException;

    public void writeByteArr(String name, byte[] buf, int offset, int len) throws IOException {
        this.writeStr(name, Base64.byteArrayToBase64((byte[])buf, (int)offset, (int)len), false);
    }

    static {
        Arrays.fill(indentChars, ' ');
        TextResponseWriter.indentChars[0] = 10;
    }
}

