/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.handler.component.HttpShardHandlerFactory;
import org.apache.solr.handler.component.ShardHandler;
import org.apache.solr.util.plugin.PluginInfoInitialized;

public abstract class ShardHandlerFactory {
    public static final PluginInfo DEFAULT_SHARDHANDLER_INFO = new PluginInfo("shardHandlerFactory", (Map<String, String>)ImmutableMap.of((Object)"class", (Object)HttpShardHandlerFactory.class.getName()), null, Collections.emptyList());

    public abstract ShardHandler getShardHandler();

    public abstract void close();

    public static ShardHandlerFactory newInstance(PluginInfo info, SolrResourceLoader loader) {
        if (info == null) {
            info = DEFAULT_SHARDHANDLER_INFO;
        }
        try {
            ShardHandlerFactory shf = loader.findClass(info.className, ShardHandlerFactory.class).newInstance();
            if (PluginInfoInitialized.class.isAssignableFrom(shf.getClass())) {
                ((PluginInfoInitialized)PluginInfoInitialized.class.cast(shf)).init(info);
            }
            return shf;
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, String.format(Locale.ROOT, "Error instantiating shardHandlerFactory class [%s]: %s", info.className, e.getMessage()));
        }
    }
}

