/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.handler.component.PivotFacetHelper;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.StatsComponent;
import org.apache.solr.handler.component.StatsField;
import org.apache.solr.handler.component.StatsInfo;
import org.apache.solr.handler.component.StatsValues;
import org.apache.solr.request.SimpleFacets;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.SyntaxError;

public class PivotFacetProcessor
extends SimpleFacets {
    protected SolrParams params;

    public PivotFacetProcessor(SolrQueryRequest req, DocSet docs, SolrParams params, ResponseBuilder rb) {
        super(req, docs, params, rb);
        this.params = params;
    }

    public SimpleOrderedMap<List<NamedList<Object>>> process(String[] pivots) throws IOException {
        if (!this.rb.doFacets || pivots == null) {
            return null;
        }
        StatsInfo statsInfo = this.rb._statsInfo;
        SimpleOrderedMap pivotResponse = new SimpleOrderedMap();
        for (String pivotList : pivots) {
            try {
                this.parseParams("facet.pivot", pivotList);
            }
            catch (SyntaxError e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
            }
            List pivotFields = StrUtils.splitSmart((String)this.facetValue, (String)",", (boolean)true);
            if (pivotFields.size() < 1) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Pivot Facet needs at least one field name: " + pivotList);
            }
            SolrIndexSearcher searcher = this.rb.req.getSearcher();
            for (String fieldName : pivotFields) {
                SchemaField sfield = searcher.getSchema().getField(fieldName);
                if (sfield != null) continue;
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "\"" + fieldName + "\" is not a valid field name in pivot: " + pivotList);
            }
            String refineKey = null;
            List<StatsField> statsFields = Collections.emptyList();
            if (null != this.localParams) {
                refineKey = this.localParams.get("fpt");
                String statsLocalParam = this.localParams.get("stats");
                if (null != refineKey && null != statsLocalParam && null == statsInfo) {
                    statsInfo = new StatsInfo(this.rb);
                }
                statsFields = PivotFacetProcessor.getTaggedStatsFields(statsInfo, statsLocalParam);
            }
            if (null != refineKey) {
                String[] refinementValuesByField;
                for (String refinements : refinementValuesByField = this.params.getParams("fpt" + refineKey)) {
                    pivotResponse.addAll(this.processSingle(pivotFields, refinements, statsFields));
                }
                continue;
            }
            pivotResponse.addAll(this.processSingle(pivotFields, null, statsFields));
        }
        return pivotResponse;
    }

    private SimpleOrderedMap<List<NamedList<Object>>> processSingle(List<String> pivotFields, String refinements, List<StatsField> statsFields) throws IOException {
        NamedList facetCounts;
        SolrIndexSearcher searcher = this.rb.req.getSearcher();
        SimpleOrderedMap pivotResponse = new SimpleOrderedMap();
        String field = pivotFields.get(0);
        SchemaField sfield = searcher.getSchema().getField(field);
        LinkedList<String> fnames = new LinkedList<String>();
        for (int i = pivotFields.size() - 1; i > 1; --i) {
            fnames.push(pivotFields.get(i));
        }
        LinkedList<String> vnames = new LinkedList<String>();
        if (null != refinements) {
            List<String> refinementValuesByField = PivotFacetHelper.decodeRefinementValuePath(refinements);
            for (int i = refinementValuesByField.size() - 1; i > 0; --i) {
                vnames.push(refinementValuesByField.get(i));
            }
            String firstFieldsValues = refinementValuesByField.get(0);
            facetCounts = new NamedList();
            facetCounts.add(firstFieldsValues, (Object)this.getSubsetSize(this.docs, sfield, firstFieldsValues));
        } else {
            facetCounts = this.getTermCountsForPivots(field, this.docs);
        }
        if (pivotFields.size() > 1) {
            String subField = pivotFields.get(1);
            pivotResponse.add(this.key, this.doPivots((NamedList<Integer>)facetCounts, field, subField, fnames, vnames, this.docs, statsFields));
        } else {
            pivotResponse.add(this.key, this.doPivots((NamedList<Integer>)facetCounts, field, null, fnames, vnames, this.docs, statsFields));
        }
        return pivotResponse;
    }

    private static List<StatsField> getTaggedStatsFields(StatsInfo statsInfo, String statsLocalParam) {
        if (null == statsLocalParam || null == statsInfo) {
            return Collections.emptyList();
        }
        ArrayList<StatsField> fields = new ArrayList<StatsField>(7);
        List statsAr = StrUtils.splitSmart((String)statsLocalParam, (char)',');
        if (1 < statsAr.size()) {
            String msg = "stats local param of facet.pivotmay not include tags separated by a comma - please use a common tag on all stats.field params you wish to compute under this pivot";
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, msg);
        }
        for (String stat : statsAr) {
            fields.addAll(statsInfo.getStatsFieldsByTag(stat));
        }
        return fields;
    }

    protected List<NamedList<Object>> doPivots(NamedList<Integer> superFacets, String field, String subField, Deque<String> fnames, Deque<String> vnames, DocSet docs, List<StatsField> statsFields) throws IOException {
        boolean isShard = this.rb.req.getParams().getBool("isShard", false);
        SolrIndexSearcher searcher = this.rb.req.getSearcher();
        SchemaField sfield = searcher.getSchema().getField(field);
        FieldType ftype = sfield.getType();
        String nextField = fnames.poll();
        BytesRefBuilder termval = new BytesRefBuilder();
        ArrayList<NamedList<Object>> values = new ArrayList<NamedList<Object>>(superFacets.size());
        for (Map.Entry kv : superFacets) {
            if ((Integer)kv.getValue() < this.getMinCountForField(field)) continue;
            String fieldValue = (String)kv.getKey();
            int pivotCount = (Integer)kv.getValue();
            SimpleOrderedMap pivot = new SimpleOrderedMap();
            pivot.add("field", (Object)field);
            if (null == fieldValue) {
                pivot.add("value", null);
            } else {
                ftype.readableToIndexed(fieldValue, termval);
                pivot.add("value", ftype.toObject(sfield, termval.get()));
            }
            pivot.add("count", (Object)pivotCount);
            DocSet subset = this.getSubset(docs, sfield, fieldValue);
            if (subField != null) {
                NamedList facetCounts;
                if (!vnames.isEmpty()) {
                    String val = vnames.pop();
                    facetCounts = new NamedList();
                    facetCounts.add(val, (Object)this.getSubsetSize(subset, searcher.getSchema().getField(subField), val));
                } else {
                    facetCounts = this.getTermCountsForPivots(subField, subset);
                }
                if (facetCounts.size() >= 1) {
                    pivot.add("pivot", this.doPivots((NamedList<Integer>)facetCounts, subField, nextField, fnames, vnames, subset, statsFields));
                }
            }
            if ((isShard || 0 < pivotCount) && !statsFields.isEmpty()) {
                LinkedHashMap<String, StatsValues> stv = new LinkedHashMap<String, StatsValues>();
                for (StatsField statsField : statsFields) {
                    stv.put(statsField.getOutputKey(), statsField.computeLocalStatsValues(subset));
                }
                pivot.add("stats", StatsComponent.convertToResponse(stv));
            }
            values.add((NamedList<Object>)pivot);
        }
        fnames.push(nextField);
        return values;
    }

    private int getSubsetSize(DocSet base, SchemaField field, String pivotValue) throws IOException {
        FieldType ft = field.getType();
        if (null == pivotValue) {
            Query query = ft.getRangeQuery(null, field, null, null, false, false);
            DocSet hasVal = this.searcher.getDocSet(query);
            return base.andNotSize(hasVal);
        }
        Query query = ft.getFieldQuery(null, field, pivotValue);
        return this.searcher.numDocs(query, base);
    }

    private DocSet getSubset(DocSet base, SchemaField field, String pivotValue) throws IOException {
        FieldType ft = field.getType();
        if (null == pivotValue) {
            Query query = ft.getRangeQuery(null, field, null, null, false, false);
            DocSet hasVal = this.searcher.getDocSet(query);
            return base.andNot(hasVal);
        }
        Query query = ft.getFieldQuery(null, field, pivotValue);
        return this.searcher.getDocSet(query, base);
    }

    private int getMinCountForField(String fieldname) {
        return this.params.getFieldInt(fieldname, "facet.pivot.mincount", 1);
    }
}

