/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.net.ConnectException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.http.client.HttpClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.impl.LBHttpSolrClient;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.cloud.CloudDescriptor;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.component.HttpShardHandlerFactory;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.ShardHandler;
import org.apache.solr.handler.component.ShardHandlerFactory;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.request.SolrQueryRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class HttpShardHandler
extends ShardHandler {
    private HttpShardHandlerFactory httpShardHandlerFactory;
    private CompletionService<ShardResponse> completionService;
    private Set<Future<ShardResponse>> pending;
    private Map<String, List<String>> shardToURLs;
    private HttpClient httpClient;
    protected static Logger log = LoggerFactory.getLogger(HttpShardHandler.class);

    public HttpShardHandler(HttpShardHandlerFactory httpShardHandlerFactory, HttpClient httpClient) {
        this.httpClient = httpClient;
        this.httpShardHandlerFactory = httpShardHandlerFactory;
        this.completionService = httpShardHandlerFactory.newCompletionService();
        this.pending = new HashSet<Future<ShardResponse>>();
        this.shardToURLs = new HashMap<String, List<String>>();
    }

    private List<String> getURLs(ShardRequest sreq, String shard) {
        List<String> urls = this.shardToURLs.get(shard);
        if (urls == null) {
            urls = this.httpShardHandlerFactory.makeURLList(shard);
            this.preferCurrentHostForDistributedReq(sreq, urls);
            this.shardToURLs.put(shard, urls);
        }
        return urls;
    }

    private void preferCurrentHostForDistributedReq(ShardRequest sreq, List<String> urls) {
        String currentHostAddress;
        if (sreq == null || sreq.rb == null || sreq.rb.req == null || urls == null || urls.size() <= 1) {
            return;
        }
        SolrQueryRequest req = sreq.rb.req;
        if (!req.getOriginalParams().getBool("preferLocalShards", false)) {
            return;
        }
        SolrCore core = req.getCore();
        ZkController zkController = core != null ? core.getCoreDescriptor().getCoreContainer().getZkController() : null;
        String string = currentHostAddress = zkController != null ? zkController.getBaseUrl() : null;
        if (currentHostAddress == null) {
            log.debug("Couldn't determine current host address to prefer local shards because either core is null? {} or there is no ZkController? {}", (Object)(core == null ? 1 : 0), (Object)(zkController == null ? 1 : 0));
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Trying to prefer local shard on {} among the urls: {}", (Object)currentHostAddress, (Object)Arrays.toString(urls.toArray()));
        }
        ListIterator<String> itr = urls.listIterator();
        while (itr.hasNext()) {
            String url = itr.next();
            if (!url.startsWith(currentHostAddress)) continue;
            itr.remove();
            urls.add(0, url);
            if (!log.isDebugEnabled()) break;
            log.debug("Applied local shard preference for urls: {}", (Object)Arrays.toString(urls.toArray()));
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void submit(final ShardRequest sreq, final String shard, final ModifiableSolrParams params) {
        final List<String> urls = this.getURLs(sreq, shard);
        Callable<ShardResponse> task = new Callable<ShardResponse>(){

            @Override
            public ShardResponse call() throws Exception {
                long startTime;
                ShardResponse srsp;
                block19: {
                    srsp = new ShardResponse();
                    if (sreq.nodeName != null) {
                        srsp.setNodeName(sreq.nodeName);
                    }
                    srsp.setShardRequest(sreq);
                    srsp.setShard(shard);
                    SimpleSolrResponse ssr = new SimpleSolrResponse();
                    srsp.setSolrResponse(ssr);
                    startTime = System.nanoTime();
                    try {
                        params.remove("wt");
                        params.remove("version");
                        QueryRequest req = HttpShardHandler.this.makeQueryRequest(sreq, params, shard);
                        req.setMethod(SolrRequest.METHOD.POST);
                        if (urls.size() == 0) {
                            throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "no servers hosting shard: " + shard);
                        }
                        if (urls.size() <= 1) {
                            String url = (String)urls.get(0);
                            srsp.setShardAddress(url);
                            try (HttpSolrClient client = new HttpSolrClient(url, HttpShardHandler.this.httpClient);){
                                ssr.nl = client.request((SolrRequest)req);
                                break block19;
                            }
                        }
                        LBHttpSolrClient.Rsp rsp = HttpShardHandler.this.httpShardHandlerFactory.makeLoadBalancedRequest(req, urls);
                        ssr.nl = rsp.getResponse();
                        srsp.setShardAddress(rsp.getServer());
                    }
                    catch (ConnectException cex) {
                        srsp.setException(cex);
                    }
                    catch (Exception th) {
                        srsp.setException(th);
                        if (th instanceof SolrException) {
                            srsp.setResponseCode(((SolrException)((Object)th)).code());
                        }
                        srsp.setResponseCode(-1);
                    }
                }
                ssr.elapsedTime = TimeUnit.MILLISECONDS.convert(System.nanoTime() - startTime, TimeUnit.NANOSECONDS);
                return HttpShardHandler.this.transfomResponse(sreq, srsp, shard);
            }
        };
        try {
            if (shard != null) {
                MDC.put((String)"ShardRequest.shards", (String)shard);
            }
            if (urls != null && !urls.isEmpty()) {
                MDC.put((String)"ShardRequest.urlList", (String)urls.toString());
            }
            this.pending.add(this.completionService.submit(task));
        }
        finally {
            MDC.remove((String)"ShardRequest.shards");
            MDC.remove((String)"ShardRequest.urlList");
        }
    }

    protected QueryRequest makeQueryRequest(ShardRequest sreq, ModifiableSolrParams params, String shard) {
        return new QueryRequest((SolrParams)params);
    }

    protected ShardResponse transfomResponse(ShardRequest sreq, ShardResponse rsp, String shard) {
        return rsp;
    }

    @Override
    public ShardResponse takeCompletedIncludingErrors() {
        return this.take(false);
    }

    @Override
    public ShardResponse takeCompletedOrError() {
        return this.take(true);
    }

    private ShardResponse take(boolean bailOnError) {
        while (this.pending.size() > 0) {
            try {
                Future<ShardResponse> future = this.completionService.take();
                this.pending.remove(future);
                ShardResponse rsp = future.get();
                if (bailOnError && rsp.getException() != null) {
                    return rsp;
                }
                rsp.getShardRequest().responses.add(rsp);
                if (rsp.getShardRequest().responses.size() != rsp.getShardRequest().actualShards.length) continue;
                return rsp;
            }
            catch (InterruptedException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
            }
            catch (ExecutionException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Impossible Exception", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public void cancelAll() {
        for (Future<ShardResponse> future : this.pending) {
            future.cancel(true);
        }
    }

    @Override
    public void checkDistributed(ResponseBuilder rb) {
        String shards_start;
        String shards_rows;
        SolrQueryRequest req = rb.req;
        SolrParams params = req.getParams();
        rb.isDistrib = params.getBool("distrib", req.getCore().getCoreDescriptor().getCoreContainer().isZooKeeperAware());
        String shards = params.get("shards");
        boolean hasShardURL = shards != null && shards.indexOf(47) > 0;
        rb.isDistrib = hasShardURL | rb.isDistrib;
        if (rb.isDistrib) {
            ClusterState clusterState = null;
            Map<String, Object> slices = null;
            CoreDescriptor coreDescriptor = req.getCore().getCoreDescriptor();
            CloudDescriptor cloudDescriptor = coreDescriptor.getCloudDescriptor();
            ZkController zkController = coreDescriptor.getCoreContainer().getZkController();
            if (shards != null) {
                List lst = StrUtils.splitSmart((String)shards, (String)",", (boolean)true);
                rb.shards = lst.toArray(new String[lst.size()]);
                rb.slices = new String[rb.shards.length];
                if (zkController != null) {
                    for (int i = 0; i < rb.shards.length; ++i) {
                        if (rb.shards[i].indexOf(47) >= 0) continue;
                        rb.slices[i] = rb.shards[i];
                        rb.shards[i] = null;
                    }
                }
            } else if (zkController != null) {
                clusterState = zkController.getClusterState();
                String shardKeys = params.get("_route_");
                slices = new HashMap<String, Slice>();
                String collections = params.get("collection");
                if (collections != null) {
                    List collectionList = StrUtils.splitSmart((String)collections, (String)",", (boolean)true);
                    for (String collectionName : collectionList) {
                        this.addSlices(slices, clusterState, params, collectionName, shardKeys, true);
                    }
                } else {
                    String collectionName = cloudDescriptor.getCollectionName();
                    this.addSlices(slices, clusterState, params, collectionName, shardKeys, false);
                }
                rb.slices = slices.keySet().toArray(new String[slices.size()]);
                rb.shards = new String[rb.slices.length];
            }
            if (zkController != null) {
                String ourSlice = cloudDescriptor.getShardId();
                String ourCollection = cloudDescriptor.getCollectionName();
                if (rb.slices.length == 1 && rb.slices[0] != null && (rb.slices[0].equals(ourSlice) || rb.slices[0].equals(ourCollection + "_" + ourSlice)) && cloudDescriptor.getLastPublished() == Replica.State.ACTIVE) {
                    boolean shortCircuit = params.getBool("shortCircuit", true);
                    String targetHandler = params.get("shards.qt");
                    boolean bl = shortCircuit = shortCircuit && targetHandler == null;
                    if (shortCircuit) {
                        rb.isDistrib = false;
                        rb.shortCircuitedURL = ZkCoreNodeProps.getCoreUrl((String)zkController.getBaseUrl(), (String)coreDescriptor.getName());
                        return;
                    }
                }
                for (int i = 0; i < rb.shards.length; ++i) {
                    String sliceName;
                    Slice slice;
                    if (rb.shards[i] != null) continue;
                    if (clusterState == null) {
                        clusterState = zkController.getClusterState();
                        slices = clusterState.getSlicesMap(cloudDescriptor.getCollectionName());
                    }
                    if ((slice = (Slice)slices.get(sliceName = rb.slices[i])) == null) {
                        rb.shards[i] = "";
                        continue;
                    }
                    Map sliceShards = slice.getReplicasMap();
                    StringBuilder sliceShardsStr = new StringBuilder();
                    boolean first = true;
                    for (Replica replica : sliceShards.values()) {
                        if (!clusterState.liveNodesContain(replica.getNodeName()) || replica.getState() != Replica.State.ACTIVE) continue;
                        if (first) {
                            first = false;
                        } else {
                            sliceShardsStr.append('|');
                        }
                        String url = ZkCoreNodeProps.getCoreUrl((ZkNodeProps)replica);
                        sliceShardsStr.append(url);
                    }
                    rb.shards[i] = sliceShardsStr.toString();
                }
            }
        }
        if ((shards_rows = params.get("shards.rows")) != null) {
            rb.shards_rows = Integer.parseInt(shards_rows);
        }
        if ((shards_start = params.get("shards.start")) != null) {
            rb.shards_start = Integer.parseInt(shards_start);
        }
    }

    private void addSlices(Map<String, Slice> target, ClusterState state, SolrParams params, String collectionName, String shardKeys, boolean multiCollection) {
        DocCollection coll = state.getCollection(collectionName);
        Collection slices = coll.getRouter().getSearchSlices(shardKeys, params, coll);
        ClientUtils.addSlices(target, (String)collectionName, (Collection)slices, (boolean)multiCollection);
    }

    @Override
    public ShardHandlerFactory getShardHandlerFactory() {
        return this.httpShardHandlerFactory;
    }

    private static class SimpleSolrResponse
    extends SolrResponse {
        long elapsedTime;
        NamedList<Object> nl;

        private SimpleSolrResponse() {
        }

        public long getElapsedTime() {
            return this.elapsedTime;
        }

        public NamedList<Object> getResponse() {
            return this.nl;
        }

        public void setResponse(NamedList<Object> rsp) {
            this.nl = rsp;
        }

        public void setElapsedTime(long elapsedTime) {
            this.elapsedTime = elapsedTime;
        }
    }
}

