/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.tidy.merge.strategy;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.SerializationUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.configuration.Settings;
import org.dataone.service.exceptions.InvalidToken;
import org.dataone.service.exceptions.NotAuthorized;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.types.v1.AccessPolicy;
import org.dataone.service.types.v1.AccessRule;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.NodeReference;
import org.dataone.service.types.v1.Permission;
import org.dataone.service.types.v1.Replica;
import org.dataone.service.types.v1.ReplicationPolicy;
import org.dataone.service.types.v1.ReplicationStatus;
import org.dataone.service.types.v1.Subject;
import org.dataone.service.types.v1.SystemMetadata;
import org.dataone.service.util.TypeMarshaller;
import org.dataone.tidy.InclusionsFilter;
import org.dataone.tidy.merge.AuthMNSystemMetadataProxy;
import org.dataone.tidy.merge.MNSystemMetadataDelegate;
import org.dataone.tidy.merge.MergeReport;
import org.dataone.tidy.merge.MergeStrategy;
import org.jibx.runtime.JiBXException;

public class MergeSystemMetadata
implements MergeStrategy<Map<String, SystemMetadata>> {
    private static Log logger = LogFactory.getLog(MergeSystemMetadata.class);
    private MergeReport mergeReport;
    private MNSystemMetadataDelegate mnSysMetaDelegate;
    private static final boolean USE_MN_ACCESSPOLICY = Settings.getConfiguration().getBoolean("tidy.merge.strategy.use_mn_accessPolicy", true);
    private static Map<ReplicationStatus, Integer> replicaStatusPriorityMap = new HashMap<ReplicationStatus, Integer>();

    public MergeSystemMetadata(MergeReport report) {
        this.mergeReport = report;
        this.mnSysMetaDelegate = new AuthMNSystemMetadataProxy();
    }

    public MergeSystemMetadata(MergeReport report, MNSystemMetadataDelegate mnSysMetaDelegate) {
        this.mergeReport = report;
        this.mnSysMetaDelegate = mnSysMetaDelegate;
    }

    @Override
    public MergeReport mend(Map<String, SystemMetadata> sysmetas) {
        try {
            InclusionsFilter inclusionsFilter = InclusionsFilter.getInstance();
            String ascendentSysmeta = this.determineAscendentSystemMetadata(sysmetas);
            if (ascendentSysmeta == null || ascendentSysmeta.isEmpty()) {
                logger.warn((Object)"ascendentSysmeta from determineAscendentSystemMetadata is null or empty");
            } else {
                logger.info((Object)("determined that " + ascendentSysmeta + " is ascendent from "));
                for (String key : sysmetas.keySet()) {
                    logger.info((Object)key);
                }
            }
            SystemMetadata copyAscendent = this.clone(sysmetas.get(ascendentSysmeta));
            if (sysmetas.size() > 1) {
                this.applyLatestDateSystemMetadataModified(ascendentSysmeta, sysmetas);
                this.applyArchivedIfAnyArchived(ascendentSysmeta, sysmetas);
                this.useAscendentsObsoletedBy(ascendentSysmeta, sysmetas);
                this.useAscendentsObsoletes(ascendentSysmeta, sysmetas);
                this.mergeAuthoritativeMemberNode(ascendentSysmeta, sysmetas);
                this.mergeReplicaList(ascendentSysmeta, sysmetas);
                this.mergeReplicaPolicyInfo(ascendentSysmeta, sysmetas);
                if (this.isReplicationAllowed(sysmetas.get(ascendentSysmeta))) {
                    this.collateAllPreferredLists(ascendentSysmeta, sysmetas);
                    this.mergeBlocked(ascendentSysmeta, sysmetas);
                }
            }
            if (USE_MN_ACCESSPOLICY) {
                NodeReference authMN;
                Identifier pid = this.mergeReport.getIdentifier();
                if (inclusionsFilter.shouldInclude(pid, authMN = sysmetas.get(ascendentSysmeta).getAuthoritativeMemberNode()).booleanValue()) {
                    this.acceptAuthMNAccessPolicy(ascendentSysmeta, sysmetas);
                } else {
                    logger.info((Object)("AuthMN not called for pid: " + pid.getValue() + " because the identifier is in the bypass list"));
                }
            }
            this.mergeReport.setResultingSystemMetadata(sysmetas.get(ascendentSysmeta));
            sysmetas.put(ascendentSysmeta, copyAscendent);
        }
        catch (ServiceFailure e) {
            this.mergeReport.setProcessingException((Exception)((Object)e));
        }
        catch (InvalidToken e) {
            this.mergeReport.setProcessingException((Exception)((Object)e));
        }
        catch (NotAuthorized e) {
            this.mergeReport.setProcessingException((Exception)((Object)e));
        }
        catch (NotImplemented e) {
            this.mergeReport.setProcessingException((Exception)((Object)e));
        }
        catch (NotFound e) {
            this.mergeReport.setProcessingException((Exception)((Object)e));
        }
        catch (IOException e) {
            this.mergeReport.setProcessingException(e);
        }
        catch (InstantiationException e) {
            this.mergeReport.setProcessingException(e);
        }
        catch (IllegalAccessException e) {
            this.mergeReport.setProcessingException(e);
        }
        catch (JiBXException e) {
            this.mergeReport.setProcessingException((Exception)((Object)e));
        }
        return this.mergeReport;
    }

    private boolean isReplicationAllowed(SystemMetadata systemMetadata) {
        return systemMetadata.getReplicationPolicy() != null && BooleanUtils.isTrue((Boolean)systemMetadata.getReplicationPolicy().getReplicationAllowed());
    }

    protected String determineAscendentSystemMetadata(Map<String, SystemMetadata> sysmetaToMerge) {
        String candidateAscendent = null;
        int countOfHighestSerial = 0;
        for (Map.Entry<String, SystemMetadata> sysMeta : sysmetaToMerge.entrySet()) {
            if (candidateAscendent == null) {
                candidateAscendent = sysMeta.getKey();
                countOfHighestSerial = 1;
            } else if (sysmetaToMerge.get(candidateAscendent).getSerialVersion().compareTo(sysMeta.getValue().getSerialVersion()) < 0) {
                candidateAscendent = sysMeta.getKey();
                countOfHighestSerial = 1;
            } else if (sysmetaToMerge.get(candidateAscendent).getSerialVersion().compareTo(sysMeta.getValue().getSerialVersion()) == 0) {
                if (sysmetaToMerge.get(candidateAscendent).getDateSysMetadataModified().before(sysMeta.getValue().getDateSysMetadataModified())) {
                    candidateAscendent = sysMeta.getKey();
                    countOfHighestSerial = 1;
                } else if (sysmetaToMerge.get(candidateAscendent).getDateSysMetadataModified().equals(sysMeta.getValue().getDateSysMetadataModified())) {
                    ++countOfHighestSerial;
                }
            }
            if (candidateAscendent != null && !candidateAscendent.isEmpty()) continue;
            logger.warn((Object)"In determineAscendentSystemMetadata, candidateAscendent was assigned from key but is null or empty still");
        }
        return candidateAscendent;
    }

    protected void applyLatestDateSystemMetadataModified(String mergeTarget, Map<String, SystemMetadata> sysmetas) {
        Date modDate = null;
        for (Map.Entry<String, SystemMetadata> sysMeta : sysmetas.entrySet()) {
            if (modDate == null) {
                modDate = sysMeta.getValue().getDateSysMetadataModified();
                continue;
            }
            if (!modDate.before(sysMeta.getValue().getDateSysMetadataModified())) continue;
            modDate = sysMeta.getValue().getDateSysMetadataModified();
        }
        sysmetas.get(mergeTarget).setDateSysMetadataModified(modDate);
    }

    protected void applyArchivedIfAnyArchived(String mergeTarget, Map<String, SystemMetadata> sysmetas) {
        if (BooleanUtils.isNotTrue((Boolean)sysmetas.get(mergeTarget).getArchived())) {
            for (Map.Entry<String, SystemMetadata> sysMeta : sysmetas.entrySet()) {
                if (!BooleanUtils.isTrue((Boolean)sysMeta.getValue().getArchived())) continue;
                sysmetas.get(mergeTarget).setArchived(Boolean.TRUE);
                break;
            }
        }
    }

    protected void useAscendentsObsoletedBy(String mergeTarget, Map<String, SystemMetadata> sysmetas) {
        ArrayList<Identifier> prioritizationList = new ArrayList<Identifier>();
        prioritizationList.add(sysmetas.get(mergeTarget).getObsoletedBy());
        for (Map.Entry<String, SystemMetadata> sysmeta : sysmetas.entrySet()) {
            Identifier obsoletedBy = sysmeta.getValue().getObsoletedBy();
            if (obsoletedBy == null || prioritizationList.contains(obsoletedBy)) continue;
            prioritizationList.add(sysmeta.getValue().getObsoletedBy());
        }
        if (prioritizationList.get(0) == null && prioritizationList.size() > 1) {
            sysmetas.get(mergeTarget).setObsoletedBy((Identifier)prioritizationList.get(1));
        }
        if (prioritizationList.get(0) == null) {
            prioritizationList.remove(0);
        }
        if (prioritizationList.size() > 1) {
            StringBuffer sb = new StringBuffer();
            for (Identifier id : prioritizationList) {
                sb.append(id.getValue());
                sb.append(" ");
            }
            this.mergeReport.addWarning("Multiple values found for ObsoletedBy field: " + sb.toString() + ": Using the first one.");
        }
    }

    protected void useAscendentsObsoletes(String mergeTarget, Map<String, SystemMetadata> sysmetas) {
        ArrayList<Identifier> prioritizationList = new ArrayList<Identifier>();
        prioritizationList.add(sysmetas.get(mergeTarget).getObsoletes());
        for (Map.Entry<String, SystemMetadata> sysmeta : sysmetas.entrySet()) {
            Identifier obsoletes = sysmeta.getValue().getObsoletes();
            if (obsoletes == null || prioritizationList.contains(obsoletes)) continue;
            prioritizationList.add(sysmeta.getValue().getObsoletes());
        }
        if (prioritizationList.get(0) == null && prioritizationList.size() > 1) {
            sysmetas.get(mergeTarget).setObsoletes((Identifier)prioritizationList.get(1));
        }
        if (prioritizationList.get(0) == null) {
            prioritizationList.remove(0);
        }
        if (prioritizationList.size() > 1) {
            StringBuffer sb = new StringBuffer();
            for (Identifier id : prioritizationList) {
                sb.append(id.getValue());
                sb.append(" ");
            }
            this.mergeReport.addWarning("Multiple values found for Obsoletes field: " + sb.toString() + ": Using the first one.");
        }
    }

    protected void mergeReplicaList(String mergeTarget, Map<String, SystemMetadata> sysmetas) {
        List<Replica> replicas = this.gatherUniqueReplicas(sysmetas);
        sysmetas.get(mergeTarget).clearReplicaList();
        sysmetas.get(mergeTarget).setReplicaList(replicas);
    }

    private List<Replica> gatherUniqueReplicas(Map<String, SystemMetadata> systemMetadataList) {
        HashMap<String, Replica> replicasByNodeId = new HashMap<String, Replica>();
        for (SystemMetadata sysMeta : systemMetadataList.values()) {
            if (!CollectionUtils.isNotEmpty((Collection)sysMeta.getReplicaList())) continue;
            for (Replica replica : sysMeta.getReplicaList()) {
                String nodeId = replica.getReplicaMemberNode().getValue();
                if (!replicasByNodeId.containsKey(nodeId)) {
                    replicasByNodeId.put(nodeId, replica);
                    continue;
                }
                Replica currentMerged = (Replica)replicasByNodeId.get(nodeId);
                ReplicationStatus currentMergedStatus = currentMerged.getReplicationStatus();
                if (replica.getReplicaVerified().after(currentMerged.getReplicaVerified())) {
                    replicasByNodeId.put(nodeId, replica);
                    continue;
                }
                if (!replica.getReplicaVerified().equals(currentMerged.getReplicaVerified())) continue;
                int currentPriority = replicaStatusPriorityMap.get(currentMergedStatus);
                int replicaPriority = replicaStatusPriorityMap.get(replica.getReplicationStatus());
                if (replicaPriority <= currentPriority) continue;
                replicasByNodeId.put(nodeId, replica);
            }
        }
        ArrayList<Replica> replicas = new ArrayList<Replica>();
        replicas.addAll(replicasByNodeId.values());
        return replicas;
    }

    protected void mergeReplicaPolicyInfo(String mergeTarget, Map<String, SystemMetadata> sysmetas) {
        boolean replicationAllowed = this.isReplicationAllowed(sysmetas.get(mergeTarget));
        if (!replicationAllowed) {
            for (SystemMetadata sysMeta : sysmetas.values()) {
                if (!this.isReplicationAllowed(sysMeta)) continue;
                if (sysmetas.get(mergeTarget).getReplicationPolicy() == null) {
                    sysmetas.get(mergeTarget).setReplicationPolicy(new ReplicationPolicy());
                }
                sysmetas.get(mergeTarget).getReplicationPolicy().setReplicationAllowed(Boolean.TRUE);
                replicationAllowed = true;
                break;
            }
        }
        if (replicationAllowed) {
            Integer numberReplicas = 0;
            for (SystemMetadata sysMeta : sysmetas.values()) {
                if (sysMeta.getReplicationPolicy() == null || sysMeta.getReplicationPolicy().getNumberReplicas() == null || sysMeta.getReplicationPolicy().getNumberReplicas().compareTo(numberReplicas) <= 0) continue;
                numberReplicas = sysMeta.getReplicationPolicy().getNumberReplicas();
            }
            sysmetas.get(mergeTarget).getReplicationPolicy().setNumberReplicas(numberReplicas);
        }
    }

    protected void collateAllPreferredLists(String mergeTarget, Map<String, SystemMetadata> sysmetas) {
        LinkedList<NodeReference> mergedPreferredNodeList = new LinkedList<NodeReference>();
        Boolean modifiedPreferredList = false;
        HashMap orderedMapofNodeLists = new HashMap();
        LinkedList<String> targetPreferredStringList = new LinkedList<String>();
        CollectionUtils.collect((Collection)sysmetas.get(mergeTarget).getReplicationPolicy().getPreferredMemberNodeList(), (Transformer)NodeReferenceToStringTransformer.getInstance(), targetPreferredStringList);
        for (int i = 0; i < targetPreferredStringList.size(); ++i) {
            LinkedList nodeList = new LinkedList();
            nodeList.offer(targetPreferredStringList.get(i));
            orderedMapofNodeLists.put(i, nodeList);
        }
        ArrayList<String> addedNodesToReport = new ArrayList<String>();
        for (SystemMetadata metadataProvided : sysmetas.values()) {
            LinkedList providedPreferredStringList = new LinkedList();
            CollectionUtils.collect((Collection)metadataProvided.getReplicationPolicy().getPreferredMemberNodeList(), (Transformer)NodeReferenceToStringTransformer.getInstance(), providedPreferredStringList);
            for (int i = 0; i < providedPreferredStringList.size(); ++i) {
                String providedNode = (String)providedPreferredStringList.get(i);
                if (targetPreferredStringList.contains(providedNode)) continue;
                modifiedPreferredList = true;
                addedNodesToReport.add(providedNode);
                targetPreferredStringList.add(providedNode);
                if (orderedMapofNodeLists.containsKey(i)) {
                    ((LinkedList)orderedMapofNodeLists.get(i)).offer(providedNode);
                    continue;
                }
                LinkedList nodeList = new LinkedList();
                nodeList.offer(providedPreferredStringList.get(i));
                orderedMapofNodeLists.put(i, nodeList);
            }
        }
        if (modifiedPreferredList.booleanValue()) {
            String addedNodes = StringUtils.join(addedNodesToReport, (char)',');
            ArrayList orderedListOfEntries = new ArrayList();
            orderedListOfEntries.addAll(orderedMapofNodeLists.keySet());
            Collections.sort(orderedListOfEntries);
            for (Integer i : orderedListOfEntries) {
                List preferredNodeList = (List)orderedMapofNodeLists.get(i);
                for (String node : preferredNodeList) {
                    NodeReference nodeReference = new NodeReference();
                    nodeReference.setValue(node);
                    mergedPreferredNodeList.offer(nodeReference);
                }
            }
            sysmetas.get(mergeTarget).getReplicationPolicy().setPreferredMemberNodeList(mergedPreferredNodeList);
        }
    }

    protected void mergeBlocked(String mergeTarget, Map<String, SystemMetadata> sysmetas) {
        ArrayList targetBlockedStringList = new ArrayList();
        Boolean modifiedBlockedList = false;
        LinkedList<NodeReference> mergedBlockedNodeList = new LinkedList<NodeReference>();
        CollectionUtils.collect((Collection)sysmetas.get(mergeTarget).getReplicationPolicy().getBlockedMemberNodeList(), (Transformer)NodeReferenceToStringTransformer.getInstance(), targetBlockedStringList);
        for (SystemMetadata sysmeta : sysmetas.values()) {
            ArrayList providedBlockedStringList = new ArrayList();
            CollectionUtils.collect((Collection)sysmeta.getReplicationPolicy().getBlockedMemberNodeList(), (Transformer)NodeReferenceToStringTransformer.getInstance(), providedBlockedStringList);
            providedBlockedStringList.removeAll(targetBlockedStringList);
            if (providedBlockedStringList.isEmpty()) continue;
            modifiedBlockedList = true;
            String addedNodes = StringUtils.join(providedBlockedStringList, (char)',');
            Collection newNodeList = CollectionUtils.union(targetBlockedStringList, providedBlockedStringList);
            logger.debug((Object)("newNodeList size: " + newNodeList.size()));
            targetBlockedStringList.clear();
            targetBlockedStringList.addAll(newNodeList);
        }
        if (modifiedBlockedList.booleanValue()) {
            logger.debug((Object)"blockList was modified");
            for (String node : targetBlockedStringList) {
                NodeReference nodeReference = new NodeReference();
                nodeReference.setValue(node);
                mergedBlockedNodeList.add(nodeReference);
                logger.debug((Object)("New Block list contains: " + node));
            }
            sysmetas.get(mergeTarget).getReplicationPolicy().setBlockedMemberNodeList(mergedBlockedNodeList);
        }
    }

    protected void acceptAuthMNAccessPolicy(String mergeTarget, Map<String, SystemMetadata> sysmetas) throws ServiceFailure, InvalidToken, NotAuthorized, NotImplemented {
        NodeReference authMN = sysmetas.get(mergeTarget).getAuthoritativeMemberNode();
        Identifier pid = sysmetas.get(mergeTarget).getIdentifier();
        this.mergeReport.getMergeResult().setAuthoritativeMemberNode(authMN.getValue());
        try {
            SystemMetadata authMNSysmeta = this.mnSysMetaDelegate.getSystemMetadata(authMN, pid);
            AccessPolicy ap = (AccessPolicy)SerializationUtils.clone((Serializable)authMNSysmeta.getAccessPolicy());
            sysmetas.get(mergeTarget).setAccessPolicy(ap);
            this.mergeReport.setAuthMnSystemMetadata(authMNSysmeta);
        }
        catch (InvalidToken e) {
            this.mergeReport.addWarning("Exception retrieving AuthMN systemMetadata: " + ((Object)((Object)e)).getClass().getSimpleName() + ": " + e.getDescription());
            throw e;
        }
        catch (NotAuthorized e) {
            this.mergeReport.addWarning("Exception retrieving AuthMN systemMetadata: " + ((Object)((Object)e)).getClass().getSimpleName() + ": " + e.getDescription());
            throw e;
        }
        catch (NotImplemented e) {
            this.mergeReport.addWarning("Exception retrieving AuthMN systemMetadata: " + ((Object)((Object)e)).getClass().getSimpleName() + ": " + e.getDescription());
            throw e;
        }
        catch (ServiceFailure e) {
            this.mergeReport.addWarning("Exception retrieving AuthMN systemMetadata: " + ((Object)((Object)e)).getClass().getSimpleName() + ": " + e.getDescription());
            throw e;
        }
        catch (NotFound e) {
            this.mergeReport.addWarning("Exception retrieving AuthMN systemMetadata: " + ((Object)((Object)e)).getClass().getSimpleName() + ": " + e.getDescription());
        }
    }

    protected void mergeAccessPolicy(String mergeTarget, Map<String, SystemMetadata> sysmetas) {
        Map<Subject, List<String>> targetSubjectPermissions = this.buildSubjectPermissionsHashMap(sysmetas.get(mergeTarget).getAccessPolicy().getAllowList());
        for (SystemMetadata metadataProvided : sysmetas.values()) {
            Map<Subject, List<String>> providedSubjectPermissions = this.buildSubjectPermissionsHashMap(metadataProvided.getAccessPolicy().getAllowList());
            for (Subject targetSubject : targetSubjectPermissions.keySet()) {
                Collection solution;
                if (!providedSubjectPermissions.containsKey(targetSubject) || (solution = CollectionUtils.disjunction((Collection)targetSubjectPermissions.get(targetSubject), (Collection)providedSubjectPermissions.get(targetSubject))).isEmpty()) continue;
                solution = CollectionUtils.subtract((Collection)targetSubjectPermissions.get(targetSubject), (Collection)providedSubjectPermissions.get(targetSubject));
                if (!solution.isEmpty()) {
                    String addPermissions = StringUtils.join((Collection)solution, (char)',');
                }
                if ((solution = CollectionUtils.subtract((Collection)providedSubjectPermissions.get(targetSubject), (Collection)targetSubjectPermissions.get(targetSubject))).isEmpty()) continue;
                String minusPermissions = StringUtils.join((Collection)solution, (char)',');
            }
        }
    }

    protected void mergeAuthoritativeMemberNode(String mergeTarget, Map<String, SystemMetadata> sysmetas) {
        sysmetas.get(mergeTarget).getAuthoritativeMemberNode();
        for (SystemMetadata origin : sysmetas.values()) {
            if (sysmetas.get(mergeTarget).getAuthoritativeMemberNode().equals((Object)origin.getAuthoritativeMemberNode())) continue;
            this.mergeReport.addWarning("AuthoritativeMemberNode value:" + origin.getAuthoritativeMemberNode().getValue() + " replaced with:" + sysmetas.get(mergeTarget).getAuthoritativeMemberNode().getValue());
        }
    }

    private Map<Subject, List<String>> buildSubjectPermissionsHashMap(List<AccessRule> allowList) {
        HashMap<Subject, List<String>> subjectPermissionsMap = new HashMap<Subject, List<String>>();
        for (AccessRule accessRule : allowList) {
            List permissionList = accessRule.getPermissionList();
            List subjectList = accessRule.getSubjectList();
            for (Subject subject : subjectList) {
                LinkedList permissionStringsList = new LinkedList();
                CollectionUtils.collect((Collection)permissionList, (Transformer)PermissionToStringTransformer.getInstance(), permissionStringsList);
                if (subjectPermissionsMap.containsKey(subject)) {
                    ((List)subjectPermissionsMap.get(subject)).addAll(permissionStringsList);
                    Collections.sort((List)subjectPermissionsMap.get(subject));
                    continue;
                }
                Collections.sort(permissionStringsList);
                subjectPermissionsMap.put(subject, permissionStringsList);
            }
        }
        return subjectPermissionsMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SystemMetadata clone(SystemMetadata sysmeta) throws IOException, InstantiationException, IllegalAccessException, JiBXException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            if (baos == null) {
                logger.warn((Object)"ByteArrayOutputStream provided a null pointer");
            }
            if (sysmeta == null) {
                logger.warn((Object)"sysmeta provided a null pointer");
            }
            TypeMarshaller.marshalTypeToOutputStream((Object)sysmeta, (OutputStream)baos);
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException ex) {
                    logger.error((Object)ex.getMessage(), (Throwable)ex);
                }
            }
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        try {
            SystemMetadata systemMetadata = (SystemMetadata)TypeMarshaller.unmarshalTypeFromStream(SystemMetadata.class, (InputStream)bais);
            return systemMetadata;
        }
        finally {
            try {
                if (bais != null) {
                    ((InputStream)bais).close();
                }
            }
            catch (IOException ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
    }

    static {
        int valueCounter = 0;
        replicaStatusPriorityMap.put(ReplicationStatus.QUEUED, valueCounter++);
        replicaStatusPriorityMap.put(ReplicationStatus.REQUESTED, valueCounter++);
        replicaStatusPriorityMap.put(ReplicationStatus.FAILED, valueCounter++);
        replicaStatusPriorityMap.put(ReplicationStatus.COMPLETED, valueCounter++);
        replicaStatusPriorityMap.put(ReplicationStatus.INVALIDATED, valueCounter++);
    }

    private static class NodeReferenceToStringTransformer
    implements Transformer {
        private static NodeReferenceToStringTransformer nodeIdentifierToStringTransformer = null;

        public static NodeReferenceToStringTransformer getInstance() {
            if (nodeIdentifierToStringTransformer == null) {
                nodeIdentifierToStringTransformer = new NodeReferenceToStringTransformer();
            }
            return nodeIdentifierToStringTransformer;
        }

        private NodeReferenceToStringTransformer() {
        }

        public Object transform(Object input) {
            NodeReference nodeIdentifier = (NodeReference)input;
            return nodeIdentifier.getValue();
        }
    }

    private static class PermissionToStringTransformer
    implements Transformer {
        private static PermissionToStringTransformer permissionToStringTransformer = null;

        public static PermissionToStringTransformer getInstance() {
            if (permissionToStringTransformer == null) {
                permissionToStringTransformer = new PermissionToStringTransformer();
            }
            return permissionToStringTransformer;
        }

        private PermissionToStringTransformer() {
        }

        public Object transform(Object input) {
            Permission permission = (Permission)input;
            return permission.xmlValue();
        }
    }

    private static class SubjectToStringTransformer
    implements Transformer {
        private static SubjectToStringTransformer subjectToStringTransformer = null;

        public static SubjectToStringTransformer getInstance() {
            if (subjectToStringTransformer == null) {
                subjectToStringTransformer = new SubjectToStringTransformer();
            }
            return subjectToStringTransformer;
        }

        private SubjectToStringTransformer() {
        }

        public Object transform(Object input) {
            Subject subject = (Subject)input;
            return subject.getValue();
        }
    }
}

