/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.tidy.merge;

import java.util.ArrayList;
import java.util.List;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.SystemMetadata;
import org.dataone.tidy.dao.ChangeRecord;
import org.dataone.tidy.dao.MergeResult;
import org.dataone.tidy.dao.MergeStatus;

public class MergeReport {
    Identifier pid;
    List<ChangeRecord> changes = new ArrayList<ChangeRecord>();
    MergeResult mergeResult;
    List<String> warnings = new ArrayList<String>();
    Exception processingException;

    public MergeReport(Identifier pid) {
        this.pid = pid;
        this.mergeResult = new MergeResult(pid.getValue(), MergeStatus.FAILURE);
    }

    public Identifier getIdentifier() {
        return this.pid;
    }

    public MergeResult getMergeResult() {
        return this.mergeResult;
    }

    public void addChangeRecord(ChangeRecord cr) {
        this.changes.add(cr);
    }

    public void clearChangeRecordList() {
        this.changes.clear();
    }

    public List<ChangeRecord> getChangeRecordList() {
        return this.changes;
    }

    public void setResultingSystemMetadata(SystemMetadata sysmeta) {
        this.mergeResult.setMergedSystemMetadata(sysmeta);
    }

    public SystemMetadata getResultingSystemMetadata() {
        return this.mergeResult.getMergedSystemMetadata();
    }

    public void setAuthMnSystemMetadata(SystemMetadata sysmeta) {
        this.mergeResult.setMnSystemMetadata(sysmeta);
    }

    public SystemMetadata getAuthMnSystemMetadata() {
        return this.mergeResult.getMnSystemMetadata();
    }

    public void addWarning(String warning) {
        this.warnings.add(warning);
    }

    public void clearWarningList() {
        this.warnings.clear();
    }

    public List<String> getWarningList() {
        return this.warnings;
    }

    public void setProcessingException(Exception e) {
        this.processingException = e;
        this.mergeResult.setProcessingException(e.getClass().getName() + ": " + e.getMessage() + ": " + e.getStackTrace()[0].getFileName() + ":" + e.getStackTrace()[0].getLineNumber());
    }

    public Exception getProcessingException() {
        return this.processingException;
    }

    public void setReview(String review) {
        this.mergeResult.setReview(review);
    }

    public String getReview() {
        return this.mergeResult.getReview();
    }
}

