/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.tidy;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.util.StatusPrinter;
import java.io.File;
import java.io.FilenameFilter;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.configuration.Configuration;
import org.dataone.client.auth.CertificateManager;
import org.dataone.cn.dao.exceptions.DataAccessException;
import org.dataone.configuration.Settings;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.tidy.PostMerge;
import org.dataone.tidy.certificate.CertificateFilter;
import org.dataone.tidy.concurrent.TidyJobFactory;
import org.dataone.tidy.dao.ChangeRecordRepository;
import org.dataone.tidy.dao.MergeResultRepository;
import org.dataone.tidy.dao.PostgresRepositoryConfiguration;
import org.dataone.tidy.dao.SystemMetadataTidyDao;
import org.dataone.tidy.dao.SystemMetadataTidyDaoImpl;
import org.dataone.tidy.merge.AuthMNSystemMetadataProxy;
import org.dataone.tidy.merge.MNSystemMetadataDelegate;
import org.dataone.tidy.merge.MergeExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final Logger logger = LoggerFactory.getLogger(Main.class);
    private static FilenameFilter certificateFilter = new CertificateFilter();
    private static File[] certificateFiles;
    private static Configuration settingsConfiguration;
    private static PostgresRepositoryConfiguration repositoryConfig;
    private static MergeResultRepository mergeResultsRepository;
    private static ChangeRecordRepository changeRecordRepository;
    private static SystemMetadataTidyDao systemMetadataDao;
    private static MNSystemMetadataDelegate mnReadClient;

    public static void main(String[] args) throws NotImplemented, ServiceFailure, DataAccessException {
        try {
            LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
            StatusPrinter.print((Context)lc);
            String method = null;
            PosixParser parser = new PosixParser();
            HelpFormatter formatter = new HelpFormatter();
            Options options = new Options();
            options.addOption("h", "help", false, "print options");
            OptionBuilder.withLongOpt((String)"method");
            OptionBuilder.withDescription((String)"the name of the method[harvest|merge|commit|evict] to execute");
            OptionBuilder.hasArg();
            OptionBuilder.withType(String.class);
            OptionBuilder.withValueSeparator();
            OptionBuilder.withArgName((String)"METHOD");
            options.addOption(OptionBuilder.create());
            CommandLine line = parser.parse(options, args);
            if (line.hasOption("h") || line.hasOption("help")) {
                formatter.printHelp("tidy-node-sysmeta", options);
                return;
            }
            if (!line.hasOption("method")) {
                formatter.printHelp("tidy-node-sysmeta", options);
                return;
            }
            method = line.getOptionValue("method");
            if (method.equalsIgnoreCase("merge")) {
                TidyJobFactory jobFactory = new TidyJobFactory(systemMetadataDao, mergeResultsRepository, changeRecordRepository, mnReadClient);
                MergeExecutorService executorService = new MergeExecutorService(systemMetadataDao, mergeResultsRepository, jobFactory);
                executorService.executeJobs();
            } else if (method.equalsIgnoreCase("evict")) {
                PostMerge postMergeProcess = new PostMerge(mergeResultsRepository);
                postMergeProcess.postMerge();
            }
            repositoryConfig.closeContext();
        }
        catch (ParseException ex) {
            logger.error(ex.getMessage());
        }
    }

    static {
        settingsConfiguration = null;
        repositoryConfig = new PostgresRepositoryConfiguration();
        systemMetadataDao = new SystemMetadataTidyDaoImpl();
        mnReadClient = new AuthMNSystemMetadataProxy();
        settingsConfiguration = Settings.getConfiguration();
        String clientCertLocation = settingsConfiguration.getString("D1Client.certificate.directory");
        String clientCertFilename = settingsConfiguration.getString("D1Client.certificate.filename");
        File d1CertFile = new File(clientCertLocation + File.separator + clientCertFilename);
        String clientCertificateLocation = d1CertFile.getAbsolutePath();
        CertificateManager.getInstance().setCertificateLocation(clientCertificateLocation);
        repositoryConfig.initContext();
        mergeResultsRepository = repositoryConfig.getMergeResultRepository();
        changeRecordRepository = repositoryConfig.getChangeRecordRepository();
    }
}

