/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.batch.synchronization.tasks;

import java.io.Serializable;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.dataone.cn.ComponentActivationUtility;
import org.dataone.cn.batch.exceptions.ExecutionDisabledException;
import org.dataone.cn.batch.service.v2.NodeRegistrySyncService;
import org.dataone.cn.batch.synchronization.NodeCommFactory;
import org.dataone.cn.batch.synchronization.NodeCommObjectListHarvestFactory;
import org.dataone.cn.batch.synchronization.tasks.SortedHarvestTimepointMap;
import org.dataone.cn.batch.synchronization.type.NodeComm;
import org.dataone.cn.batch.synchronization.type.SyncQueueFacade;
import org.dataone.cn.log.MetricEvent;
import org.dataone.cn.log.MetricLogClient;
import org.dataone.cn.log.MetricLogClientFactory;
import org.dataone.cn.log.MetricLogEntry;
import org.dataone.cn.synchronization.types.SyncObject;
import org.dataone.configuration.Settings;
import org.dataone.service.exceptions.InvalidRequest;
import org.dataone.service.exceptions.InvalidToken;
import org.dataone.service.exceptions.NotAuthorized;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.mn.tier1.v2.MNRead;
import org.dataone.service.types.v1.NodeReference;
import org.dataone.service.types.v1.ObjectList;
import org.dataone.service.types.v1.Session;
import org.dataone.service.util.DateTimeMarshaller;
import org.joda.time.MutableDateTime;

public class ObjectListHarvestTask
implements Callable<Date>,
Serializable {
    NodeReference d1NodeReference;
    private Session session;
    Integer batchSize;
    MutableDateTime currentDateTime = new MutableDateTime((Object)new Date());
    Date endHarvestInterval;
    int backoffSeconds = 10;
    static final Logger __logger = Logger.getLogger(ObjectListHarvestTask.class);
    static final MetricLogClient __metricLogger = MetricLogClientFactory.getMetricLogClient();
    private int __syncMetricTotalSubmitted;
    private int __syncMetricTotalRetrieved;

    public ObjectListHarvestTask(NodeReference d1NodeReference, Integer batchSize) {
        this.d1NodeReference = d1NodeReference;
        this.batchSize = batchSize;
    }

    @Override
    public Date call() throws Exception {
        __logger.info((Object)(this.d1NodeReference.getValue() + "- Calling ObjectListHarvestTask"));
        this.__syncMetricTotalSubmitted = 0;
        this.__syncMetricTotalRetrieved = 0;
        if (!ComponentActivationUtility.synchronizationIsActive()) {
            ExecutionDisabledException ex = new ExecutionDisabledException(this.d1NodeReference.getValue() + "- Disabled");
            throw ex;
        }
        NodeCommFactory nodeCommFactory = NodeCommObjectListHarvestFactory.getInstance();
        NodeComm mnNodeComm = nodeCommFactory.getNodeComm(this.d1NodeReference);
        NodeRegistrySyncService nodeRegistryService = mnNodeComm.getNodeRegistryService();
        Integer maxSyncObjectQueueSize = Settings.getConfiguration().getInt("Synchronization.max_syncobjectqueue_size", 4000);
        Integer maxHarvestSize = Settings.getConfiguration().getInt("Synchronization.max_harvest_size", 2000);
        Integer requeueTolerance = Settings.getConfiguration().getInt("Synchronization.harvest_update_latestHarvestDate_frequency", 100);
        SyncQueueFacade hzSyncObjectQueue = new SyncQueueFacade();
        int maximumToHarvest = Math.min(maxHarvestSize, maxSyncObjectQueueSize - hzSyncObjectQueue.size());
        __logger.info((Object)(this.d1NodeReference.getValue() + " - harvest limited to " + maximumToHarvest + " items."));
        if (maximumToHarvest > 0) {
            SortedHarvestTimepointMap harvest = this.getFullObjectList(mnNodeComm, maximumToHarvest);
            this.spoolToSynchronizationQueue(harvest, hzSyncObjectQueue, nodeRegistryService, requeueTolerance);
            __logger.info((Object)(this.d1NodeReference.getValue() + "- ObjectListHarvestTask End"));
            MetricLogEntry __metricHarvestRetrievedLogEvent = new MetricLogEntry(MetricEvent.SYNCHRONIZATION_HARVEST_RETRIEVED, this.d1NodeReference, null, Integer.toString(this.__syncMetricTotalRetrieved));
            Date __harvestMetricLogDate = (Date)__metricHarvestRetrievedLogEvent.getDateLogged().clone();
            __metricLogger.logMetricEvent(__metricHarvestRetrievedLogEvent);
            MetricLogEntry __metricHarvestSubmittedLogEvent = new MetricLogEntry(MetricEvent.SYNCHRONIZATION_HARVEST_SUBMITTED, this.d1NodeReference, null, Integer.toString(this.__syncMetricTotalSubmitted));
            __metricHarvestSubmittedLogEvent.setDateLogged(__harvestMetricLogDate);
            __metricLogger.logMetricEvent(__metricHarvestSubmittedLogEvent);
        }
        return new Date();
    }

    protected void spoolToSynchronizationQueue(SortedHarvestTimepointMap harvest, SyncQueueFacade hzSyncObjectQueue, NodeRegistrySyncService nodeRegistryService, Integer requeueTolerance) throws InterruptedException, ServiceFailure {
        int vulnerableToReharvest = 0;
        Date currentModDate = null;
        Iterator<Map.Entry<Date, List<String>>> it = harvest.getAscendingIterator();
        while (it.hasNext()) {
            Map.Entry<Date, List<String>> timepoint = it.next();
            for (String pidString : timepoint.getValue()) {
                SyncObject syncObject = new SyncObject(this.d1NodeReference.getValue(), pidString);
                ++this.__syncMetricTotalSubmitted;
                hzSyncObjectQueue.add(syncObject);
                __logger.trace((Object)("placed on hzSyncObjectQueue- " + syncObject.taskLabel()));
                ++vulnerableToReharvest;
            }
            currentModDate = timepoint.getKey();
            if (vulnerableToReharvest < requeueTolerance) continue;
            try {
                nodeRegistryService.setDateLastHarvested(this.d1NodeReference, currentModDate);
                __logger.info((Object)(this.d1NodeReference.getValue() + " - updated lastHarvestedDate to " + currentModDate));
                vulnerableToReharvest = 0;
            }
            catch (ServiceFailure e) {
                __logger.error((Object)(this.d1NodeReference.getValue() + " harvest - nodeRegistry not accepting new lastHarvestedDate!"));
                throw e;
            }
        }
        try {
            if (currentModDate != null) {
                nodeRegistryService.setDateLastHarvested(this.d1NodeReference, currentModDate);
                __logger.info((Object)(this.d1NodeReference.getValue() + " - updated lastHarvestedDate to " + currentModDate + " ***end of harvest***"));
            }
        }
        catch (ServiceFailure e) {
            __logger.warn((Object)(this.d1NodeReference.getValue() + " harvest - nodeRegistry not accepting new lastHarvestedDate!"));
        }
    }

    protected SortedHarvestTimepointMap getFullObjectList(NodeComm nodeComm, Integer maxToHarvest) throws NotFound, ServiceFailure, InvalidRequest, InvalidToken, NotAuthorized, NotImplemented, ExecutionDisabledException {
        Date lastModifiedDate = nodeComm.getNodeRegistryService().getDateLastHarvested(this.d1NodeReference);
        MutableDateTime startHarvestDateTime = new MutableDateTime((Object)lastModifiedDate);
        startHarvestDateTime.addMillis(1);
        Date startHarvestDate = startHarvestDateTime.toDate();
        this.currentDateTime.addSeconds(-this.backoffSeconds);
        this.endHarvestInterval = this.currentDateTime.toDate();
        if (__logger.isDebugEnabled()) {
            __logger.debug((Object)(this.d1NodeReference.getValue() + "- starting retrieval " + nodeComm.getNodeRegistryService().getNode(this.d1NodeReference).getBaseURL() + " with startDate of " + DateTimeMarshaller.serializeDateToUTC((Date)startHarvestDate) + " and endDate of " + DateTimeMarshaller.serializeDateToUTC((Date)this.endHarvestInterval)));
        }
        int total = -1;
        try {
            ObjectList ol = this.doListObjects(nodeComm, startHarvestDate, this.endHarvestInterval, 0, 0);
            total = ol.getTotal();
            __logger.info((Object)(this.d1NodeReference.getValue() + "- has " + total + " pids to harvest."));
            this.endHarvestInterval = this.adjustFilterWindow(nodeComm, total, maxToHarvest, startHarvestDate, this.endHarvestInterval);
            __logger.info((Object)(this.d1NodeReference.getValue() + "- adjusting harvest toDate to limit the total for paged harvest [to between max and 2*max]"));
        }
        catch (InvalidRequest e) {
            __logger.warn((Object)(this.d1NodeReference.getValue() + "- Node doesn't like slicing parameters, trying single-page harvest strategy: " + e.serialize(0)));
            return this.doAllInOneHarvest(nodeComm, startHarvestDate, this.endHarvestInterval, maxToHarvest);
        }
        catch (InvalidToken | NotAuthorized | NotImplemented | ServiceFailure e) {
            __logger.error((Object)(this.d1NodeReference.getValue() + "- " + e.serialize(0)));
        }
        return this.doPagedHarvest(nodeComm, startHarvestDate, this.endHarvestInterval, total, maxToHarvest);
    }

    protected Date adjustFilterWindow(NodeComm nc, int total, int max, Date fromDate, Date toDate) throws InvalidRequest, InvalidToken, NotAuthorized, NotImplemented, ServiceFailure {
        if (total < max || total < 200) {
            return toDate;
        }
        long adjustedToDate = toDate.getTime();
        long fromDateValue = fromDate.getTime();
        boolean incomplete = false;
        int i = 0;
        long deltaT = adjustedToDate - fromDateValue;
        while (total > max * 2 || total < max) {
            adjustedToDate = total < max ? (adjustedToDate += deltaT) : (adjustedToDate -= (deltaT /= 2L));
            if (__logger.isDebugEnabled()) {
                __logger.debug((Object)String.format("%d. total = %d, max = %d: adjustingFilterWindow: [%s to %s]", i, total, max, fromDate, new Date(adjustedToDate)));
            }
            total = this.doListObjects(nc, fromDate, new Date(adjustedToDate), 0, 0).getTotal();
            if (i++ <= 25) continue;
            incomplete = true;
            break;
        }
        if (incomplete && total == 0) {
            return toDate;
        }
        __logger.info((Object)(this.d1NodeReference.getValue() + String.format(" - final time window: total = %d, max = %d: adjustingFilterWindow: [%s to %s]", total, max, fromDate, new Date(adjustedToDate))));
        return new Date(adjustedToDate);
    }

    private SortedHarvestTimepointMap doPagedHarvest(NodeComm nodeComm, Date fromDate, Date toDate, Integer total, Integer maxToHarvest) throws InvalidRequest, InvalidToken, NotAuthorized, NotImplemented, ServiceFailure, ExecutionDisabledException {
        ObjectList ol;
        int currentStart;
        SortedHarvestTimepointMap harvest = new SortedHarvestTimepointMap(fromDate, toDate, maxToHarvest);
        int latestReportedTotal = total;
        int count = Math.min(this.batchSize, latestReportedTotal - currentStart);
        for (currentStart = 0; currentStart < latestReportedTotal; currentStart += ol.sizeObjectInfoList()) {
            if (!ComponentActivationUtility.synchronizationIsActive()) {
                throw new ExecutionDisabledException(this.d1NodeReference.getValue() + "- Disabled");
            }
            ol = this.doListObjects(nodeComm, fromDate, toDate, currentStart, count);
            if (ol.sizeObjectInfoList() == 0) break;
            this.__syncMetricTotalRetrieved += ol.sizeObjectInfoList();
            latestReportedTotal = ol.getTotal();
            harvest.addObjectList(ol);
        }
        return harvest;
    }

    private SortedHarvestTimepointMap doAllInOneHarvest(NodeComm nodeComm, Date fromDate, Date toDate, Integer maxToHarvest) throws InvalidRequest, InvalidToken, NotAuthorized, NotImplemented, ServiceFailure {
        ObjectList ol = null;
        try {
            ol = this.doListObjects(nodeComm, fromDate, toDate, null, null);
        }
        catch (InvalidRequest e) {
            __logger.warn((Object)(this.d1NodeReference.getValue() + "- Node doesn't like toDate parameters, trying basic strategy " + e.serialize(0)));
            ol = this.doListObjects(nodeComm, fromDate, null, null, null);
            this.__syncMetricTotalRetrieved += ol.sizeObjectInfoList();
        }
        if (ol.getTotal() != ol.sizeObjectInfoList()) {
            __logger.error((Object)(this.d1NodeReference.getValue() + " - MemberNode does not support paging, but also doesn't return the total list within the harvest period.  Cannot harvest!"));
            throw new InvalidRequest("0000-MNode Failure", "Cannot reliably harvest from this MemberNode:  It does not support paging, yet does not return all of the object infos for the time period requested!");
        }
        SortedHarvestTimepointMap harvest = new SortedHarvestTimepointMap(fromDate, toDate, maxToHarvest);
        harvest.addObjectList(ol);
        return harvest;
    }

    private ObjectList doListObjects(NodeComm nodeComm, Date fromDate, Date toDate, Integer start, Integer count) throws InvalidRequest, InvalidToken, NotAuthorized, NotImplemented, ServiceFailure {
        Object mnRead = nodeComm.getMnRead();
        if (mnRead instanceof MNRead) {
            return ((MNRead)mnRead).listObjects(this.session, fromDate, toDate, null, null, null, start, count);
        }
        if (mnRead instanceof org.dataone.service.mn.tier1.v1.MNRead) {
            return ((org.dataone.service.mn.tier1.v1.MNRead)mnRead).listObjects(this.session, fromDate, toDate, null, null, start, count);
        }
        throw new ServiceFailure("0000", this.d1NodeReference.getValue() + " - the NodeComm.getMNRead() did not return a usable instance.  Got instance of " + mnRead.getClass().getCanonicalName());
    }
}

