/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.batch.synchronization.listener;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.Message;
import com.hazelcast.core.MessageListener;
import org.apache.log4j.Logger;
import org.dataone.cn.ComponentActivationUtility;
import org.dataone.cn.batch.synchronization.HarvestSchedulingManager;
import org.dataone.cn.hazelcast.HazelcastClientFactory;
import org.dataone.configuration.Settings;
import org.dataone.service.types.v1.NodeReference;
import org.quartz.SchedulerException;

public class NodeTopicListener
implements MessageListener<NodeReference> {
    static final Logger logger = Logger.getLogger(NodeTopicListener.class);
    static final String hzNodeTopicName = Settings.getConfiguration().getString("dataone.hazelcast.nodeTopic");
    HarvestSchedulingManager harvestSchedulingManager;

    public void addListener() {
        logger.info((Object)"NodeTopicListener Start");
        HazelcastClient hazelcast = HazelcastClientFactory.getProcessingClient();
        ITopic topic = hazelcast.getTopic(hzNodeTopicName);
        topic.addMessageListener((MessageListener)this);
    }

    private void removeListener() {
        HazelcastClient hazelcast = HazelcastClientFactory.getProcessingClient();
        ITopic topic = hazelcast.getTopic(hzNodeTopicName);
        topic.removeMessageListener((MessageListener)this);
    }

    public HarvestSchedulingManager getHarvestSchedulingManager() {
        return this.harvestSchedulingManager;
    }

    public void setHarvestSchedulingManager(HarvestSchedulingManager harvestSchedulingManager) {
        this.harvestSchedulingManager = harvestSchedulingManager;
    }

    public void onMessage(Message<NodeReference> message) {
        if (ComponentActivationUtility.synchronizationIsActive()) {
            try {
                this.harvestSchedulingManager.manageHarvest();
            }
            catch (SchedulerException ex) {
                ex.printStackTrace();
                logger.error((Object)"unable to reschedule jobs due to harvestSchedulingManager.manageHarvest failure");
            }
        } else {
            this.removeListener();
            logger.warn((Object)(((NodeReference)message.getMessageObject()).getValue() + "-  NodeTopicListener Disabled"));
        }
    }
}

