/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.batch.synchronization.tasks;

import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;

public class DelayWrapper<T>
implements Delayed {
    private final long origin;
    private final long delay;
    private final T wrappedObject;

    public DelayWrapper(T wrappedObject) {
        this(wrappedObject, 0L);
    }

    public DelayWrapper(T queueItem, long delay) {
        if (queueItem == null) {
            throw new IllegalArgumentException("queue item parameter cannot be null");
        }
        this.origin = System.currentTimeMillis();
        this.wrappedObject = queueItem;
        this.delay = delay;
    }

    public T getWrappedObject() {
        return this.wrappedObject;
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert(this.delay - (System.currentTimeMillis() - this.origin), TimeUnit.MILLISECONDS);
    }

    @Override
    public int compareTo(Delayed delayed) {
        if (delayed == this) {
            return 0;
        }
        if (delayed instanceof DelayWrapper) {
            long diff = this.delay - ((DelayWrapper)delayed).delay;
            return diff == 0L ? 0 : (diff < 0L ? -1 : 1);
        }
        long d = this.getDelay(TimeUnit.MILLISECONDS) - delayed.getDelay(TimeUnit.MILLISECONDS);
        return d == 0L ? 0 : (d < 0L ? -1 : 1);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.wrappedObject == null ? 0 : this.wrappedObject.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DelayWrapper)) {
            return false;
        }
        DelayWrapper other = (DelayWrapper)obj;
        return !(this.wrappedObject == null ? other.wrappedObject != null : !this.wrappedObject.equals(other.wrappedObject));
    }
}

