/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.batch.synchronization.tasks;

import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.dataone.cn.batch.synchronization.type.NodeComm;
import org.dataone.cn.synchronization.types.SyncObject;
import org.dataone.configuration.Settings;
import org.dataone.service.exceptions.BaseException;
import org.dataone.service.exceptions.InvalidToken;
import org.dataone.service.exceptions.NotAuthorized;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.exceptions.SynchronizationFailed;
import org.dataone.service.mn.tier1.v2.MNRead;
import org.dataone.service.types.v1.Session;

public class SyncFailedTask
implements Callable<String> {
    static final Logger logger = Logger.getLogger(SyncFailedTask.class);
    private NodeComm nodeCommunications;
    private SyncObject task;
    private Session session = null;

    public SyncFailedTask(NodeComm nodeCommunications, SyncObject task) {
        this.nodeCommunications = nodeCommunications;
        this.task = task;
    }

    @Override
    public String call() {
        ServiceFailure serviceFailure = new ServiceFailure("-1", "Connection failure. Connection timed out on service call.");
        this.submitSynchronizationFailed(this.task.getPid(), null, (BaseException)((Object)serviceFailure));
        return "done";
    }

    public static SynchronizationFailed createSynchronizationFailed(String pid, String additionalContext, Exception exception) {
        String nodeId = Settings.getConfiguration().getString("cn.nodeId");
        Throwable be = null;
        if (exception instanceof BaseException) {
            be = (BaseException)((Object)exception);
        } else {
            be = new ServiceFailure("-1", String.format("%s - %s. %s", exception.getClass().getCanonicalName(), exception.getMessage(), additionalContext));
            be.initCause((Throwable)exception);
        }
        SynchronizationFailed syncFailed = new SynchronizationFailed("6001", String.format("Synchronization task of [PID::] %s [::PID] failed. Cause: %s: %s", pid, be.getClass().getSimpleName(), be.getDescription()));
        syncFailed.setPid(pid);
        syncFailed.setNodeId(nodeId);
        return syncFailed;
    }

    public void submitSynchronizationFailed(String pid, String additionalContext, BaseException exception) {
        SynchronizationFailed syncFailed = SyncFailedTask.createSynchronizationFailed(pid, additionalContext, (Exception)((Object)exception));
        this.submitSynchronizationFailed(syncFailed);
    }

    public void submitSynchronizationFailed(SynchronizationFailed syncFailed) {
        logger.warn((Object)String.format("%s - SynchronizationFailed: detail code: %s id:%s nodeId:%s description:%s", this.task.taskLabel(), syncFailed.getDetail_code(), syncFailed.getPid(), syncFailed.getNodeId(), syncFailed.getDescription()));
        try {
            Object mnRead = this.nodeCommunications.getMnRead();
            if (mnRead instanceof MNRead) {
                ((MNRead)mnRead).synchronizationFailed(this.session, syncFailed);
            }
            if (mnRead instanceof org.dataone.service.mn.tier1.v1.MNRead) {
                ((org.dataone.service.mn.tier1.v1.MNRead)mnRead).synchronizationFailed(this.session, syncFailed);
            }
        }
        catch (InvalidToken ex) {
            logger.error((Object)(this.task.taskLabel() + " " + ex.serialize(0)));
        }
        catch (NotAuthorized ex) {
            logger.error((Object)(this.task.taskLabel() + " " + ex.serialize(0)));
        }
        catch (NotImplemented ex) {
            logger.error((Object)(this.task.taskLabel() + " " + ex.serialize(0)));
        }
        catch (ServiceFailure ex) {
            logger.error((Object)(this.task.taskLabel() + " " + ex.serialize(0)));
        }
        catch (Exception ex) {
            logger.error((Object)(this.task.taskLabel() + " " + ex.getMessage()));
        }
    }
}

