/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.batch.synchronization.tasks;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import org.dataone.service.types.v1.ObjectInfo;
import org.dataone.service.types.v1.ObjectList;

public class SortedHarvestTimepointMap {
    private Date fromDate;
    private Date toDate;
    private Date earliestRemoveDate = null;
    private Integer maxHarvestSize = null;
    private int totalRetainedPids = 0;
    private TreeMap<Date, List<String>> pidMap = new TreeMap();

    public SortedHarvestTimepointMap(Date fromDate, Date toDate, Integer maxHarvestSize) {
        this.fromDate = fromDate;
        this.toDate = toDate;
        this.maxHarvestSize = maxHarvestSize;
    }

    int getHarvestSize() {
        return this.totalRetainedPids;
    }

    Date getLatestTimePoint() {
        try {
            return this.pidMap.lastKey();
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    Date getEarliestTimePoint() {
        try {
            return this.pidMap.firstKey();
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    void addObjectList(ObjectList ol) {
        for (ObjectInfo oi : ol.getObjectInfoList()) {
            Date smdDate = oi.getDateSysMetadataModified();
            if (this.fromDate != null && this.fromDate.after(smdDate) || this.toDate != null && this.toDate.before(smdDate) || this.earliestRemoveDate != null && !smdDate.before(this.earliestRemoveDate)) continue;
            if (!this.pidMap.containsKey(smdDate)) {
                this.pidMap.put(smdDate, new ArrayList());
            }
            this.pidMap.get(smdDate).add(oi.getIdentifier().getValue());
            ++this.totalRetainedPids;
            if (this.maxHarvestSize == null || this.totalRetainedPids <= this.maxHarvestSize || this.pidMap.size() <= 1) continue;
            this.removeLatestTimePoint();
        }
    }

    private int removeLatestTimePoint() {
        Date latestTime = this.getLatestTimePoint();
        if (latestTime == null) {
            return 0;
        }
        if (this.earliestRemoveDate == null) {
            this.earliestRemoveDate = latestTime;
        } else if (this.earliestRemoveDate.after(latestTime)) {
            this.earliestRemoveDate = latestTime;
        }
        int removedPidCount = this.pidMap.remove(latestTime).size();
        this.totalRetainedPids -= removedPidCount;
        return removedPidCount;
    }

    Iterator<Map.Entry<Date, List<String>>> getAscendingIterator() {
        return this.pidMap.entrySet().iterator();
    }
}

