/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.service.cn.replication;

import com.hazelcast.core.IMap;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dataone.cn.data.repository.ReplicationTask;
import org.dataone.cn.data.repository.ReplicationTaskRepository;
import org.dataone.cn.hazelcast.HazelcastClientFactory;
import org.dataone.cn.log.MetricEvent;
import org.dataone.cn.log.MetricLogClientFactory;
import org.dataone.cn.log.MetricLogEntry;
import org.dataone.service.cn.replication.ReplicationFactory;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.NodeReference;
import org.dataone.service.types.v1.TypeFactory;
import org.dataone.service.types.v2.SystemMetadata;

public class ReplicationTaskMonitor
implements Runnable {
    private static Logger log = Logger.getLogger(ReplicationTaskMonitor.class);
    private static ReplicationTaskRepository taskRepository = ReplicationFactory.getReplicationTaskRepository();
    private IMap<Identifier, SystemMetadata> systemMetadataMap = HazelcastClientFactory.getSystemMetadataMap();
    private Map<String, Counter> statusCount = new HashMap<String, Counter>();
    private Map<NodeReference, Counter> authMNCount = new HashMap<NodeReference, Counter>();

    @Override
    public void run() {
        log.debug((Object)"Replication task monitoring executing.");
        Iterable allTasks = taskRepository.findAll();
        if (allTasks != null) {
            MetricLogEntry metricLogEntry;
            for (ReplicationTask task : allTasks) {
                this.processCounters(task);
            }
            Date reportDate = new Date();
            for (Map.Entry<String, Counter> entry : this.statusCount.entrySet()) {
                metricLogEntry = new MetricLogEntry(MetricEvent.REPLICATION_TASKS);
                metricLogEntry.setMessage(String.format("Total Replication Tasks %s: %d", entry.getKey(), entry.getValue().getCount()));
                metricLogEntry.setDateLogged(reportDate);
                MetricLogClientFactory.getMetricLogClient().logMetricEvent(metricLogEntry);
            }
            for (Map.Entry<String, Counter> entry : this.authMNCount.entrySet()) {
                metricLogEntry = new MetricLogEntry(MetricEvent.REPLICATION_TASKS, (NodeReference)entry.getKey());
                metricLogEntry.setMessage(String.format("Replication Tasks: %d", entry.getValue().getCount()));
                metricLogEntry.setDateLogged(reportDate);
                MetricLogClientFactory.getMetricLogClient().logMetricEvent(metricLogEntry);
            }
        }
    }

    private void processCounters(ReplicationTask task) {
        String status = task.getStatus();
        try {
            this.statusCount.get(status).increment();
        }
        catch (NullPointerException e) {
            this.statusCount.put(status, new Counter());
            this.statusCount.get(status).increment();
        }
        NodeReference authMN = this.getAuthoritativeMN(task.getPid());
        try {
            this.authMNCount.get(authMN).increment();
        }
        catch (NullPointerException e) {
            this.authMNCount.put(authMN, new Counter());
            this.authMNCount.get(authMN).increment();
        }
    }

    private NodeReference getAuthoritativeMN(String pid) {
        try {
            return ((SystemMetadata)this.systemMetadataMap.get((Object)TypeFactory.buildIdentifier((String)pid))).getAuthoritativeMemberNode();
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    private class Counter {
        private int count = 0;

        private Counter() {
        }

        void increment() {
            ++this.count;
        }

        int getCount() {
            return this.count;
        }
    }
}

