/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.data.repository;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang.time.FastDateFormat;
import org.apache.log4j.Logger;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.NodeReference;
import org.hibernate.annotations.Index;

@Entity
@Table(name="replication_try_history")
public class ReplicationAttemptHistory
implements Serializable {
    private static final long serialVersionUID = -3273504291943429461L;
    @Transient
    private static final Logger log = Logger.getLogger(ReplicationAttemptHistory.class);
    @Transient
    private final FastDateFormat format = FastDateFormat.getInstance((String)"MM/dd/yyyy:HH:mm:ss:SS");
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private Long id;
    @Index(name="index_pid")
    @Column(columnDefinition="TEXT", nullable=false)
    private String pid;
    @Column(columnDefinition="TEXT", nullable=false)
    private String nodeId;
    private Integer replicationAttempts = 0;
    @Column(nullable=false)
    private long lastReplicationAttemptDate;

    public ReplicationAttemptHistory() {
    }

    public ReplicationAttemptHistory(Identifier identifier, NodeReference nodeReference, Integer numbReplicationAttempts) {
        if (identifier != null) {
            this.pid = identifier.getValue();
        }
        if (nodeReference != null) {
            this.nodeId = nodeReference.getValue();
        }
        if (numbReplicationAttempts != null) {
            this.replicationAttempts = numbReplicationAttempts;
        }
        this.lastReplicationAttemptDate = System.currentTimeMillis();
    }

    @Transient
    public String getLastReplicationAttemptDateString() {
        return this.format.format(this.getLastReplicationAttemptDate());
    }

    public Long getId() {
        return this.id;
    }

    public String getPid() {
        return this.pid;
    }

    public void setPid(String pid) {
        this.pid = pid;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public Integer getReplicationAttempts() {
        return this.replicationAttempts;
    }

    public void setReplicationAttempts(Integer replicationAttempts) {
        this.replicationAttempts = replicationAttempts;
    }

    public long getLastReplicationAttemptDate() {
        return this.lastReplicationAttemptDate;
    }

    public void setLastReplicationAttemptDate(long lastReplicationAttemptDate) {
        this.lastReplicationAttemptDate = lastReplicationAttemptDate;
    }

    @Transient
    public void incrementReplicationAttempts() {
        this.setReplicationAttempts(this.replicationAttempts + 1);
    }

    @Transient
    public String toString() {
        return "ReplicationTryHistory [id=" + this.id + ", pid=" + this.pid + ", nodeId=" + this.getNodeId() + ", replication attempts=" + this.getReplicationAttempts() + ", last attempt=" + this.getLastReplicationAttemptDateString() + "']";
    }
}

