/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.service.cn.replication;

import java.util.Date;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dataone.cn.dao.DaoFactory;
import org.dataone.cn.dao.ReplicationDao;
import org.dataone.cn.dao.exceptions.DataAccessException;
import org.dataone.cn.log.MetricEvent;
import org.dataone.cn.log.MetricLogClientFactory;
import org.dataone.cn.log.MetricLogEntry;
import org.dataone.service.types.v2.TypeFactory;

public class ReplicationStatusMonitor
implements Runnable {
    private static Logger log = Logger.getLogger(ReplicationStatusMonitor.class);
    private ReplicationDao replicationDao = DaoFactory.getReplicationDao();

    @Override
    public void run() {
        try {
            Date reportDate = new Date();
            Map summary = this.replicationDao.getCountsByNodeStatus();
            for (Map.Entry n : summary.entrySet()) {
                String[] nodeStatusPair = StringUtils.split((String)((String)n.getKey()), (String)"-");
                String nodeId = nodeStatusPair[0];
                String status = nodeStatusPair[1];
                MetricLogEntry metricLogEntry = new MetricLogEntry(MetricEvent.REPLICA_STATUS, TypeFactory.buildNodeReference((String)nodeId));
                metricLogEntry.setMessage(String.format("Replica Status %s:  %d", status, n.getValue()));
                metricLogEntry.setDateLogged(reportDate);
                MetricLogClientFactory.getMetricLogClient().logMetricEvent(metricLogEntry);
                n.getValue();
            }
        }
        catch (DataAccessException e) {
            log.warn((Object)("DAOAccessException while trying to get Replica status statistics with message: " + e.getMessage()), (Throwable)e);
        }
    }
}

