/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.service.cn.replication;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ILock;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.dataone.cn.dao.DaoFactory;
import org.dataone.cn.dao.ReplicationDao;
import org.dataone.cn.dao.exceptions.DataAccessException;
import org.dataone.cn.hazelcast.HazelcastClientFactory;
import org.dataone.service.cn.replication.ReplicationFactory;
import org.dataone.service.cn.replication.ReplicationService;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.NodeReference;

public class ReplicationTaskQueue {
    private static Logger log = Logger.getLogger(ReplicationTaskQueue.class);
    private ReplicationDao replicationDao = DaoFactory.getReplicationDao();
    private ReplicationService replicationService = ReplicationFactory.getReplicationService();
    private HazelcastInstance hzClient = HazelcastClientFactory.getProcessingClient();

    public void logState() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"logging replication task queue state:");
            for (NodeReference nodeReference : this.getMemberNodesInQueue()) {
                log.debug((Object)("Member Node: " + nodeReference.getValue() + " has " + this.getCountOfTasksForNode(nodeReference.getValue())));
            }
            log.debug((Object)"finished reporting replication task queue state");
        }
    }

    public Collection<NodeReference> getMemberNodesInQueue() {
        ArrayList<NodeReference> nodes = new ArrayList();
        try {
            nodes = this.replicationDao.getMemberNodesWithQueuedReplica();
        }
        catch (DataAccessException dae) {
            log.error((Object)"Cannot get member nodes in queue.", (Throwable)dae);
        }
        return nodes;
    }

    public int getCountOfTasksForNode(String nodeId) {
        int count = 0;
        try {
            count = this.replicationDao.getQueuedReplicaCountByNode(nodeId);
        }
        catch (DataAccessException dae) {
            log.error((Object)("Cannot get count of tasks for node: " + nodeId), (Throwable)dae);
        }
        return count;
    }

    private boolean containsTask(String nodeId, String identifier) {
        log.debug((Object)"invoking contains task");
        if (nodeId == null || identifier == null) {
            return false;
        }
        boolean contains = false;
        try {
            contains = this.replicationDao.queuedReplicaExists(identifier, nodeId);
        }
        catch (DataAccessException dae) {
            log.error((Object)"Error executing queuedReplicaExists", (Throwable)dae);
        }
        return contains;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processAllTasksForMN(String memberNodeIdentifierValue) {
        String mnId = memberNodeIdentifierValue;
        boolean isLocked = false;
        if (mnId != null) {
            log.debug((Object)("ReplicationTaskQueue. Processing all tasks for node: " + mnId + "."));
            Collection<ReplicationDao.ReplicaDto> queuedReplicas = this.getQueuedReplicas(mnId);
            int queuedCount = queuedReplicas.size();
            log.debug((Object)(queuedCount + " tasks for mn: " + mnId));
            if (queuedCount > 0) {
                ILock lock = this.hzClient.getLock((Object)memberNodeIdentifierValue);
                try {
                    isLocked = lock.tryLock();
                    if (isLocked) {
                        for (ReplicationDao.ReplicaDto replica : queuedReplicas) {
                            if (replica == null) continue;
                            try {
                                this.requestReplication(replica.identifier, replica.replica.getReplicaMemberNode());
                            }
                            catch (Exception e) {
                                log.error((Object)"Caught exception requesting replica", (Throwable)e);
                            }
                        }
                    } else {
                        log.warn((Object)("Didn't get the lock for node id " + memberNodeIdentifierValue));
                    }
                }
                catch (Exception e) {
                    log.error((Object)"Error requesting replica for queued replica", (Throwable)e);
                }
                finally {
                    if (isLocked) {
                        lock.unlock();
                    }
                }
            }
        }
    }

    private void requestReplication(Identifier identifier, NodeReference targetNode) {
        if (identifier == null || targetNode == null) {
            return;
        }
        log.debug((Object)("Requesting replica for id " + identifier.getValue() + " and target node " + targetNode.getValue()));
        try {
            this.replicationService.requestQueuedReplication(identifier, targetNode);
        }
        catch (Exception e) {
            log.error((Object)"Error requesting replica", (Throwable)e);
        }
    }

    private Collection<ReplicationDao.ReplicaDto> getQueuedReplicas(String mnId) {
        ArrayList<ReplicationDao.ReplicaDto> queuedReplicas = new ArrayList();
        try {
            queuedReplicas = this.replicationDao.getQueuedReplicasByNode(mnId);
        }
        catch (DataAccessException dae) {
            log.error((Object)("unable to get queue replicas for node: " + mnId), (Throwable)dae);
        }
        return queuedReplicas;
    }
}

