/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.service.cn.replication;

import java.net.URI;
import java.util.List;
import org.apache.log4j.Logger;
import org.dataone.client.D1NodeFactory;
import org.dataone.client.rest.HttpMultipartRestClient;
import org.dataone.client.rest.MultipartRestClient;
import org.dataone.client.v2.CNode;
import org.dataone.client.v2.itk.D1Client;
import org.dataone.configuration.Settings;
import org.dataone.service.cn.replication.ReplicationCommunication;
import org.dataone.service.exceptions.BaseException;
import org.dataone.service.exceptions.InvalidRequest;
import org.dataone.service.exceptions.InvalidToken;
import org.dataone.service.exceptions.NotAuthorized;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.NodeReference;
import org.dataone.service.types.v1.Replica;
import org.dataone.service.types.v1.ReplicationStatus;
import org.dataone.service.types.v2.SystemMetadata;

public class ReplicationService {
    private CNode cn;
    public static Logger log = Logger.getLogger(ReplicationService.class);

    public ReplicationService() {
        this.initializeCN();
    }

    public void requestQueuedReplication(Identifier identifier, NodeReference targetNode) {
        if (identifier == null || targetNode == null) {
            return;
        }
        if (this.cn == null) {
            log.error((Object)"Unable to request replicas - CN is null.");
            return;
        }
        SystemMetadata sysmeta = null;
        try {
            sysmeta = this.getSystemMetadata(identifier);
        }
        catch (NotFound notFound) {
            // empty catch block
        }
        if (sysmeta == null) {
            log.error((Object)("Unable to get system metadata for: " + identifier.getValue() + ". exiting..."));
            return;
        }
        if (this.alreadyReplicated(sysmeta, targetNode)) {
            log.debug((Object)("Replica is already handled for " + targetNode.getValue() + ", identifier " + identifier.getValue() + ". exiting..."));
            return;
        }
        boolean updated = this.setReplicaToRequested(identifier, targetNode);
        if (!updated) {
            log.error((Object)("Unable to set replication status to 'requested' for: " + identifier.getValue() + " for node: " + targetNode.getValue() + ". exiting..."));
            return;
        }
        ReplicationCommunication rc = ReplicationCommunication.getInstance(targetNode);
        boolean success = false;
        try {
            success = rc.requestReplication(targetNode, sysmeta);
        }
        catch (BaseException e) {
            log.warn((Object)e.getMessage(), (Throwable)e);
        }
        if (!success) {
            log.error((Object)("Unable to request replica from target mn: " + targetNode.getValue() + " for: " + identifier.getValue() + ". setting status to failed."));
            this.setReplicationStatus(identifier, targetNode, ReplicationStatus.FAILED);
        }
    }

    public boolean deleteReplicationMetadata(Identifier pid, NodeReference targetNode) {
        if (this.cn == null) {
            log.error((Object)"cannot set replication status, no CN object");
            return false;
        }
        boolean deleted = false;
        for (int i = 0; i < 5; ++i) {
            try {
                SystemMetadata sysmeta = this.getSystemMetadata(pid);
                deleted = this.cn.deleteReplicationMetadata(null, pid, targetNode, sysmeta.getSerialVersion().longValue());
                if (!deleted) continue;
                break;
            }
            catch (BaseException be) {
                log.error((Object)("BaseException error in calling deleteReplicationMetadata() for identifier " + pid.getValue() + " and target node " + targetNode.getValue() + ": " + be.getMessage()), (Throwable)be);
                continue;
            }
            catch (RuntimeException re) {
                log.error((Object)("Runtime exception calling delete replica metadata for: " + pid.getValue() + " for node: " + targetNode.getValue()), (Throwable)re);
            }
        }
        if (!deleted) {
            log.error((Object)("Ultimately unable to delete replica metadata for: " + pid.getValue() + " on node: " + targetNode.getValue()));
        }
        return deleted;
    }

    public boolean setReplicaToRequested(Identifier identifier, NodeReference targetNode) {
        return this.setReplicationStatus(identifier, targetNode, ReplicationStatus.REQUESTED);
    }

    public boolean setReplicaToCompleted(Identifier identifier, NodeReference targetNode) {
        return this.setReplicationStatus(identifier, targetNode, ReplicationStatus.COMPLETED);
    }

    private boolean setReplicationStatus(Identifier pid, NodeReference targetNode, ReplicationStatus status) {
        if (this.cn == null) {
            log.error((Object)"cannot set replication status, no CN object");
            return false;
        }
        boolean updated = false;
        for (int i = 0; i < 5; ++i) {
            try {
                updated = this.cn.setReplicationStatus(null, pid, targetNode, status, null);
                if (!updated) continue;
                break;
            }
            catch (InvalidRequest ire) {
                log.warn((Object)("Couldn't set the replication status to " + status.toString() + ", it may have possibly already been set to completed for identifier " + pid.getValue() + " and target node " + targetNode.getValue() + ". The error was: " + ire.getMessage()), (Throwable)ire);
                continue;
            }
            catch (BaseException be) {
                log.error((Object)("Error in calling setReplicationStatus() for identifier " + pid.getValue() + ", target node " + targetNode.getValue() + " and status of " + status.toString() + ": " + be.getMessage() + ", detail code " + be.getDetail_code() + ", description: " + be.getDescription()), (Throwable)be);
            }
        }
        if (!updated) {
            log.error((Object)("Ultimately unable to update status: " + status + " for: " + pid.getValue() + " on node: " + targetNode.getValue()));
        }
        return updated;
    }

    private boolean alreadyReplicated(SystemMetadata sysmeta, NodeReference targetNode) {
        boolean handled = false;
        List replicaList = sysmeta.getReplicaList();
        for (Replica replica : replicaList) {
            ReplicationStatus currentStatus;
            NodeReference listedNode = replica.getReplicaMemberNode();
            if (!listedNode.getValue().equals(targetNode.getValue()) || (currentStatus = replica.getReplicationStatus()) != ReplicationStatus.REQUESTED && currentStatus != ReplicationStatus.COMPLETED) continue;
            handled = true;
            break;
        }
        if (handled) {
            log.debug((Object)("Replica is already handled for: " + sysmeta.getIdentifier().getValue() + " at node: " + targetNode.getValue()));
        }
        return handled;
    }

    private boolean hasQueuedReplica(SystemMetadata sysmeta, NodeReference targetNode) {
        boolean queued = false;
        List replicaList = sysmeta.getReplicaList();
        for (Replica replica : replicaList) {
            ReplicationStatus currentStatus;
            NodeReference listedNode = replica.getReplicaMemberNode();
            if (!listedNode.getValue().equals(targetNode.getValue()) || (currentStatus = replica.getReplicationStatus()) != ReplicationStatus.QUEUED) continue;
            queued = true;
            break;
        }
        if (!queued) {
            log.debug((Object)("Replica is not queued for: " + sysmeta.getIdentifier().getValue() + " at node: " + targetNode.getValue()));
        }
        return queued;
    }

    public SystemMetadata getSystemMetadata(Identifier identifier) throws NotFound {
        SystemMetadata sysmeta = null;
        if (identifier != null && identifier.getValue() != null) {
            try {
                sysmeta = this.cn.getSystemMetadata(null, identifier);
            }
            catch (InvalidToken e) {
                log.error((Object)("Cannot get system metedata for id: " + identifier.getValue()), (Throwable)e);
            }
            catch (ServiceFailure e) {
                log.error((Object)("Cannot get system metedata for id: " + identifier.getValue()), (Throwable)e);
            }
            catch (NotAuthorized e) {
                log.error((Object)("Cannot get system metedata for id: " + identifier.getValue()), (Throwable)e);
            }
            catch (NotImplemented e) {
                log.error((Object)("Cannot get system metedata for id: " + identifier.getValue()), (Throwable)e);
            }
        }
        return sysmeta;
    }

    public NodeReference determineReplicationSourceNode(SystemMetadata sysMeta) {
        NodeReference source = null;
        NodeReference authNode = sysMeta.getAuthoritativeMemberNode();
        for (Replica replica : sysMeta.getReplicaList()) {
            if (replica.getReplicaMemberNode().equals((Object)authNode) && replica.getReplicationStatus().equals((Object)ReplicationStatus.COMPLETED)) {
                source = authNode;
                break;
            }
            if (source != null || !replica.getReplicationStatus().equals((Object)ReplicationStatus.COMPLETED)) continue;
            source = replica.getReplicaMemberNode();
        }
        return source;
    }

    public boolean updateReplicationMetadata(Identifier pid, Replica replicaMetadata) {
        SystemMetadata sysmeta = null;
        boolean updated = false;
        for (int i = 0; i < 5; ++i) {
            try {
                sysmeta = this.getSystemMetadata(pid);
                updated = this.cn.updateReplicationMetadata(null, pid, replicaMetadata, sysmeta.getSerialVersion().longValue());
                if (!updated) continue;
                break;
            }
            catch (BaseException be) {
                if (be instanceof InvalidRequest) {
                    log.warn((Object)("Couldn't update replication metadata to " + replicaMetadata.getReplicationStatus().toString() + ", it may have possibly already been updated for identifier " + pid.getValue() + " and target node " + replicaMetadata.getReplicaMemberNode().getValue() + ". The error was: " + be.getMessage()), (Throwable)be);
                    return false;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)be);
                }
                log.error((Object)("Error in calling updateReplicationMetadata(): " + be.getMessage()));
                continue;
            }
            catch (RuntimeException re) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)re);
                }
                log.error((Object)("Error in getting sysyem metadata from the map: " + re.getMessage()));
            }
        }
        return updated;
    }

    private void initializeCN() {
        try {
            this.cn = D1Client.getCN();
        }
        catch (BaseException e) {
            log.warn((Object)"Caught a ServiceFailure while getting a reference to the CN ", (Throwable)e);
            try {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e1) {
                    log.error((Object)"There was a problem getting a Coordinating Node reference.", (Throwable)e1);
                }
                this.cn = D1Client.getCN();
            }
            catch (BaseException e1) {
                log.warn((Object)"Second ServiceFailure while getting a reference to the CN", (Throwable)e1);
                try {
                    log.warn((Object)"...Building CNode without baseURL check.");
                    this.cn = (CNode)D1NodeFactory.buildNode(CNode.class, (MultipartRestClient)new HttpMultipartRestClient(), (URI)URI.create(Settings.getConfiguration().getString("D1Client.CN_URL")));
                }
                catch (Exception e2) {
                    log.error((Object)"ClientSideException trying to build a CNode.", (Throwable)e2);
                    this.cn = null;
                }
            }
        }
    }
}

