/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.service.cn.replication;

import com.hazelcast.core.HazelcastInstance;
import java.io.File;
import java.io.Serializable;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.dataone.client.auth.CertificateManager;
import org.dataone.client.v2.CNode;
import org.dataone.client.v2.itk.D1Client;
import org.dataone.cn.hazelcast.HazelcastClientFactory;
import org.dataone.configuration.Settings;
import org.dataone.service.cn.replication.ReplicationCommunication;
import org.dataone.service.exceptions.BaseException;
import org.dataone.service.exceptions.InvalidRequest;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.exceptions.VersionMismatch;
import org.dataone.service.types.v1.Checksum;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.NodeReference;
import org.dataone.service.types.v1.Replica;
import org.dataone.service.types.v1.ReplicationStatus;
import org.dataone.service.types.v1.Session;
import org.dataone.service.types.v2.SystemMetadata;

public class MNReplicationTask
implements Serializable,
Callable<String> {
    public static Logger log = Logger.getLogger(MNReplicationTask.class);
    private String taskid;
    private String eventid;
    private Identifier pid;
    private NodeReference targetNode;
    private NodeReference originatingNode;
    private String targetNodeSubject;
    private String originatingNodeSubject;
    private ReplicationCommunication nodeCommunication;
    private CNode cn;
    private int retryCount;
    private String tasksQueue;
    private HazelcastInstance hzClient;
    private String cnRouterHostname;

    public MNReplicationTask() {
    }

    public MNReplicationTask(String taskid, Identifier pid, NodeReference originatingNode, NodeReference targetNode) {
        this.taskid = taskid;
        this.hzClient = HazelcastClientFactory.getProcessingClient();
        this.pid = pid;
        this.originatingNode = originatingNode;
        this.targetNode = targetNode;
        String clientCertificateLocation = Settings.getConfiguration().getString("D1Client.certificate.directory") + File.separator + Settings.getConfiguration().getString("D1Client.certificate.filename");
        CertificateManager.getInstance().setCertificateLocation(clientCertificateLocation);
        X509Certificate certificate = CertificateManager.getInstance().loadCertificate();
        String X500SubjectStr = CertificateManager.getInstance().getSubjectDN(certificate);
        log.info((Object)("MNReplicationTask task id " + this.taskid + " is using an X509 certificate with subject " + X500SubjectStr + " from " + clientCertificateLocation + " for identifier " + this.pid.getValue()));
        this.cnRouterHostname = "https://" + Settings.getConfiguration().getString("cn.router.hostname") + "/cn";
    }

    public String getTaskid() {
        return this.taskid;
    }

    public void setTaskid(String taskid) {
        this.taskid = taskid;
    }

    public Identifier getPid() {
        return this.pid;
    }

    public String getEventid() {
        return this.eventid;
    }

    public void setEventid(String eventid) {
        this.eventid = eventid;
    }

    public NodeReference getTargetNode() {
        return this.targetNode;
    }

    public void setTargetNode(NodeReference targetNode) {
        this.targetNode = targetNode;
    }

    public NodeReference getOriginatingNode() {
        return this.originatingNode;
    }

    public void setOriginatingNode(NodeReference originatingNode) {
        this.originatingNode = originatingNode;
    }

    public String getTargetNodeSubject() {
        return this.targetNodeSubject;
    }

    public void setTargetNodeSubject(String subject) {
        this.targetNodeSubject = subject;
    }

    public String getOriginatingNodeSubject() {
        return this.originatingNodeSubject;
    }

    public void setOriginatingNodeSubject(String subject) {
        this.originatingNodeSubject = subject;
    }

    @Override
    public String call() {
        Session session;
        boolean deleted;
        boolean updated;
        boolean success;
        boolean exists;
        ReplicationStatus status;
        SystemMetadata sysmeta;
        block41: {
            log.info((Object)("Replication attempt # " + (this.getRetryCount() + 1) + " for replication task " + this.getTaskid() + " for identifier " + this.getPid().getValue() + " on node " + this.getTargetNode().getValue()));
            sysmeta = null;
            status = null;
            Object lock = null;
            Object lockString = null;
            boolean isLocked = false;
            exists = false;
            success = false;
            updated = false;
            deleted = false;
            session = null;
            try {
                this.cn = D1Client.getCN();
            }
            catch (Exception e) {
                log.warn((Object)("Caught an exception while getting a reference to the CN during replication task id " + this.getTaskid() + ", identifier " + this.getPid().getValue() + ", target node " + this.getTargetNode().getValue() + ". Trying again..."));
                try {
                    Thread.sleep(5000L);
                    this.cn = D1Client.getCN();
                }
                catch (ServiceFailure e1) {
                    log.warn((Object)("Second ServiceFailure while getting a reference to the CN during replication task id " + this.getTaskid() + ", identifier " + this.getPid().getValue() + ", target node " + this.getTargetNode().getValue()), (Throwable)e1);
                    this.cn = null;
                    success = false;
                }
                catch (InterruptedException ie) {
                    log.error((Object)("Caught InterruptedException while getting a reference to the CN during replication task id " + this.getTaskid() + ", identifier " + this.getPid().getValue() + ", target node " + this.getTargetNode().getValue()), (Throwable)ie);
                    this.cn = null;
                    success = false;
                }
                catch (NotImplemented ne) {
                    log.error((Object)("Caught NotImplemented while getting a reference to the CN during replication task id " + this.getTaskid() + ", identifier " + this.getPid().getValue() + ", target node " + this.getTargetNode().getValue()), (Throwable)ne);
                    this.cn = null;
                    success = false;
                }
            }
            this.nodeCommunication = ReplicationCommunication.getInstance(this.targetNode);
            try {
                if (this.cn != null && this.nodeCommunication != null) {
                    sysmeta = this.cn.getSystemMetadata(session, this.pid);
                    List replicaList = sysmeta.getReplicaList();
                    boolean handled = false;
                    for (Replica replica : replicaList) {
                        NodeReference listedNode = replica.getReplicaMemberNode();
                        ReplicationStatus currentStatus = replica.getReplicationStatus();
                        if (listedNode != this.targetNode || currentStatus != ReplicationStatus.REQUESTED && currentStatus != ReplicationStatus.COMPLETED) continue;
                        handled = true;
                        break;
                    }
                    if (!handled) {
                        try {
                            Checksum checksum = this.nodeCommunication.getChecksumFromMN(this.getPid(), this.targetNode, sysmeta);
                            if (checksum.equals(sysmeta.getChecksum())) {
                                exists = true;
                            }
                            break block41;
                        }
                        catch (NotFound nfe) {
                            status = ReplicationStatus.REQUESTED;
                            updated = this.cn.setReplicationStatus(session, this.getPid(), this.targetNode, status, null);
                            log.debug((Object)("Task id " + this.getTaskid() + " called setReplicationStatus() for identifier " + this.pid.getValue() + ". updated result: " + updated));
                            success = this.nodeCommunication.requestReplication(this.targetNode, sysmeta);
                            log.info((Object)("Task id " + this.getTaskid() + " called replicate() at targetNode " + this.targetNode.getValue() + ", identifier " + this.pid.getValue() + ". Success: " + success));
                        }
                        break block41;
                    }
                    log.info((Object)("for task id " + this.getTaskid() + " replica is already handled for " + this.targetNode.getValue() + ", identifier " + this.pid.getValue()));
                    break block41;
                }
                log.error((Object)("Can't get system metadata: CNode object is null for  task id " + this.getTaskid() + ", identifier " + this.getPid().getValue() + ", target node " + this.getTargetNode().getValue()));
                success = false;
            }
            catch (BaseException e) {
                log.error((Object)("Caught base exception attempting to call replicate for pid: " + this.pid.getValue() + " with exception: " + e.getDescription() + " and message: " + e.getMessage()), (Throwable)e);
                try {
                    log.info((Object)("The call to MN.replicate() failed for " + this.pid.getValue() + " on " + this.targetNode.getValue() + ". Trying again in 5 seconds."));
                    ++this.retryCount;
                    Thread.sleep(5000L);
                    if (this.cn != null && this.nodeCommunication != null) {
                        try {
                            Checksum checksum = this.nodeCommunication.getChecksumFromMN(this.getPid(), this.targetNode, sysmeta);
                            exists = checksum.equals(sysmeta.getChecksum());
                        }
                        catch (NotFound nf) {
                            sysmeta = this.cn.getSystemMetadata(session, this.pid);
                            success = this.nodeCommunication.requestReplication(this.targetNode, sysmeta);
                            log.info((Object)("Task id " + this.getTaskid() + " called replicate() at targetNode " + this.targetNode.getValue() + ", identifier " + this.pid.getValue() + ". Success: " + success));
                        }
                    }
                    log.error((Object)("Can't get system metadata: CNode object is null for  task id " + this.getTaskid() + ", identifier " + this.getPid().getValue() + ", target node " + this.getTargetNode().getValue()));
                    success = false;
                }
                catch (BaseException e1) {
                    log.error((Object)("Caught base exception attempting to call replicate for pid: " + this.pid.getValue() + " with exception: " + e.getDescription() + " and message: " + e.getMessage()), (Throwable)e);
                    log.error((Object)("There was a second problem calling replicate() on " + this.getTargetNode().getValue() + " for identifier " + this.getPid().getValue() + " during  task id " + this.getTaskid()), (Throwable)e1);
                    success = false;
                }
                catch (InterruptedException ie) {
                    log.error((Object)("Caught InterruptedException while calling replicate() during replication task id " + this.getTaskid() + ", identifier " + this.getPid().getValue() + ", target node " + this.getTargetNode().getValue()), (Throwable)ie);
                    success = false;
                }
            }
            catch (Exception e) {
                log.error((Object)("Unknown exception during replication task id " + this.getTaskid() + ", identifier " + this.getPid().getValue() + ", target node " + this.getTargetNode().getValue() + ". Error message: " + e.getMessage()), (Throwable)e);
                success = false;
            }
        }
        status = success ? ReplicationStatus.REQUESTED : ReplicationStatus.FAILED;
        if (exists) {
            status = ReplicationStatus.COMPLETED;
        }
        if (!updated) {
            if (this.cn != null) {
                if (!status.equals((Object)ReplicationStatus.FAILED)) {
                    try {
                        updated = this.cn.setReplicationStatus(session, this.pid, this.targetNode, status, null);
                    }
                    catch (BaseException be) {
                        if (be instanceof InvalidRequest) {
                            log.warn((Object)("Couldn't set the replication status to " + status.toString() + ", it may have possibly already been set to completed for identifier " + this.pid.getValue() + " and target node " + this.targetNode.getValue() + ". The error was: " + be.getMessage()), (Throwable)be);
                            return this.pid.getValue();
                        }
                        log.error((Object)("There was a problem setting the replication status to " + status.toString() + "  for identifier " + this.pid.getValue() + " during  MNReplicationTask id " + this.taskid));
                        updated = this.setReplicationStatus(session, this.pid, this.targetNode, status, null);
                    }
                } else {
                    block42: {
                        try {
                            deleted = this.cn.deleteReplicationMetadata(session, this.pid, this.targetNode, sysmeta.getSerialVersion().longValue());
                        }
                        catch (BaseException be) {
                            if (!(be instanceof VersionMismatch)) break block42;
                            try {
                                sysmeta = this.cn.getSystemMetadata(session, this.pid);
                                deleted = this.cn.deleteReplicationMetadata(session, this.pid, this.targetNode, sysmeta.getSerialVersion().longValue());
                            }
                            catch (BaseException e) {
                                deleted = this.deleteReplicationMetadata(session, this.pid, this.targetNode);
                            }
                        }
                    }
                    if (!deleted) {
                        log.error((Object)("FAILED deletion of replica entry for identifier " + this.pid.getValue() + " and target node id " + this.targetNode.getValue()));
                    }
                }
            } else if (!status.equals((Object)ReplicationStatus.FAILED)) {
                log.error((Object)("Task " + this.getTaskid() + " can't update replica status for identifier " + this.pid.getValue() + " on node " + this.targetNode.getValue() + " to " + status.toString() + ". CNode reference is null, trying the router address."));
                updated = this.setReplicationStatus(session, this.pid, this.targetNode, status, null);
            } else {
                log.error((Object)("Task " + this.getTaskid() + " can't delete the replica entry for identifier " + this.pid.getValue() + " and node " + this.targetNode.getValue() + ". CNode reference is null, trying the router address."));
                deleted = this.deleteReplicationMetadata(session, this.pid, this.targetNode);
            }
        }
        log.trace((Object)("METRICS:\tREPLICATION:\tEND QUEUE:\tPID:\t" + this.pid.getValue() + "\tNODE:\t" + this.targetNode.getValue() + "\tSIZE:\t" + sysmeta.getSize().intValue()));
        if (updated) {
            log.info((Object)("Task " + this.getTaskid() + " updated replica status for identifier " + this.pid.getValue() + " on node " + this.targetNode.getValue() + " to " + status.toString()));
            log.trace((Object)("METRICS:\tREPLICATION:\t" + status.toString().toUpperCase() + ":\tPID:\t" + this.pid.getValue() + "\tNODE:\t" + this.targetNode.getValue() + "\tSIZE:\t" + sysmeta.getSize().intValue()));
        } else {
            log.info((Object)("Task " + this.getTaskid() + " didn't update replica status for identifier " + this.pid.getValue() + " on node " + this.targetNode.getValue() + " to " + status.toString()));
        }
        if (deleted) {
            log.info((Object)("Task " + this.getTaskid() + " deleted replica entry for identifier " + this.pid.getValue() + " and node " + this.targetNode.getValue()));
        }
        return this.pid.getValue();
    }

    private boolean setReplicationStatus(Session session, Identifier pid, NodeReference targetNode, ReplicationStatus status, BaseException failure) {
        log.warn((Object)"setReplicationStatus() called against the router CN address.  Is the local CN communicationg properly?");
        boolean updated = false;
        for (int i = 0; i < 5; ++i) {
            try {
                CNode cn = D1Client.getCN((String)this.cnRouterHostname);
                updated = cn.setReplicationStatus(session, pid, targetNode, status, null);
                if (!updated) continue;
                break;
            }
            catch (BaseException be) {
                if (be instanceof InvalidRequest) {
                    log.warn((Object)("Couldn't set the replication status to " + status.toString() + ", it may have possibly already been set to completed for identifier " + this.pid.getValue() + " and target node " + this.targetNode.getValue() + ". The error was: " + be.getMessage()), (Throwable)be);
                    return false;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)be);
                }
                log.error((Object)("Error in calling setReplicationStatus() at " + this.cnRouterHostname + " for identifier " + pid.getValue() + ", target node " + targetNode.getValue() + " and status of " + status.toString() + ": " + be.getMessage()), (Throwable)be);
            }
        }
        return updated;
    }

    private boolean deleteReplicationMetadata(Session session, Identifier pid, NodeReference targetNode) {
        boolean deleted = false;
        for (int i = 0; i < 5; ++i) {
            try {
                CNode cn = D1Client.getCN((String)this.cnRouterHostname);
                SystemMetadata sysmeta = cn.getSystemMetadata(session, pid);
                deleted = cn.deleteReplicationMetadata(session, pid, targetNode, sysmeta.getSerialVersion().longValue());
                if (!deleted) continue;
                break;
            }
            catch (BaseException be) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)be);
                }
                log.error((Object)("Error in calling deleteReplicationMetadata() at " + this.cnRouterHostname + " for identifier " + pid.getValue() + " and target node " + targetNode.getValue() + ": " + be.getMessage()), (Throwable)be);
                continue;
            }
            catch (RuntimeException re) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)re);
                }
                log.error((Object)("Error in getting sysyem metadata from the map for identifier " + pid.getValue() + ": " + re.getMessage()), (Throwable)re);
            }
        }
        return deleted;
    }

    public void run() {
        log.debug((Object)"MNReplicationTask.run() called.");
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public int getRetryCount() {
        return this.retryCount;
    }
}

