/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.portal;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jose.crypto.RSASSAVerifier;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.ReadOnlyJWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.cert.Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.net.ssl.HttpsURLConnection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.client.auth.AuthTokenSession;
import org.dataone.client.auth.CertificateManager;
import org.dataone.client.v1.itk.D1Client;
import org.dataone.configuration.Settings;
import org.dataone.service.types.v1.Person;
import org.dataone.service.types.v1.Session;
import org.dataone.service.types.v1.Subject;
import org.dataone.service.types.v1.SubjectInfo;
import org.dataone.service.util.DateTimeMarshaller;

public class TokenGenerator {
    public static Log log = LogFactory.getLog(TokenGenerator.class);
    private static volatile TokenGenerator instance = null;
    private String consumerKey = null;
    protected static List<RSAPublicKey> publicKeys = null;
    private BigInteger serverPubKeyModulus;
    private RSAPrivateKey privateKey = null;
    private final int TTL_SECONDS = Settings.getConfiguration().getInt("token.ttl", 64800);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TokenGenerator getInstance() throws IOException {
        if (instance != null) return instance;
        Class<TokenGenerator> clazz = TokenGenerator.class;
        synchronized (TokenGenerator.class) {
            if (instance != null) return instance;
            instance = new TokenGenerator();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private TokenGenerator() throws IOException {
        this.setAllKeys();
        Timer timer = new Timer("Signing Certificate Monitor");
        long certMonitorPeriod = 300000L;
        timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                try {
                    RSAPublicKey newPubKey;
                    Certificate newServerCert = TokenGenerator.this.fetchServerCertificate();
                    if (newServerCert != null && !(newPubKey = (RSAPublicKey)newServerCert.getPublicKey()).getModulus().equals(TokenGenerator.this.serverPubKeyModulus)) {
                        TokenGenerator.this.setAllKeys();
                        log.info((Object)("Portal reset the private key and public certificate after the certificate was renewed. The new certificate has the modulus " + TokenGenerator.this.serverPubKeyModulus));
                    }
                }
                catch (Exception e) {
                    log.warn((Object)("Couldn't fetch the server certificate for change comparison. " + e.getMessage()));
                }
            }
        }, new Date(), certMonitorPeriod);
    }

    public Certificate fetchServerCertificate() {
        String baseUrl = "URL NOT FOUND!";
        try {
            baseUrl = D1Client.getCN().getNodeBaseServiceUrl();
            URL url = new URL(baseUrl);
            log.debug((Object)("Fetching server certificate from CN URL: " + url));
            HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
            conn.connect();
            return conn.getServerCertificates()[0];
        }
        catch (Exception e) {
            log.error((Object)("Unable to fetch cert from server: " + baseUrl + "; error was: " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    public String getJWT(String userId, String fullName) throws JOSEException, ParseException, IOException {
        RSASSASigner signer = new RSASSASigner(this.privateKey);
        Calendar now = Calendar.getInstance();
        Calendar expires = Calendar.getInstance();
        expires.setTime(now.getTime());
        expires.add(13, this.TTL_SECONDS);
        JWTClaimsSet claimsSet = new JWTClaimsSet();
        claimsSet.setClaim("consumerKey", (Object)this.consumerKey);
        claimsSet.setClaim("userId", (Object)userId);
        claimsSet.setClaim("issuedAt", (Object)DateTimeMarshaller.serializeDateToUTC((Date)now.getTime()));
        claimsSet.setClaim("ttl", (Object)this.TTL_SECONDS);
        claimsSet.setClaim("fullName", (Object)fullName);
        claimsSet.setSubject(userId);
        claimsSet.setIssueTime(now.getTime());
        claimsSet.setExpirationTime(expires.getTime());
        SignedJWT signedJWT = new SignedJWT(new JWSHeader(JWSAlgorithm.RS256), (ReadOnlyJWTClaimsSet)claimsSet);
        signedJWT.sign((JWSSigner)signer);
        return signedJWT.serialize();
    }

    private synchronized void setPrivateKey() throws IOException {
        String privateKeyFileName = Settings.getConfiguration().getString("cn.server.privatekey.filename");
        CertificateManager cmInst = CertificateManager.getInstance();
        if (privateKeyFileName != null) {
            this.privateKey = (RSAPrivateKey)cmInst.loadPrivateKeyFromFile(privateKeyFileName, null);
        }
    }

    protected synchronized void setPublicKeys() throws IOException {
        publicKeys = new ArrayList<RSAPublicKey>();
        ArrayList<BigInteger> publicKeyModuli = new ArrayList<BigInteger>();
        Certificate cert = this.fetchServerCertificate();
        if (cert != null) {
            RSAPublicKey serverPublicKey = (RSAPublicKey)cert.getPublicKey();
            publicKeys.add(serverPublicKey);
            this.serverPubKeyModulus = serverPublicKey.getModulus();
            publicKeyModuli.add(this.serverPubKeyModulus);
            log.info((Object)("Successfully added cert from CN server, with modulus beginning: " + this.serverPubKeyModulus.toString().substring(0, 10) + "..."));
        } else {
            log.warn((Object)"There was a problem retrieving the Certificate from the server.");
        }
        Object[] certificateFileNames = Settings.getConfiguration().getStringArray("cn.server.publiccert.filename");
        if (certificateFileNames == null || certificateFileNames.length == 0) {
            log.info((Object)"No local certs defined in Settings");
            return;
        }
        log.debug((Object)("local certificate FileNames to be loaded: \n" + Arrays.toString(certificateFileNames)));
        for (Object certFileName : certificateFileNames) {
            Path certPath = Paths.get((String)certFileName, new String[0]);
            if (Files.isDirectory(certPath, new LinkOption[0]) || !Files.isReadable(certPath)) {
                log.warn((Object)("No readable Certificate file found at path: " + (String)certFileName));
                continue;
            }
            RSAPublicKey currentKey = (RSAPublicKey)CertificateManager.getInstance().loadCertificateFromFile((String)certFileName).getPublicKey();
            BigInteger currentKeyModulus = currentKey.getModulus();
            if (publicKeyModuli.contains(currentKeyModulus)) {
                log.warn((Object)("Certificate file " + (String)certFileName + " is a duplicate."));
                continue;
            }
            publicKeys.add(currentKey);
            publicKeyModuli.add(currentKeyModulus);
            log.info((Object)("Successfully added cert: " + (String)certFileName + ", with modulus beginning: " + currentKeyModulus.toString().substring(0, 10) + "..."));
        }
    }

    private void setConsumerKey() {
        this.consumerKey = Settings.getConfiguration().getString("annotator.consumerKey");
    }

    public Session getSession(String token) {
        AuthTokenSession session;
        try {
            SignedJWT signedJWT = SignedJWT.parse((String)token);
            if (!this.isKeyVerified(signedJWT)) {
                log.warn((Object)("FAILED to verify token against (total " + publicKeys.size() + ") configured public key(s)"));
                this.setAllKeys();
                if (!this.isKeyVerified(signedJWT)) {
                    log.warn((Object)("FAILED a second time, to verify token against (total " + publicKeys.size() + ") configured public key(s). Non-valid token follows:\n" + token));
                    return null;
                }
            }
            Calendar now = Calendar.getInstance();
            Date expDate = signedJWT.getJWTClaimsSet().getExpirationTime();
            if (!expDate.after(now.getTime())) {
                log.warn((Object)("Token expiration date has passed: " + expDate));
                return null;
            }
            String userId = signedJWT.getJWTClaimsSet().getSubject();
            Subject subject = new Subject();
            subject.setValue(userId);
            session = new AuthTokenSession(token);
            session.setSubject(subject);
            SubjectInfo subjectInfo = null;
            try {
                subjectInfo = D1Client.getCN().getSubjectInfo(subject);
            }
            catch (Exception be) {
                log.warn((Object)("No 'SubjectInfo' from CN; auto-populating. Error: " + be.getMessage()));
            }
            if (subjectInfo == null) {
                subjectInfo = new SubjectInfo();
                Person person = new Person();
                person.setSubject(subject);
                person.setFamilyName("Unknown");
                person.addGivenName("Unknown");
                subjectInfo.setPersonList(Collections.singletonList(person));
            }
            session.setSubjectInfo(subjectInfo);
        }
        catch (Exception e) {
            log.warn((Object)("Could not get session from provided token: " + token), (Throwable)e);
            return null;
        }
        return session;
    }

    private boolean isKeyVerified(SignedJWT signedJWT) throws JOSEException {
        for (RSAPublicKey publicKey : publicKeys) {
            RSASSAVerifier verifier = new RSASSAVerifier(publicKey);
            if (!signedJWT.verify((JWSVerifier)verifier)) continue;
            return true;
        }
        return false;
    }

    private void setAllKeys() throws IOException {
        this.setPublicKeys();
        this.setPrivateKey();
        this.setConsumerKey();
    }

    public static void main(String[] args) {
        String userId = args[0];
        String fullName = "Unknown";
        if (args.length > 1) {
            fullName = args[1];
        }
        String token = null;
        try {
            token = TokenGenerator.getInstance().getJWT(userId, fullName);
        }
        catch (JOSEException | IOException | ParseException e) {
            e.printStackTrace();
        }
        System.out.println(token);
    }
}

