/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public class BuffTool {
    public static void addInt(byte[] buff, int pos, int v) {
        buff[pos] = (byte)(v >>> 8 & 0xFF);
        buff[pos + 1] = (byte)(v & 0xFF);
    }

    public static int addString(byte[] buff, int pos, String v) {
        if (v != null) {
            int len = v.length();
            BuffTool.addInt(buff, pos, len);
            System.arraycopy(v.getBytes(), 0, buff, pos + 2, len);
            buff[pos + len + 2] = 0;
            return len + pos + 3;
        }
        BuffTool.addInt(buff, pos, 0);
        buff[pos + 2] = 0;
        return pos + 3;
    }

    public static void dump(byte[] buff, int len) throws UnsupportedEncodingException {
        int i = 0;
        while (i < len) {
            int j = i;
            while (j < i + 8) {
                if (j < len) {
                    if (buff[j] < 16 && buff[j] >= 0) {
                        System.out.print("0");
                    }
                    System.out.print(String.valueOf(Integer.toHexString(buff[j] & 0xFF)) + " ");
                }
                ++j;
            }
            if (i + 8 < len) {
                System.out.print(new String(buff, i, 8, "8859_1"));
            } else {
                System.out.print(new String(buff, i, len - i, "8859_1"));
            }
            System.out.println();
            i += 8;
        }
        System.out.println();
    }

    public static int findChar(byte[] buf, int start, int end, char c) {
        byte b = (byte)c;
        int offset = start;
        while (offset < end) {
            if (buf[offset] == b) {
                return offset;
            }
            ++offset;
        }
        return -1;
    }

    public static int findChars(byte[] buf, int start, int end, byte[] c) {
        int clen = c.length;
        int offset = start;
        while (offset < end) {
            int i = 0;
            while (i < clen) {
                if (buf[offset] == c[i]) {
                    return offset;
                }
                ++i;
            }
            ++offset;
        }
        return -1;
    }

    public static int findNotChars(byte[] buf, int start, int end, byte[] c) {
        int clen = c.length;
        int offset = start;
        while (offset < end) {
            boolean found = true;
            int i = 0;
            while (i < clen) {
                if (buf[offset] == c[i]) {
                    found = false;
                    break;
                }
                ++i;
            }
            if (found) {
                return offset;
            }
            ++offset;
        }
        return -1;
    }

    public static int getInt(byte[] b, int offset) {
        int b1 = b[offset] & 0xFF;
        int b2 = b[offset + 1] & 0xFF;
        return (b1 << 8) + b2;
    }

    public static String getString(byte[] b, int pos, int len) throws UnsupportedEncodingException {
        return new String(b, pos, len, "8859_1");
    }

    public static int readLine(InputStream in, byte[] b, int off, int len) throws IOException {
        int c;
        if (len <= 0) {
            return 0;
        }
        int count = 0;
        while ((c = in.read()) != -1) {
            b[off++] = (byte)c;
            if (c == 10 || ++count == len) break;
        }
        return count > 0 ? count : -1;
    }
}

