/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.core;

import java.io.File;
import java.io.IOException;
import java.net.FileNameMap;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.servlet.ServletContext;
import org.apache.tomcat.core.Container;
import org.apache.tomcat.core.ContextInterceptor;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.FacadeManager;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.RequestInterceptor;
import org.apache.tomcat.core.ServletLoader;
import org.apache.tomcat.core.ServletWrapper;
import org.apache.tomcat.core.TomcatException;
import org.apache.tomcat.facade.SimpleFacadeManager;
import org.apache.tomcat.logging.LogHelper;
import org.apache.tomcat.util.FileUtil;
import org.apache.tomcat.util.MimeMap;
import org.apache.tomcat.util.StringManager;
import org.apache.tomcat.util.URLUtil;

public class Context {
    private static StringManager sm = StringManager.getManager("org.apache.tomcat.core");
    private String path = "";
    private String docBase;
    private String absPath;
    private ContextManager contextM;
    private ServletContext contextFacade;
    private boolean crossContext = true;
    private ServletLoader servletL;
    boolean reloadable = true;
    private Hashtable attributes = new Hashtable();
    private File workDir;
    Object perms = null;
    Object protectionDomain;
    private Hashtable servlets = new Hashtable();
    private Hashtable initializationParameters = new Hashtable();
    private boolean expectUserWelcomeFiles = false;
    private Vector welcomeFiles = new Vector();
    private Hashtable errorPages = new Hashtable();
    private String description = null;
    private boolean isDistributable = false;
    private MimeMap mimeTypes = new MimeMap();
    private int sessionTimeOut = -1;
    Hashtable tagLibs = new Hashtable();
    Hashtable envEntryTypes = new Hashtable();
    Hashtable envEntryValues = new Hashtable();
    private Hashtable mappings = new Hashtable();
    Hashtable constraints = new Hashtable();
    Hashtable containers = new Hashtable();
    Container defaultContainer = null;
    private ServletWrapper defaultServlet = null;
    String authMethod;
    String realmName;
    String formLoginPage;
    String formErrorPage;
    int debug = 0;
    boolean trusted = false;
    String vhost = null;
    Vector vhostAliases = new Vector();
    FacadeManager facadeM;
    LogHelper loghelper = new LogHelper("tc_log", this);
    LogHelper loghelperServlet = new LogHelper("servlet_log", null);
    private boolean isWorkDirPersistent = false;
    private String engineHeader = null;
    private URL documentBase;
    private URL servletBase = null;
    private boolean isInvokerEnabled = false;
    private File warDir = null;
    private boolean isWARExpanded = false;
    private boolean isWARValidated = false;

    public Context() {
        this.defaultContainer = new Container();
        this.defaultContainer.setContext(this);
        this.defaultContainer.setPath(null);
    }

    public void addContentType(String ext, String type) {
        this.mimeTypes.addContentType(ext, type);
    }

    public void addContextInterceptor(ContextInterceptor ci) {
        this.getContainer().addContextInterceptor(ci);
    }

    public void addEnvEntry(String name, String type, String value, String description) {
        System.out.println("Add env-entry " + name + "  " + type + " " + value + " " + description);
        if (name == null || type == null) {
            throw new IllegalArgumentException();
        }
        this.envEntryTypes.put(name, type);
        if (value != null) {
            this.envEntryValues.put(name, value);
        }
    }

    public void addErrorPage(String errorType, String value) {
        this.errorPages.put(errorType, value);
    }

    public void addHostAlias(String alias) {
        this.vhostAliases.addElement(alias);
    }

    public void addInitParameter(String name, String value) {
        this.initializationParameters.put(name, value);
    }

    public void addRequestInterceptor(RequestInterceptor ci) {
        this.getContainer().addRequestInterceptor(ci);
    }

    public void addSecurityConstraint(String[] path, String[] methods, String[] roles, String transport) throws TomcatException {
        int i = 0;
        while (i < path.length) {
            Container ct = new Container();
            ct.setContext(this);
            ct.setTransport(transport);
            ct.setRoles(roles);
            ct.setPath(path[i]);
            ct.setMethods(methods);
            this.constraints.put(path[i], ct);
            this.contextM.addContainer(ct);
            ++i;
        }
    }

    public ServletWrapper addServlet(String name, String classN) throws TomcatException {
        ServletWrapper sw = new ServletWrapper();
        sw.setContext(this);
        sw.setServletName(name);
        if (classN.startsWith("/")) {
            sw.setPath(classN);
        } else {
            sw.setServletClass(classN);
        }
        this.addServlet(sw);
        return sw;
    }

    public void addServlet(ServletWrapper wrapper) throws TomcatException {
        wrapper.setContext(this);
        String name = wrapper.getServletName();
        if (this.servlets.get(name) != null) {
            this.log("Removing duplicate servlet " + name + " " + wrapper);
            this.removeServletByName(name);
        }
        this.servlets.put(name, wrapper);
    }

    public void addServletMapping(String path, String servletName) throws TomcatException {
        ServletWrapper sw;
        if (this.mappings.get(path) != null) {
            this.log("Removing duplicate " + path + " -> " + this.mappings.get(path));
            this.mappings.remove(path);
            Container ct = (Container)this.containers.get(path);
            this.removeContainer(ct);
        }
        if ((sw = (ServletWrapper)this.servlets.get(servletName)) == null) {
            this.log("Mapping with unregistered servlet " + servletName);
            sw = this.addServlet(servletName, servletName);
        }
        if ("/".equals(path)) {
            this.defaultServlet = sw;
        }
        this.mappings.put(path, sw);
        Container map = new Container();
        map.setContext(this);
        map.setHandler(sw);
        map.setPath(path);
        this.contextM.addContainer(map);
        this.containers.put(path, map);
    }

    public void addTaglib(String uri, String location) {
        this.tagLibs.put(uri, location);
    }

    public void addWelcomeFile(String s) {
        if (s == null) {
            return;
        }
        if ((s = s.trim()).length() == 0) {
            return;
        }
        if (this.expectUserWelcomeFiles) {
            this.removeWelcomeFiles();
            this.expectUserWelcomeFiles = false;
        }
        this.welcomeFiles.addElement(s);
    }

    public boolean allowAttribute(String name) {
        if (this.isTrusted()) {
            return true;
        }
        this.log("Illegal access to internal attribute ", null, 1);
        return false;
    }

    public void expectUserWelcomeFiles() {
        this.expectUserWelcomeFiles = true;
    }

    public String getAbsolutePath() {
        if (this.absPath != null) {
            return this.absPath;
        }
        this.absPath = FileUtil.isAbsolute(this.docBase) ? this.docBase : String.valueOf(this.contextM.getHome()) + File.separator + this.docBase;
        try {
            this.absPath = new File(this.absPath).getCanonicalPath();
        }
        catch (IOException iOException) {}
        return this.absPath;
    }

    public Object getAttribute(String name) {
        if (name.startsWith("org.apache.tomcat")) {
            if (name.equals("org.apache.tomcat.jsp_classpath")) {
                String cp = this.getServletLoader().getClassPath();
                return cp;
            }
            if (name.equals("org.apache.tomcat.protection_domain")) {
                return this.getProtectionDomain();
            }
            if (name.equals("org.apache.tomcat.classloader")) {
                return this.getServletLoader().getClassLoader();
            }
            if (name.equals("org.apache.tomcat.facade")) {
                if (!this.allowAttribute(name)) {
                    return null;
                }
                return this.getFacadeManager();
            }
            return null;
        }
        Object o = this.attributes.get(name);
        return this.attributes.get(name);
    }

    public Enumeration getAttributeNames() {
        return this.attributes.keys();
    }

    public String getAuthMethod() {
        return this.authMethod;
    }

    public Container getContainer() {
        return this.defaultContainer;
    }

    public Container getContainer(String path) {
        return (Container)this.containers.get(path);
    }

    public Enumeration getContainerLocations() {
        return this.containers.keys();
    }

    public Enumeration getContainers() {
        return this.containers.elements();
    }

    public Context getContext(String path) {
        if (!path.startsWith("/")) {
            return null;
        }
        if (!this.crossContext) {
            return null;
        }
        Request lr = this.contextM.createRequest(path);
        if (this.vhost != null) {
            lr.setServerName(this.vhost);
        }
        this.getContextManager().processRequest(lr);
        return lr.getContext();
    }

    public ContextInterceptor[] getContextInterceptors() {
        return this.getContainer().getContextInterceptors();
    }

    public ContextManager getContextManager() {
        return this.contextM;
    }

    public boolean getCrossContext() {
        return this.crossContext;
    }

    public int getDebug() {
        return this.debug;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDocBase() {
        return this.docBase;
    }

    public URL getDocumentBase() {
        block5: {
            if (this.documentBase != null) break block5;
            if (this.docBase == null) {
                return null;
            }
            try {
                String absPath = this.docBase;
                absPath = FileUtil.isAbsolute(this.docBase) ? this.docBase : String.valueOf(this.contextM.getHome()) + File.separator + this.docBase;
                try {
                    absPath = new File(absPath).getCanonicalPath();
                }
                catch (IOException iOException) {}
                this.documentBase = new URL("file", "", absPath);
            }
            catch (MalformedURLException ex) {
                ex.printStackTrace();
            }
        }
        return this.documentBase;
    }

    public String getEngineHeader() {
        return this.engineHeader;
    }

    public Enumeration getEnvEntries() {
        return this.envEntryTypes.keys();
    }

    public String getEnvEntryType(String name) {
        return (String)this.envEntryTypes.get(name);
    }

    public String getEnvEntryValue(String name) {
        return (String)this.envEntryValues.get(name);
    }

    public String getErrorPage(int errorCode) {
        return this.getErrorPage(String.valueOf(errorCode));
    }

    public String getErrorPage(String errorCode) {
        return (String)this.errorPages.get(errorCode);
    }

    public ServletContext getFacade() {
        if (this.contextFacade == null) {
            this.contextFacade = this.getFacadeManager().createServletContextFacade(this);
        }
        return this.contextFacade;
    }

    public FacadeManager getFacadeManager() {
        if (this.facadeM == null) {
            this.facadeM = new SimpleFacadeManager(this);
        }
        return this.facadeM;
    }

    public String getFormErrorPage() {
        return this.formErrorPage;
    }

    public String getFormLoginPage() {
        return this.formLoginPage;
    }

    public String getHost() {
        return this.vhost;
    }

    public Enumeration getHostAliases() {
        return this.vhostAliases.elements();
    }

    public String getInitParameter(String name) {
        return (String)this.initializationParameters.get(name);
    }

    public Enumeration getInitParameterNames() {
        return this.initializationParameters.keys();
    }

    public FileNameMap getMimeMap() {
        return this.mimeTypes;
    }

    public String getPath() {
        return this.path;
    }

    public Object getPermissions() {
        return this.perms;
    }

    public Object getProtectionDomain() {
        return this.protectionDomain;
    }

    public String getRealPath(String path) {
        String base = this.getAbsolutePath();
        if (path == null) {
            path = "";
        }
        String realPath = FileUtil.safePath(base, path);
        if (this.debug > 5) {
            this.log("Get real path " + path + " " + realPath + " " + base);
        }
        return realPath;
    }

    public String getRealPath(String path, Locale reqLocale, Locale fbLocale) {
        return this.getRealPath(path, reqLocale, fbLocale, "file");
    }

    public String getRealPath(String path, Locale reqLocale, Locale fbLocale, String locType) {
        String base = this.getAbsolutePath();
        if (path == null) {
            path = "";
        }
        String realPath = null;
        if ("file".equals(locType)) {
            realPath = FileUtil.getLocalizedFile(base, path, reqLocale, fbLocale);
        } else if ("docbase".equals(locType)) {
            realPath = FileUtil.getDocBaseLocalizedFile(base, path, reqLocale, fbLocale);
        }
        if (this.debug > 5) {
            this.log("Get real path " + path + " " + realPath + " " + base + reqLocale.toString() + " " + fbLocale.toString());
        }
        return realPath;
    }

    public String getRealmName() {
        return this.realmName;
    }

    public boolean getReloadable() {
        return this.reloadable;
    }

    public RequestInterceptor[] getRequestInterceptors() {
        return this.getContainer().getRequestInterceptors();
    }

    public URL getResource(String rpath) throws MalformedURLException {
        String realPath;
        if (rpath == null) {
            return null;
        }
        if (URLUtil.hasEscape(rpath)) {
            return null;
        }
        URL url = null;
        String absPath = this.getAbsolutePath();
        if ("".equals(rpath)) {
            return new URL("file", null, 0, absPath);
        }
        if (!rpath.startsWith("/")) {
            rpath = "/" + rpath;
        }
        if ((realPath = FileUtil.safePath(absPath, rpath)) == null) {
            this.log("Unsafe path " + absPath + " " + rpath);
            return null;
        }
        try {
            url = new URL("file", null, 0, realPath);
            if (this.debug > 9) {
                this.log("getResourceURL=" + url + " request=" + rpath);
            }
            return url;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public ServletWrapper getServletByName(String servletName) {
        return (ServletWrapper)this.servlets.get(servletName);
    }

    public ServletLoader getServletLoader() {
        return this.servletL;
    }

    public Enumeration getServletNames() {
        return this.servlets.keys();
    }

    public int getSessionTimeOut() {
        return this.sessionTimeOut;
    }

    public String getTaglibLocation(String uri) {
        return (String)this.tagLibs.get(uri);
    }

    public Enumeration getTaglibs() {
        return this.tagLibs.keys();
    }

    public File getWARDir() {
        return this.warDir;
    }

    public Enumeration getWelcomeFiles() {
        return this.welcomeFiles.elements();
    }

    public File getWorkDir() {
        return this.workDir;
    }

    public boolean isDistributable() {
        return this.isDistributable;
    }

    public boolean isInvokerEnabled() {
        return this.isInvokerEnabled;
    }

    public boolean isTrusted() {
        return this.trusted;
    }

    public boolean isWARExpanded() {
        return this.isWARExpanded;
    }

    public boolean isWARValidated() {
        return this.isWARValidated;
    }

    public boolean isWorkDirPersistent() {
        return this.isWorkDirPersistent;
    }

    public final void log(String msg) {
        this.loghelper.log(msg);
    }

    public void log(String msg, Throwable t) {
        this.loghelper.log(msg, t);
    }

    public void log(String msg, Throwable t, int level) {
        this.loghelper.log(msg, t, level);
    }

    public void logServlet(String msg, Throwable t) {
        msg = "path=\"" + this.path + "\" :" + msg;
        this.loghelperServlet.log(msg, t);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public void removeContainer(Container ct) {
        this.containers.remove(ct.getPath());
    }

    public void removeServletByName(String servletName) throws TomcatException {
        this.servlets.remove(servletName);
    }

    public void removeWelcomeFiles() {
        if (!this.welcomeFiles.isEmpty()) {
            this.welcomeFiles.removeAllElements();
        }
    }

    public void setAttribute(String name, Object object) {
        this.attributes.put(name, object);
    }

    public void setContextManager(ContextManager cm) {
        this.contextM = cm;
    }

    public void setCrossContext(boolean crossContext) {
        this.crossContext = crossContext;
    }

    public void setDebug(int level) {
        if (level > 0) {
            this.log("Set debug to " + level);
        }
        this.debug = level;
    }

    public void setDebug(String level) {
        try {
            this.setDebug(Integer.parseInt(level));
        }
        catch (Exception e) {
            this.log("Trying to set debug to '" + level + "':", e, 1);
        }
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDistributable(String s) {
    }

    public void setDistributable(boolean isDistributable) {
        this.isDistributable = isDistributable;
    }

    public void setDocBase(String docB) {
        this.docBase = docB;
    }

    public void setDocumentBase(URL s) {
        this.documentBase = s;
    }

    public void setEngineHeader(String s) {
        this.engineHeader = s;
    }

    public void setFormErrorPage(String page) {
        this.formErrorPage = page;
    }

    public void setFormLoginPage(String page) {
        this.formLoginPage = page;
    }

    public void setHost(String h) {
        this.vhost = h;
    }

    public void setIcon(String icon) {
    }

    public void setInitParameter(String name, String value) {
        this.initializationParameters.put(name, value);
    }

    public void setInvokerEnabled(boolean isInvokerEnabled) {
        this.isInvokerEnabled = isInvokerEnabled;
    }

    public void setIsWARExpanded(boolean isWARExpanded) {
        this.isWARExpanded = isWARExpanded;
    }

    public void setIsWARValidated(boolean isWARValidated) {
        this.isWARValidated = isWARValidated;
    }

    public void setLoginConfig(String authMethod, String realmName, String formLoginPage, String formErrorPage) {
        this.authMethod = authMethod;
        this.realmName = realmName;
        this.formLoginPage = formLoginPage;
        this.formErrorPage = formErrorPage;
    }

    public void setPath(String path) {
        if ("/".equals(path)) {
            path = "";
        }
        this.path = path;
    }

    public void setPermissions(Object o) {
        this.perms = o;
    }

    public void setProtectionDomain(Object o) {
        this.protectionDomain = o;
    }

    public void setReloadable(String s) {
        this.reloadable = new Boolean(s);
    }

    public void setReloadable(boolean b) {
        this.reloadable = b;
    }

    public void setServletLoader(ServletLoader loader) {
        this.servletL = loader;
    }

    public void setSessionTimeOut(int sessionTimeOut) {
        this.sessionTimeOut = sessionTimeOut;
    }

    public void setTrusted(boolean t) {
        this.trusted = t;
    }

    public void setWARDir(File f) {
        this.warDir = f;
    }

    public void setWorkDir(File workDir) {
        this.workDir = workDir;
    }

    public void setWorkDirPath(String workDir) {
        this.workDir = new File(workDir);
    }

    public void setWorkDirPersistent(boolean b) {
        this.isWorkDirPersistent = b;
    }

    public String toString() {
        return "Ctx( " + (this.vhost == null ? "" : String.valueOf(this.vhost) + ":") + this.path + " )";
    }
}

