/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.function;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.function.DocValues;
import org.apache.lucene.search.function.ValueSource;

public abstract class FieldCacheSource
extends ValueSource {
    private String field;
    private FieldCache cache = FieldCache.DEFAULT;

    public FieldCacheSource(String field) {
        this.field = field;
    }

    public final DocValues getValues(IndexReader reader) throws IOException {
        return this.getCachedFieldValues(this.cache, this.field, reader);
    }

    public String description() {
        return this.field;
    }

    public abstract DocValues getCachedFieldValues(FieldCache var1, String var2, IndexReader var3) throws IOException;

    public final boolean equals(Object o) {
        if (!(o instanceof FieldCacheSource)) {
            return false;
        }
        FieldCacheSource other = (FieldCacheSource)o;
        return this.cache == other.cache && this.field.equals(other.field) && this.cachedFieldSourceEquals(other);
    }

    public final int hashCode() {
        return this.cache.hashCode() + this.field.hashCode() + this.cachedFieldSourceHashCode();
    }

    public abstract boolean cachedFieldSourceEquals(FieldCacheSource var1);

    public abstract int cachedFieldSourceHashCode();
}

