/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.assembler.test;

import com.hp.hpl.jena.assembler.Assembler;
import com.hp.hpl.jena.assembler.JA;
import com.hp.hpl.jena.assembler.Mode;
import com.hp.hpl.jena.assembler.RuleSet;
import com.hp.hpl.jena.assembler.assemblers.AssemblerBase;
import com.hp.hpl.jena.assembler.assemblers.ReasonerFactoryAssembler;
import com.hp.hpl.jena.assembler.exceptions.CannotHaveRulesException;
import com.hp.hpl.jena.assembler.exceptions.CannotLoadClassException;
import com.hp.hpl.jena.assembler.exceptions.NotExpectedTypeException;
import com.hp.hpl.jena.assembler.exceptions.NotUniqueException;
import com.hp.hpl.jena.assembler.exceptions.UnknownReasonerException;
import com.hp.hpl.jena.assembler.test.AssemblerTestBase;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerFactory;
import com.hp.hpl.jena.reasoner.dig.DIGReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.DAMLMicroReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.GenericRuleReasoner;
import com.hp.hpl.jena.reasoner.rulesys.GenericRuleReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.OWLFBRuleReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.OWLMicroReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.OWLMiniReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.RDFSRuleReasonerFactory;
import com.hp.hpl.jena.reasoner.transitiveReasoner.TransitiveReasonerFactory;
import java.util.ArrayList;
import java.util.HashSet;
import junit.framework.Assert;

public class TestReasonerFactoryAssembler
extends AssemblerTestBase {
    private final Assembler ASSEMBLER = new ReasonerFactoryAssembler();

    public TestReasonerFactoryAssembler(String name) {
        super(name);
    }

    protected Class getAssemblerClass() {
        return ReasonerFactoryAssembler.class;
    }

    public void testReasonerFactoryAssemblerType() {
        this.testDemandsMinimalType((Assembler)new ReasonerFactoryAssembler(), JA.ReasonerFactory);
    }

    public void testCreateReasonerFactory() {
        Resource root = this.resourceInModel("x rdf:type ja:ReasonerFactory");
        TestReasonerFactoryAssembler.assertInstanceOf(GenericRuleReasonerFactory.class, this.ASSEMBLER.open(root));
    }

    public void testStandardReasonerURLs() {
        this.testReasonerURL(GenericRuleReasonerFactory.class, "http://jena.hpl.hp.com/2003/GenericRuleReasoner");
        this.testReasonerURL(TransitiveReasonerFactory.class, "http://jena.hpl.hp.com/2003/TransitiveReasoner");
        this.testReasonerURL(RDFSRuleReasonerFactory.class, "http://jena.hpl.hp.com/2003/RDFSExptRuleReasoner");
        this.testReasonerURL(OWLFBRuleReasonerFactory.class, "http://jena.hpl.hp.com/2003/OWLFBRuleReasoner");
        this.testReasonerURL(DAMLMicroReasonerFactory.class, "http://jena.hpl.hp.com/2003/DAMLMicroReasonerFactory");
        this.testReasonerURL(DIGReasonerFactory.class, "http://jena.hpl.hp.com/2003/DIGReasoner");
        this.testReasonerURL(OWLMicroReasonerFactory.class, "http://jena.hpl.hp.com/2003/OWLMicroFBRuleReasoner");
        this.testReasonerURL(OWLMiniReasonerFactory.class, "http://jena.hpl.hp.com/2003/OWLMiniFBRuleReasoner");
    }

    public void testBadReasonerURLFails() {
        Resource root = this.resourceInModel("x rdf:type ja:ReasonerFactory; x ja:reasonerURL bad:URL");
        try {
            this.ASSEMBLER.open(root);
            TestReasonerFactoryAssembler.fail((String)"should detected unknown reasoner");
        }
        catch (UnknownReasonerException e) {
            TestReasonerFactoryAssembler.assertEquals((Object)TestReasonerFactoryAssembler.resource("bad:URL"), (Object)e.getURL());
        }
    }

    public void testReasonerClassThrowsIfClassNotFound() {
        String description = "x rdf:type ja:ReasonerFactory; x ja:reasonerClass java:noSuchClass";
        Resource root = this.resourceInModel(description);
        try {
            this.ASSEMBLER.open(root);
            TestReasonerFactoryAssembler.fail((String)"should trap missing class noSuchClass");
        }
        catch (CannotLoadClassException e) {
            TestReasonerFactoryAssembler.assertEquals((String)"noSuchClass", (String)e.getClassName());
        }
    }

    public void testReasonerClassThrowsIfClassNotFactory() {
        String description = "x rdf:type ja:ReasonerFactory; x ja:reasonerClass java:java.util.ArrayList";
        Resource root = this.resourceInModel(description);
        try {
            this.ASSEMBLER.open(root);
            TestReasonerFactoryAssembler.fail((String)"should trap non-ReasonerFactory ArrayList");
        }
        catch (NotExpectedTypeException e) {
            TestReasonerFactoryAssembler.assertEquals((Object)root, (Object)e.getRoot());
            TestReasonerFactoryAssembler.assertEquals((Object)ReasonerFactory.class, (Object)e.getExpectedType());
            TestReasonerFactoryAssembler.assertEquals((Object)ArrayList.class, (Object)e.getActualType());
        }
    }

    public void testReasonerClassUsesTheInstance() {
        String description = "x rdf:type ja:ReasonerFactory; x ja:reasonerClass java:";
        String MockName = MockFactory.class.getName();
        Resource root = this.resourceInModel(description + MockName);
        TestReasonerFactoryAssembler.assertEquals((Object)MockFactory.instance, (Object)this.ASSEMBLER.open(root));
    }

    public void testReasonerClassInstantiatesIfNoInstance() {
        String description = "x rdf:type ja:ReasonerFactory; x ja:reasonerClass java:";
        String MockName = MockBase.class.getName();
        Resource root = this.resourceInModel(description + MockName);
        TestReasonerFactoryAssembler.assertInstanceOf(MockBase.class, this.ASSEMBLER.open(root));
        TestReasonerFactoryAssembler.assertNotSame((Object)MockFactory.instance, (Object)this.ASSEMBLER.open(root));
    }

    public void testMultipleURLsFails() {
        Resource root = this.resourceInModel("x rdf:type ja:ReasonerFactory; x ja:reasonerURL bad:URL; x ja:reasonerURL another:bad/URL");
        try {
            this.ASSEMBLER.open(root);
            TestReasonerFactoryAssembler.fail((String)"should detected multiple reasoner URLs");
        }
        catch (NotUniqueException e) {
            TestReasonerFactoryAssembler.assertEquals((Object)JA.reasonerURL, (Object)e.getProperty());
            TestReasonerFactoryAssembler.assertEquals((Object)root, (Object)e.getRoot());
        }
    }

    public void testOnlyGenericReasonerCanHaveRules() {
        String url = "http://jena.hpl.hp.com/2003/TransitiveReasoner";
        Resource root = this.resourceInModel("x rdf:type ja:ReasonerFactory; x ja:rule '[->(a\\sP\\sb)]'; x ja:reasonerURL " + url);
        String ruleStringA = "[rdfs2:  (?x ?p ?y), (?p rdfs:domain ?c) -> (?x rdf:type ?c)]";
        RuleSet rules = RuleSet.create((String)ruleStringA);
        try {
            this.ASSEMBLER.open((Assembler)new AssemblerTestBase.FixedObjectAssembler(rules), root);
            TestReasonerFactoryAssembler.fail((String)"only GenericRuleReasoners can have attached rules");
        }
        catch (CannotHaveRulesException e) {
            // empty catch block
        }
    }

    public void testSchema() {
    }

    public void testSingleRules() {
        Resource root = this.resourceInModel("x rdf:type ja:ReasonerFactory; x ja:rules S");
        String ruleStringA = "[rdfs2:  (?x ?p ?y), (?p rdfs:domain ?c) -> (?x rdf:type ?c)]";
        final RuleSet rules = RuleSet.create((String)ruleStringA);
        AssemblerBase mock = new AssemblerBase(){

            public Object open(Assembler a, Resource root, Mode irrelevant) {
                Assert.assertEquals((Object)root, (Object)ModelTestBase.resource("S"));
                return rules;
            }
        };
        ReasonerFactory r = (ReasonerFactory)this.ASSEMBLER.open((Assembler)mock, root);
        GenericRuleReasoner grr = (GenericRuleReasoner)r.create(null);
        TestReasonerFactoryAssembler.assertEquals(new HashSet(rules.getRules()), new HashSet(grr.getRules()));
    }

    public void testMultipleRules() {
        Resource root = this.resourceInModel("x rdf:type ja:ReasonerFactory; x ja:rules S; x ja:rules T");
        String ruleStringA = "[rdfs2:  (?x ?p ?y), (?p rdfs:domain ?c) -> (?x rdf:type ?c)]";
        String ruleStringB = "[rdfs9:  (?x rdfs:subClassOf ?y), (?a rdf:type ?x) -> (?a rdf:type ?y)]";
        final RuleSet rulesA = RuleSet.create((String)ruleStringA);
        final RuleSet rulesB = RuleSet.create((String)ruleStringB);
        AssemblerBase mock = new AssemblerBase(){

            public Object open(Assembler a, Resource root, Mode irrelevant) {
                if (root.equals(ModelTestBase.resource("S"))) {
                    return rulesA;
                }
                if (root.equals(ModelTestBase.resource("T"))) {
                    return rulesB;
                }
                throw new RuntimeException("unknown resource in mock: " + root);
            }
        };
        ReasonerFactory r = (ReasonerFactory)this.ASSEMBLER.open((Assembler)mock, root);
        GenericRuleReasoner grr = (GenericRuleReasoner)r.create(null);
        HashSet wanted = new HashSet();
        wanted.addAll(rulesA.getRules());
        wanted.addAll(rulesB.getRules());
        TestReasonerFactoryAssembler.assertEquals(wanted, new HashSet(grr.getRules()));
    }

    protected void testReasonerURL(Class wanted, String string) {
        Resource root = this.resourceInModel("x rdf:type ja:ReasonerFactory; x ja:reasonerURL " + string);
        ReasonerFactory rf = (ReasonerFactory)this.ASSEMBLER.open(root);
        TestReasonerFactoryAssembler.assertInstanceOf(wanted, rf);
    }

    public static class MockFactory
    extends MockBase
    implements ReasonerFactory {
        public static final MockFactory instance = new MockFactory();

        public static ReasonerFactory theInstance() {
            return instance;
        }
    }

    public static class MockBase
    implements ReasonerFactory {
        public Reasoner create(Resource configuration) {
            return null;
        }

        public Model getCapabilities() {
            return null;
        }

        public String getURI() {
            return null;
        }
    }
}

