/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.assembler.test;

import com.hp.hpl.jena.assembler.Assembler;
import com.hp.hpl.jena.assembler.JA;
import com.hp.hpl.jena.assembler.Mode;
import com.hp.hpl.jena.assembler.assemblers.ContentAssembler;
import com.hp.hpl.jena.assembler.assemblers.ModelAssembler;
import com.hp.hpl.jena.assembler.exceptions.UnknownStyleException;
import com.hp.hpl.jena.assembler.test.AssemblerTestBase;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.ReificationStyle;
import java.util.ArrayList;

public class TestModelAssembler
extends AssemblerTestBase {
    public TestModelAssembler(String name) {
        super(name);
    }

    protected Class getAssemblerClass() {
        return null;
    }

    public void testModelAssemblerVocabulary() {
        this.assertDomain(JA.Model, JA.reificationMode);
        this.assertRange(JA.ReificationMode, JA.reificationMode);
        this.assertType(JA.ReificationMode, JA.minimal);
        this.assertType(JA.ReificationMode, JA.standard);
        this.assertType(JA.ReificationMode, JA.convenient);
    }

    public void testContent() {
        Resource root = this.resourceInModel("x rdf:type ja:DefaultModel; x ja:initialContent c; c ja:quotedContent A; A P B");
        Model m = (Model)new FakeModelAssembler().open((Assembler)new ContentAssembler(), root, Mode.ANY);
        TestModelAssembler.assertIsoModels(TestModelAssembler.modelWithStatements("A P B"), m);
    }

    public void testGetsPrefixMappings() {
        FakeModelAssembler a = new FakeModelAssembler();
        PrefixMapping wanted = PrefixMapping.Factory.create().setNsPrefix("my", "urn:secret:42/").setNsPrefix("your", "urn:public:17#");
        Resource root = this.resourceInModel("x rdf:type ja:DefaultModel; x ja:includes p1; x ja:includes p2; p1 rdf:type ja:PrefixMapping; p1 ja:prefix 'my'; p1 ja:namespace 'urn:secret:42/'; p2 rdf:type ja:PrefixMapping; p2 ja:prefix 'your'; p2 ja:namespace 'urn:public:17#'");
        Model m = (Model)a.open(Assembler.prefixMapping, root);
        this.assertSamePrefixMapping(wanted, (PrefixMapping)m);
    }

    public void testGetsStandardReificationMode() {
        final ArrayList style = new ArrayList();
        ModelAssembler a = new ModelAssembler(){

            protected Model openEmptyModel(Assembler a, Resource root, Mode irrelevant) {
                style.add(1.getReificationStyle((Resource)root));
                return ModelFactory.createDefaultModel();
            }
        };
        Model m = a.openModel(this.resourceInModel("a rdf:type ja:Model"));
        TestModelAssembler.assertEquals((Object)TestModelAssembler.listOfOne(ReificationStyle.Standard), style);
    }

    public void testGetsExplicitReificationMode() {
        this.testGetsStyle("ja:minimal", ReificationStyle.Minimal);
        this.testGetsStyle("ja:standard", ReificationStyle.Standard);
        this.testGetsStyle("ja:convenient", ReificationStyle.Convenient);
    }

    public void testUnknownStyleFails() {
        try {
            this.testGetsStyle("unknown", ReificationStyle.Standard);
            TestModelAssembler.fail((String)"should trap unknown reification style");
        }
        catch (UnknownStyleException e) {
            TestModelAssembler.assertEquals((Object)TestModelAssembler.resource("unknown"), (Object)e.getStyle());
            TestModelAssembler.assertEquals((Object)TestModelAssembler.resource("a"), (Object)e.getRoot());
        }
    }

    private void testGetsStyle(String styleString, ReificationStyle style) {
        final ArrayList styles = new ArrayList();
        ModelAssembler a = new ModelAssembler(){

            protected Model openEmptyModel(Assembler a, Resource root, Mode irrelevant) {
                styles.add(2.getReificationStyle((Resource)root));
                return ModelFactory.createDefaultModel();
            }
        };
        Model m = a.openModel(this.resourceInModel("a rdf:type ja:Model; a ja:reificationMode " + styleString));
        TestModelAssembler.assertEquals((Object)TestModelAssembler.listOfOne(style), styles);
    }

    protected static final class FakeModelAssembler
    extends ModelAssembler {
        protected FakeModelAssembler() {
        }

        protected Model openEmptyModel(Assembler a, Resource root, Mode mode) {
            return ModelFactory.createDefaultModel();
        }
    }
}

