/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.sse.builders;

import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.core.DataSourceGraphImpl;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.sse.Item;
import com.hp.hpl.jena.sparql.sse.ItemList;
import com.hp.hpl.jena.sparql.sse.ItemLocation;
import com.hp.hpl.jena.sparql.sse.builders.BuilderBase;
import com.hp.hpl.jena.sparql.sse.builders.BuilderNode;
import com.hp.hpl.jena.sparql.util.GraphUtils;
import com.hp.hpl.jena.sparql.util.NodeUtils;
import com.hp.hpl.jena.util.FileManager;
import java.util.Iterator;

public class BuilderGraph {
    public static Graph buildGraph(Item item) {
        if (item.isNode()) {
            BuilderBase.broken(item, "Attempt to build graph from a plain node");
        }
        if (item.isSymbol()) {
            BuilderBase.broken(item, "Attempt to build graph from a bare symbol");
        }
        if (item.isTagged("graph")) {
            return BuilderGraph.buildGraph(item.getList());
        }
        if (item.isTagged("graph@")) {
            return BuilderGraph.loadGraph(item.getList());
        }
        BuilderBase.broken(item, "Wanted (graph...) or (graph@...)");
        return null;
    }

    public static Graph buildGraph(ItemList list) {
        BuilderBase.checkTag(list, "graph");
        list = list.cdr();
        Graph graph = Factory.createDefaultGraph();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Item item = (Item)iter.next();
            BuilderBase.checkList(item);
            Triple triple = BuilderGraph.buildTriple(item.getList());
            graph.add(triple);
        }
        return graph;
    }

    public static DatasetGraph buildDataset(Item item) {
        if (item.isNode()) {
            BuilderBase.broken(item, "Attempt to build dataset from a plain node");
        }
        if (item.isSymbol()) {
            BuilderBase.broken(item, "Attempt to build dataset from a bare symbol");
        }
        if (item.isTagged("graph")) {
            Graph g = BuilderGraph.buildGraph(item.getList());
            DataSourceGraphImpl ds = new DataSourceGraphImpl(g);
            return ds;
        }
        if (!item.isTagged("dataset")) {
            BuilderBase.broken(item, "Wanted (dataset...)");
        }
        return BuilderGraph.buildDataset(item.getList());
    }

    public static DatasetGraph buildDataset(ItemList list) {
        BuilderBase.checkTag(list, "dataset");
        list = list.cdr();
        DataSourceGraphImpl ds = new DataSourceGraphImpl((Graph)null);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Item item = (Item)iter.next();
            if (item.isTagged("default")) {
                if (ds.getDefaultGraph() != null) {
                    BuilderBase.broken(item, "Multiple default graphs");
                }
                BuilderBase.checkLength(2, item.getList(), "Expected (default (graph...))");
                Graph g = BuilderGraph.buildGraph(item.getList().get(1));
                ds.setDefaultGraph(g);
                continue;
            }
            if (item.isTagged("namedgraph")) {
                ItemList ngList = item.getList();
                BuilderBase.checkLength(3, ngList, "Expected (namedgraph IRI (graph...))");
                Node n = BuilderNode.buildNode(ngList.get(1));
                Graph g = BuilderGraph.buildGraph(item.getList().get(2));
                ds.addGraph(n, g);
                continue;
            }
            BuilderBase.broken(item, "Not expected in dataset");
        }
        if (ds.getDefaultGraph() == null) {
            ds.setDefaultGraph(GraphUtils.makeDefaultGraph());
        }
        return ds;
    }

    private static Graph loadGraph(ItemList list) {
        String s;
        BuilderBase.checkLength(2, list, "graph@");
        Item item = list.get(1);
        if (!item.isNode()) {
            BuilderBase.broken(item, "Expected: (graph@ 'filename')");
        }
        if ((s = NodeUtils.stringLiteral(item.getNode())) == null) {
            BuilderBase.broken(item, "Expected: (graph@ 'filename')");
        }
        return FileManager.get().loadModel(s).getGraph();
    }

    public static Triple buildTriple(ItemList list) {
        if (list.size() != 3 && list.size() != 4) {
            BuilderBase.broken((ItemLocation)list, "Not a triple", list);
        }
        if (list.size() == 4) {
            if (!list.get(0).isSymbol("triple")) {
                BuilderBase.broken(list, "Not a triple");
            }
            list = list.cdr();
        }
        return BuilderGraph._buildNode3(list);
    }

    public static Triple buildNode3(ItemList list) {
        BuilderBase.checkLength(3, list, null);
        return BuilderGraph._buildNode3(list);
    }

    private static Triple _buildNode3(ItemList list) {
        Node s = BuilderNode.buildNode(list.get(0));
        Node p = BuilderNode.buildNode(list.get(1));
        Node o = BuilderNode.buildNode(list.get(2));
        return new Triple(s, p, o);
    }

    public static Quad buildQuad(ItemList list) {
        if (list.size() != 4 && list.size() != 5) {
            BuilderBase.broken(list, "Not a quad");
        }
        if (list.size() == 5) {
            if (!list.get(0).isSymbol("quad")) {
                BuilderBase.broken(list, "Not a quad");
            }
            list = list.cdr();
        }
        return BuilderGraph._buildNode4(list);
    }

    public static Quad buildNode4(ItemList list) {
        BuilderBase.checkLength(4, list, null);
        return BuilderGraph._buildNode4(list);
    }

    private static Quad _buildNode4(ItemList list) {
        Node g = null;
        g = list.get(0).equals(Item.defaultItem) ? Quad.defaultGraphNode : BuilderNode.buildNode(list.get(0));
        Node s = BuilderNode.buildNode(list.get(1));
        Node p = BuilderNode.buildNode(list.get(2));
        Node o = BuilderNode.buildNode(list.get(3));
        return new Quad(g, s, p, o);
    }
}

