/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.support;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.orm.jpa.persistenceunit.MutablePersistenceUnitInfo;
import org.springframework.orm.jpa.persistenceunit.PersistenceUnitPostProcessor;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ClasspathScanningPersistenceUnitPostProcessor
implements PersistenceUnitPostProcessor,
ResourceLoaderAware {
    private static final Logger LOG = LoggerFactory.getLogger(ClasspathScanningPersistenceUnitPostProcessor.class);
    private final String basePackage;
    private ResourcePatternResolver resolver = new PathMatchingResourcePatternResolver(this.getClass().getClassLoader());
    private String mappingFileNamePattern;

    public ClasspathScanningPersistenceUnitPostProcessor(String basePackage) {
        Assert.hasText((String)basePackage);
        this.basePackage = basePackage;
    }

    public void setMappingFileNamePattern(String mappingFilePattern) {
        Assert.hasText((String)mappingFilePattern);
        this.mappingFileNamePattern = mappingFilePattern;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        Assert.notNull((Object)resourceLoader);
        this.resolver = new PathMatchingResourcePatternResolver(resourceLoader);
    }

    public void postProcessPersistenceUnitInfo(MutablePersistenceUnitInfo pui) {
        ClassPathScanningCandidateComponentProvider provider = new ClassPathScanningCandidateComponentProvider(false);
        provider.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(Entity.class));
        provider.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(MappedSuperclass.class));
        for (BeanDefinition definition : provider.findCandidateComponents(this.basePackage)) {
            LOG.debug("Registering classpath-scanned entity %s in persistence unit info!", (Object)definition.getBeanClassName());
            pui.addManagedClassName(definition.getBeanClassName());
        }
        for (String location : this.scanForMappingFileLocations()) {
            LOG.debug("Registering classpath-scanned entity mapping file in persistence unit info!", (Object)location);
            pui.addMappingFileName(location);
        }
    }

    private Set<String> scanForMappingFileLocations() {
        if (this.resolver == null || !StringUtils.hasText((String)this.mappingFileNamePattern)) {
            return Collections.emptySet();
        }
        char slash = '/';
        String basePackagePathComponent = this.basePackage.replace('.', slash);
        String path = "classpath*:" + basePackagePathComponent + slash + this.mappingFileNamePattern;
        HashSet<String> mappingFileUris = new HashSet<String>();
        Resource[] scannedResources = new Resource[]{};
        try {
            scannedResources = this.resolver.getResources(path);
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Cannot load mapping files from path %s!", path), e);
        }
        for (Resource resource : scannedResources) {
            try {
                String resourcePath = resource.getURI().getPath();
                String resourcePathInClasspath = resourcePath.substring(resourcePath.indexOf(basePackagePathComponent));
                mappingFileUris.add(resourcePathInClasspath);
            }
            catch (IOException e) {
                throw new IllegalStateException(String.format("Couldn't get URI for %s!", resource.toString()), e);
            }
        }
        return mappingFileUris;
    }
}

