/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping.model;

import java.io.Serializable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.springframework.data.annotation.TypeAlias;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.AssociationHandler;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PreferredConstructor;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.data.mapping.model.MutablePersistentEntity;
import org.springframework.data.mapping.model.PreferredConstructorDiscoverer;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class BasicPersistentEntity<T, P extends PersistentProperty<P>>
implements MutablePersistentEntity<T, P> {
    private final PreferredConstructor<T, P> constructor;
    private final TypeInformation<T> information;
    private final Set<P> properties;
    private final Set<Association<P>> associations;
    private final Map<String, P> propertyCache = new HashMap<String, P>();
    private P idProperty;
    private P versionProperty;

    public BasicPersistentEntity(TypeInformation<T> information) {
        this(information, null);
    }

    public BasicPersistentEntity(TypeInformation<T> information, Comparator<P> comparator) {
        Assert.notNull(information);
        this.information = information;
        this.properties = comparator == null ? new HashSet() : new TreeSet<P>(comparator);
        this.constructor = new PreferredConstructorDiscoverer(information, this).getConstructor();
        this.associations = comparator == null ? new HashSet() : new TreeSet<P>(new AssociationComparator<P>(comparator));
    }

    @Override
    public PreferredConstructor<T, P> getPersistenceConstructor() {
        return this.constructor;
    }

    @Override
    public boolean isConstructorArgument(PersistentProperty<?> property) {
        return this.constructor == null ? false : this.constructor.isConstructorParameter(property);
    }

    @Override
    public boolean isIdProperty(PersistentProperty<?> property) {
        return this.idProperty == null ? false : this.idProperty.equals(property);
    }

    @Override
    public boolean isVersionProperty(PersistentProperty<?> property) {
        return this.versionProperty == null ? false : this.versionProperty.equals(property);
    }

    @Override
    public String getName() {
        return this.getType().getName();
    }

    @Override
    public P getIdProperty() {
        return this.idProperty;
    }

    @Override
    public P getVersionProperty() {
        return this.versionProperty;
    }

    @Override
    public boolean hasIdProperty() {
        return this.idProperty != null;
    }

    @Override
    public boolean hasVersionProperty() {
        return this.versionProperty != null;
    }

    @Override
    public void addPersistentProperty(P property) {
        P idProperty;
        Assert.notNull(property);
        this.properties.add(property);
        if (!this.propertyCache.containsKey(property.getName())) {
            this.propertyCache.put(property.getName(), property);
        }
        if ((idProperty = this.returnPropertyIfBetterIdPropertyCandidateOrNull(property)) != null) {
            this.idProperty = idProperty;
        }
        if (property.isVersionProperty()) {
            if (this.versionProperty != null) {
                throw new MappingException(String.format("Attempt to add version property %s but already have property %s registered as version. Check your mapping configuration!", property.getField(), this.versionProperty.getField()));
            }
            this.versionProperty = property;
        }
    }

    protected P returnPropertyIfBetterIdPropertyCandidateOrNull(P property) {
        if (!property.isIdProperty()) {
            return null;
        }
        if (this.idProperty != null) {
            throw new MappingException(String.format("Attempt to add id property %s but already have property %s registered as id. Check your mapping configuration!", property.getField(), this.idProperty.getField()));
        }
        return property;
    }

    @Override
    public void addAssociation(Association<P> association) {
        this.associations.add(association);
    }

    @Override
    public P getPersistentProperty(String name) {
        return (P)((PersistentProperty)this.propertyCache.get(name));
    }

    @Override
    public Class<T> getType() {
        return this.information.getType();
    }

    @Override
    public Object getTypeAlias() {
        TypeAlias alias = this.getType().getAnnotation(TypeAlias.class);
        return alias == null ? null : (StringUtils.hasText((String)alias.value()) ? alias.value() : null);
    }

    @Override
    public TypeInformation<T> getTypeInformation() {
        return this.information;
    }

    @Override
    public void doWithProperties(PropertyHandler<P> handler) {
        Assert.notNull(handler);
        for (PersistentProperty property : this.properties) {
            if (property.isTransient() || property.isAssociation()) continue;
            handler.doWithPersistentProperty(property);
        }
    }

    @Override
    public void doWithAssociations(AssociationHandler<P> handler) {
        Assert.notNull(handler);
        for (Association<P> association : this.associations) {
            handler.doWithAssociation(association);
        }
    }

    @Override
    public void verify() {
    }

    private static final class AssociationComparator<P extends PersistentProperty<P>>
    implements Comparator<Association<P>>,
    Serializable {
        private static final long serialVersionUID = 4508054194886854513L;
        private final Comparator<P> delegate;

        public AssociationComparator(Comparator<P> delegate) {
            Assert.notNull(delegate);
            this.delegate = delegate;
        }

        @Override
        public int compare(Association<P> left, Association<P> right) {
            return this.delegate.compare(left.getInverse(), right.getInverse());
        }
    }
}

