/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.util;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.springframework.core.GenericTypeResolver;
import org.springframework.data.util.TypeDiscoverer;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class ClassTypeInformation<S>
extends TypeDiscoverer<S> {
    public static final TypeInformation<Collection> COLLECTION = new ClassTypeInformation<Collection>(Collection.class);
    public static final TypeInformation<List> LIST = new ClassTypeInformation<List>(List.class);
    public static final TypeInformation<Set> SET = new ClassTypeInformation<Set>(Set.class);
    public static final TypeInformation<Map> MAP = new ClassTypeInformation<Map>(Map.class);
    public static final TypeInformation<Object> OBJECT = new ClassTypeInformation<Object>(Object.class);
    private static final Map<Class<?>, Reference<TypeInformation<?>>> CACHE = Collections.synchronizedMap(new WeakHashMap());
    private final Class<S> type;

    public static <S> TypeInformation<S> from(Class<S> type) {
        TypeInformation<?> cachedTypeInfo;
        Assert.notNull(type, (String)"Type must not be null!");
        Reference<TypeInformation<?>> cachedReference = CACHE.get(type);
        TypeInformation<?> typeInformation = cachedTypeInfo = cachedReference == null ? null : cachedReference.get();
        if (cachedTypeInfo != null) {
            return cachedTypeInfo;
        }
        ClassTypeInformation<S> result = new ClassTypeInformation<S>(type);
        CACHE.put(type, new WeakReference<ClassTypeInformation<S>>(result));
        return result;
    }

    public static <S> TypeInformation<S> fromReturnTypeOf(Method method) {
        Assert.notNull((Object)method, (String)"Method must not be null!");
        return new ClassTypeInformation(method.getDeclaringClass()).createInfo(method.getGenericReturnType());
    }

    ClassTypeInformation(Class<S> type) {
        this(type, (Map<TypeVariable, Type>)GenericTypeResolver.getTypeVariableMap(type));
    }

    ClassTypeInformation(Class<S> type, Map<TypeVariable, Type> typeVariableMap) {
        super(ClassUtils.getUserClass(type), typeVariableMap);
        this.type = type;
    }

    @Override
    public Class<S> getType() {
        return this.type;
    }

    @Override
    public boolean isAssignableFrom(TypeInformation<?> target) {
        return this.getType().isAssignableFrom(target.getType());
    }

    static {
        for (TypeInformation info : Arrays.asList(COLLECTION, LIST, SET, MAP, OBJECT)) {
            CACHE.put(info.getType(), new WeakReference<TypeInformation>(info));
        }
    }
}

