/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util.test;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.shared.NotFoundException;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.util.LocationMapper;
import java.io.InputStream;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TestFileManager
extends TestCase {
    static Log log = LogFactory.getLog((Class)TestFileManager.class);
    static final String testingDir = "testing/FileManager";
    static final String filename = "fmgr-test-file";
    static final String filenameNonExistent = "fmgr-test-file-1421";
    static final String fileModel = "foo.n3";
    static final String zipname = "testing/FileManager/fmgr-test.zip";

    public TestFileManager(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestFileManager.class);
    }

    public void testFileManagerFileLocator() {
        FileManager fileManager = new FileManager();
        fileManager.addLocatorFile();
        InputStream in = fileManager.open("testing/FileManager/fmgr-test-file");
        TestFileManager.assertNotNull((Object)in);
        this.closeInputStream(in);
    }

    public void testFileManagerFileLocatorWithDir() {
        FileManager fileManager = new FileManager();
        fileManager.addLocatorFile(testingDir);
        InputStream in = fileManager.open(filename);
        TestFileManager.assertNotNull((Object)in);
        this.closeInputStream(in);
    }

    public void testFileManagerNoFile() {
        FileManager fileManager = new FileManager();
        fileManager.addLocatorFile();
        try {
            InputStream in = fileManager.open(filenameNonExistent);
            this.closeInputStream(in);
            TestFileManager.assertNull((String)"Found non-existant file: fmgr-test-file-1421", (Object)in);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    public void testFileManagerLocatorClassLoader() {
        FileManager fileManager = new FileManager();
        fileManager.addLocatorClassLoader(fileManager.getClass().getClassLoader());
        InputStream in = fileManager.open("java/lang/String.class");
        TestFileManager.assertNotNull((Object)in);
        this.closeInputStream(in);
    }

    public void testFileManagerLocatorClassLoaderNotFound() {
        FileManager fileManager = new FileManager();
        fileManager.addLocatorClassLoader(fileManager.getClass().getClassLoader());
        try {
            InputStream in = fileManager.open("not/java/lang/String.class");
            this.closeInputStream(in);
            TestFileManager.assertNull((String)"Found non-existant class", (Object)in);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    public void testFileManagerLocatorZip() {
        FileManager fileManager = new FileManager();
        try {
            fileManager.addLocatorZip(zipname);
        }
        catch (Exception ex) {
            TestFileManager.fail((String)"Failed to create a filemanager and add a zip locator");
        }
        InputStream in = fileManager.open(filename);
        TestFileManager.assertNotNull((Object)in);
        this.closeInputStream(in);
    }

    public void testFileManagerLocatorZipNonFound() {
        FileManager fileManager = new FileManager();
        try {
            fileManager.addLocatorZip(zipname);
        }
        catch (Exception ex) {
            TestFileManager.fail((String)"Failed to create a filemanager and add a zip locator");
        }
        try {
            InputStream in = fileManager.open(filenameNonExistent);
            this.closeInputStream(in);
            TestFileManager.assertNull((String)"Found non-existant zip file member", (Object)in);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    public void testFileManagerClone() {
        FileManager fileManager1 = new FileManager();
        FileManager fileManager2 = new FileManager(fileManager1);
        fileManager1.addLocatorFile();
        InputStream in = fileManager1.open("testing/FileManager/fmgr-test-file");
        TestFileManager.assertNotNull((Object)in);
        this.closeInputStream(in);
        try {
            in = fileManager2.open("testing/FileManager/fmgr-test-file");
            this.closeInputStream(in);
            TestFileManager.assertNull((String)"Found file via wrong FileManager", (Object)in);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    public void testLocationMappingURLtoFileOpen() {
        LocationMapper locMap = new LocationMapper("location-mapping-test.n3;testing/FileManager/location-mapping-test.n3");
        FileManager fileManager = new FileManager(locMap);
        fileManager.addLocatorFile();
        InputStream in = fileManager.open("http://example.org/file");
        TestFileManager.assertNotNull((Object)in);
        this.closeInputStream(in);
    }

    public void testLocationMappingURLtoFileOpenNotFound() {
        LocationMapper locMap = new LocationMapper("location-mapping-test.n3;testing/FileManager/location-mapping-test.n3");
        FileManager fileManager = new FileManager(locMap);
        fileManager.addLocatorClassLoader(fileManager.getClass().getClassLoader());
        try {
            InputStream in = fileManager.open("http://example.org/file");
            this.closeInputStream(in);
            TestFileManager.assertNull((String)"Found nont-existant URL", null);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    public void testCache1() {
        FileManager fileManager = new FileManager();
        fileManager.addLocatorFile(testingDir);
        Model m1 = fileManager.loadModel(fileModel);
        Model m2 = fileManager.loadModel(fileModel);
        TestFileManager.assertNotSame((Object)m1, (Object)m2);
    }

    public void testCache2() {
        FileManager fileManager = FileManager.get();
        fileManager.addLocatorFile(testingDir);
        fileManager.setModelCaching(true);
        Model m1 = fileManager.loadModel(fileModel);
        Model m2 = fileManager.loadModel(fileModel);
        TestFileManager.assertSame((Object)m1, (Object)m2);
    }

    public void testCache3() {
        FileManager fileManager = FileManager.get();
        fileManager.addLocatorFile(testingDir);
        fileManager.setModelCaching(true);
        Model m1 = fileManager.loadModel(fileModel);
        Model m2 = fileManager.loadModel(fileModel);
        TestFileManager.assertSame((Object)m1, (Object)m2);
        fileManager.removeCacheModel(fileModel);
        Model m3 = fileManager.loadModel(fileModel);
        TestFileManager.assertNotSame((Object)m1, (Object)m3);
        fileManager.resetCache();
        Model m4 = fileManager.loadModel(fileModel);
        Model m5 = fileManager.loadModel(fileModel);
        TestFileManager.assertSame((Object)m4, (Object)m5);
        TestFileManager.assertNotSame((Object)m1, (Object)m4);
        TestFileManager.assertNotSame((Object)m3, (Object)m4);
    }

    private void closeInputStream(InputStream in) {
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

