/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.impl;

import com.hp.hpl.jena.graph.GraphAdd;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.impl.FragmentTripleIterator;
import com.hp.hpl.jena.graph.impl.GraphAddList;
import com.hp.hpl.jena.graph.impl.ReifierFragmentHandler;
import com.hp.hpl.jena.graph.impl.ReifierFragmentsMap;
import com.hp.hpl.jena.graph.impl.SimpleReifierFragmentHandler;
import com.hp.hpl.jena.util.CollectionFactory;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.NullIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class SimpleReifierFragmentsMap
implements ReifierFragmentsMap {
    protected Map forwardMap = CollectionFactory.createHashedMap();
    protected static final int TYPES_index = 0;
    protected static final int SUBJECTS_index = 1;
    protected static final int PREDICATES_index = 2;
    protected static final int OBJECTS_index = 3;
    protected final ReifierFragmentHandler TYPES = new SimpleReifierFragmentHandler(this, 0){

        public boolean clashesWith(ReifierFragmentsMap map, Node n, Triple reified) {
            return false;
        }
    };
    protected final ReifierFragmentHandler SUBJECTS = new SimpleReifierFragmentHandler(this, 1){

        public boolean clashesWith(ReifierFragmentsMap map, Node n, Triple reified) {
            return !n.equals(reified.getSubject());
        }
    };
    protected final ReifierFragmentHandler PREDICATES = new SimpleReifierFragmentHandler(this, 2){

        public boolean clashesWith(ReifierFragmentsMap map, Node n, Triple reified) {
            return !n.equals(reified.getPredicate());
        }
    };
    protected final ReifierFragmentHandler OBJECTS = new SimpleReifierFragmentHandler(this, 3){

        public boolean clashesWith(ReifierFragmentsMap map, Node n, Triple reified) {
            return !n.equals(reified.getObject());
        }
    };
    public final Map selectors = this.makeSelectors();

    protected Fragments getFragments(Node tag) {
        return (Fragments)this.forwardMap.get(tag);
    }

    protected void removeFragments(Node key) {
        this.forwardMap.remove(key);
    }

    public void clear() {
        this.forwardMap.clear();
    }

    protected Fragments putFragments(Node key, Fragments value) {
        this.forwardMap.put(key, value);
        return value;
    }

    protected ExtendedIterator allTriples(TripleMatch tm) {
        if (this.forwardMap.isEmpty()) {
            return NullIterator.instance;
        }
        Triple t = tm.asTriple();
        Node subject = t.getSubject();
        if (subject.isConcrete()) {
            Fragments x = (Fragments)this.forwardMap.get(subject);
            return x == null ? NullIterator.instance : this.explodeFragments(t, subject, x);
        }
        Iterator it = this.forwardMap.entrySet().iterator();
        return new FragmentTripleIterator(t, it){

            public void fill(GraphAdd ga, Node n, Object fragmentsObject) {
                ((Fragments)fragmentsObject).includeInto(ga);
            }
        };
    }

    protected ExtendedIterator explodeFragments(Triple t, Node subject, Fragments x) {
        GraphAddList L = new GraphAddList(t);
        x.includeInto(L);
        return WrappedIterator.create(L.iterator());
    }

    public ExtendedIterator find(TripleMatch m) {
        return this.allTriples(m);
    }

    public int size() {
        int result = 0;
        Iterator it = this.forwardMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            Fragments f = (Fragments)e.getValue();
            result += f.size();
        }
        return result;
    }

    public ReifierFragmentHandler getFragmentHandler(Triple t) {
        Node p = t.getPredicate();
        ReifierFragmentHandler x = (ReifierFragmentHandler)this.selectors.get(p);
        if (x == null || p.equals(RDF.Nodes.type) && !t.getObject().equals(RDF.Nodes.Statement)) {
            return null;
        }
        return x;
    }

    public void putAugmentedTriple(SimpleReifierFragmentHandler s, Node tag, Node object, Triple reified) {
        Fragments partial = new Fragments(tag, reified);
        partial.add(s, object);
        this.putFragments(tag, partial);
    }

    protected Triple reifyCompleteQuad(SimpleReifierFragmentHandler s, Triple fragment, Node tag, Node object) {
        Fragments partial = this.getFragments(tag);
        if (partial == null) {
            partial = new Fragments(tag);
            this.putFragments(tag, partial);
        }
        partial.add(s, object);
        if (partial.isComplete()) {
            this.removeFragments(fragment.getSubject());
            return partial.asTriple();
        }
        return null;
    }

    protected Triple removeFragment(SimpleReifierFragmentHandler s, Node tag, Triple already, Triple fragment) {
        Fragments partial = this.getFragments(tag);
        Fragments fs = already != null ? this.explode(tag, already) : (partial == null ? this.putFragments(tag, new Fragments(tag)) : partial);
        fs.remove(s, fragment.getObject());
        if (fs.isComplete()) {
            Triple result = fs.asTriple();
            this.removeFragments(tag);
            return result;
        }
        if (fs.isEmpty()) {
            this.removeFragments(tag);
        }
        return null;
    }

    protected Fragments explode(Node s, Triple t) {
        return this.putFragments(s, new Fragments(s, t));
    }

    public boolean hasFragments(Node tag) {
        return this.getFragments(tag) != null;
    }

    protected Map makeSelectors() {
        Map result = CollectionFactory.createHashedMap();
        result.put(RDF.Nodes.subject, this.SUBJECTS);
        result.put(RDF.Nodes.predicate, this.PREDICATES);
        result.put(RDF.Nodes.object, this.OBJECTS);
        result.put(RDF.Nodes.type, this.TYPES);
        return result;
    }

    protected static class Fragments {
        private final Set[] slots = new Set[]{CollectionFactory.createHashedSet(), CollectionFactory.createHashedSet(), CollectionFactory.createHashedSet(), CollectionFactory.createHashedSet()};
        private Node anchor;

        public Fragments(Node n) {
            this.anchor = n;
        }

        public Fragments(Node n, Triple t) {
            this(n);
            this.addTriple(t);
        }

        public int size() {
            return this.slots[0].size() + this.slots[1].size() + this.slots[2].size() + this.slots[3].size();
        }

        public boolean isComplete() {
            return this.slots[0].size() == 1 && this.slots[1].size() == 1 && this.slots[2].size() == 1 && this.slots[3].size() == 1;
        }

        public boolean isEmpty() {
            return this.slots[0].isEmpty() && this.slots[1].isEmpty() && this.slots[2].isEmpty() && this.slots[3].isEmpty();
        }

        public void remove(SimpleReifierFragmentHandler w, Node n) {
            this.slots[w.which].remove(n);
        }

        public void add(SimpleReifierFragmentHandler w, Node n) {
            this.slots[w.which].add(n);
        }

        public void includeInto(GraphAdd g) {
            this.includeInto(g, RDF.Nodes.subject, 1);
            this.includeInto(g, RDF.Nodes.predicate, 2);
            this.includeInto(g, RDF.Nodes.object, 3);
            this.includeInto(g, RDF.Nodes.type, 0);
        }

        private void includeInto(GraphAdd g, Node predicate, int which) {
            Iterator it = this.slots[which].iterator();
            while (it.hasNext()) {
                g.add(Triple.create(this.anchor, predicate, (Node)it.next()));
            }
        }

        public Fragments addTriple(Triple t) {
            this.slots[1].add(t.getSubject());
            this.slots[2].add(t.getPredicate());
            this.slots[3].add(t.getObject());
            this.slots[0].add(RDF.Nodes.Statement);
            return this;
        }

        Triple asTriple() {
            return Triple.create(this.only(this.slots[1]), this.only(this.slots[2]), this.only(this.slots[3]));
        }

        private Node only(Set s) {
            return (Node)s.iterator().next();
        }

        public String toString() {
            return this.anchor + " s:" + this.slots[1] + " p:" + this.slots[2] + " o:" + this.slots[3] + " t:" + this.slots[0];
        }
    }
}

