/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.criteria;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.Parameter;
import javax.persistence.TemporalType;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.ParameterExpression;
import org.hibernate.ejb.HibernateEntityManagerImplementor;
import org.hibernate.ejb.criteria.CriteriaQueryImpl;
import org.hibernate.ejb.criteria.ValueHandlerFactory;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.type.Type;
import org.hibernate.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CriteriaQueryCompiler
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(CriteriaQueryCompiler.class);
    private final HibernateEntityManagerImplementor entityManager;

    public CriteriaQueryCompiler(HibernateEntityManagerImplementor entityManager) {
        this.entityManager = entityManager;
    }

    public <T> TypedQuery<T> compile(CriteriaQuery<T> criteriaQuery) {
        CriteriaQueryImpl criteriaQueryImpl = (CriteriaQueryImpl)criteriaQuery;
        criteriaQueryImpl.validate();
        final HashMap explicitParameterMapping = new HashMap();
        final HashMap explicitParameterNameMapping = new HashMap();
        final ArrayList implicitParameterBindings = new ArrayList();
        final HashMap implicitParameterTypes = new HashMap();
        RenderingContext renderingContext = new RenderingContext(){
            private int aliasCount = 0;
            private int explicitParameterCount = 0;

            @Override
            public String generateAlias() {
                return "generatedAlias" + this.aliasCount++;
            }

            public String generateParameterName() {
                return "param" + this.explicitParameterCount++;
            }

            @Override
            public String registerExplicitParameter(ParameterExpression<?> criteriaQueryParameter) {
                String jpaqlParameterName;
                if (explicitParameterMapping.containsKey(criteriaQueryParameter)) {
                    jpaqlParameterName = (String)explicitParameterMapping.get(criteriaQueryParameter);
                } else {
                    jpaqlParameterName = this.generateParameterName();
                    explicitParameterMapping.put(criteriaQueryParameter, jpaqlParameterName);
                }
                if (StringHelper.isNotEmpty((String)criteriaQueryParameter.getName())) {
                    explicitParameterNameMapping.put(criteriaQueryParameter.getName(), criteriaQueryParameter);
                }
                return jpaqlParameterName;
            }

            @Override
            public String registerLiteralParameterBinding(final Object literal, final Class javaType) {
                final String parameterName = this.generateParameterName();
                ImplicitParameterBinding binding = new ImplicitParameterBinding(){

                    public String getParameterName() {
                        return parameterName;
                    }

                    public Class getJavaType() {
                        return javaType;
                    }

                    public void bind(TypedQuery typedQuery) {
                        typedQuery.setParameter(parameterName, literal);
                    }
                };
                implicitParameterBindings.add(binding);
                implicitParameterTypes.put(parameterName, javaType);
                return parameterName;
            }

            @Override
            public String getCastType(Class javaType) {
                SessionFactoryImplementor factory = (SessionFactoryImplementor)CriteriaQueryCompiler.this.entityManager.getFactory().getSessionFactory();
                Type hibernateType = factory.getTypeResolver().heuristicType(javaType.getName());
                if (hibernateType == null) {
                    throw new IllegalArgumentException("Could not convert java type [" + javaType.getName() + "] to Hibernate type");
                }
                return hibernateType.getName();
            }
        };
        final RenderedCriteriaQuery renderedCriteriaQuery = criteriaQueryImpl.render(renderingContext);
        log.debug("Rendered criteria query -> {}", (Object)renderedCriteriaQuery.getQueryString());
        TypedQuery jpaqlQuery = this.entityManager.createQuery(renderedCriteriaQuery.getQueryString(), criteriaQuery.getResultType(), criteriaQuery.getSelection(), new HibernateEntityManagerImplementor.Options(){

            @Override
            public List<ValueHandlerFactory.ValueHandler> getValueHandlers() {
                return renderedCriteriaQuery.getValueHandlers();
            }

            @Override
            public Map<String, Class> getNamedParameterExplicitTypes() {
                return implicitParameterTypes;
            }

            @Override
            public HibernateEntityManagerImplementor.Options.ResultMetadataValidator getResultMetadataValidator() {
                return renderedCriteriaQuery.getResultMetadataValidator();
            }
        });
        for (ImplicitParameterBinding implicitParameterBinding : implicitParameterBindings) {
            implicitParameterBinding.bind(jpaqlQuery);
        }
        return this.wrap(jpaqlQuery, explicitParameterMapping, explicitParameterNameMapping);
    }

    private <X> TypedQuery<X> wrap(final TypedQuery<X> jpaqlQuery, final Map<ParameterExpression<?>, String> explicitParameterMapping, final Map<String, ParameterExpression<?>> explicitParameterNameMapping) {
        return new TypedQuery<X>(){

            public List<X> getResultList() {
                return jpaqlQuery.getResultList();
            }

            public X getSingleResult() {
                return jpaqlQuery.getSingleResult();
            }

            public int getMaxResults() {
                return jpaqlQuery.getMaxResults();
            }

            public TypedQuery<X> setMaxResults(int i) {
                jpaqlQuery.setMaxResults(i);
                return this;
            }

            public int getFirstResult() {
                return jpaqlQuery.getFirstResult();
            }

            public TypedQuery<X> setFirstResult(int i) {
                jpaqlQuery.setFirstResult(i);
                return this;
            }

            public Map<String, Object> getHints() {
                return jpaqlQuery.getHints();
            }

            public TypedQuery<X> setHint(String name, Object value) {
                jpaqlQuery.setHint(name, value);
                return this;
            }

            public FlushModeType getFlushMode() {
                return jpaqlQuery.getFlushMode();
            }

            public TypedQuery<X> setFlushMode(FlushModeType flushModeType) {
                jpaqlQuery.setFlushMode(flushModeType);
                return this;
            }

            public LockModeType getLockMode() {
                return jpaqlQuery.getLockMode();
            }

            public TypedQuery<X> setLockMode(LockModeType lockModeType) {
                jpaqlQuery.setLockMode(lockModeType);
                return this;
            }

            public Set getParameters() {
                return explicitParameterMapping.keySet();
            }

            public boolean isBound(Parameter<?> param) {
                return jpaqlQuery.isBound(param);
            }

            public <T> T getParameterValue(Parameter<T> param) {
                return (T)jpaqlQuery.getParameterValue(this.mapToNamedParameter(param));
            }

            public <T> TypedQuery<X> setParameter(Parameter<T> param, T t) {
                jpaqlQuery.setParameter(this.mapToNamedParameter(param), t);
                return this;
            }

            private Parameter mapToNamedParameter(Parameter criteriaParameter) {
                return jpaqlQuery.getParameter((String)explicitParameterMapping.get((ParameterExpression)criteriaParameter));
            }

            public TypedQuery<X> setParameter(Parameter<Calendar> param, Calendar calendar, TemporalType temporalType) {
                jpaqlQuery.setParameter(this.mapToNamedParameter(param), calendar, temporalType);
                return this;
            }

            public TypedQuery<X> setParameter(Parameter<Date> param, Date date, TemporalType temporalType) {
                jpaqlQuery.setParameter(this.mapToNamedParameter(param), date, temporalType);
                return this;
            }

            public <T> T unwrap(Class<T> cls) {
                return (T)jpaqlQuery.unwrap(cls);
            }

            public Object getParameterValue(String name) {
                return this.getParameterValue(this.resolveExplicitCriteriaParameterName(name));
            }

            private Parameter resolveExplicitCriteriaParameterName(String name) {
                Parameter parameter = (Parameter)explicitParameterNameMapping.get(name);
                if (parameter == null) {
                    throw new IllegalArgumentException("Named parameter [" + name + "] not encountered");
                }
                return parameter;
            }

            public Parameter<?> getParameter(String name) {
                return this.mapToNamedParameter(this.resolveExplicitCriteriaParameterName(name));
            }

            public <T> Parameter<T> getParameter(String name, Class<T> type) {
                Parameter parameter = this.resolveExplicitCriteriaParameterName(name);
                if (type.isAssignableFrom(parameter.getParameterType())) {
                    return parameter;
                }
                throw new IllegalArgumentException("Named parameter [" + name + "] type is not assignanle to request type [" + type.getName() + "]");
            }

            public TypedQuery<X> setParameter(String name, Object value) {
                this.setParameter((Parameter<T>)this.resolveExplicitCriteriaParameterName(name, value), (T)value);
                return this;
            }

            private Parameter resolveExplicitCriteriaParameterName(String name, Object value) {
                Parameter parameter = this.resolveExplicitCriteriaParameterName(name);
                if (value != null && !parameter.getParameterType().isInstance(value)) {
                    throw new IllegalArgumentException("Named parameter [" + name + "] type mismatch; expecting [" + parameter.getParameterType().getName() + "], found [" + value.getClass().getName() + "]");
                }
                return parameter;
            }

            public TypedQuery<X> setParameter(String name, Calendar calendar, TemporalType temporalType) {
                Parameter parameter = this.resolveExplicitCriteriaParameterName(name);
                if (!Calendar.class.isAssignableFrom(parameter.getParameterType())) {
                    throw new IllegalArgumentException("Named parameter [" + name + "] type mismatch; expecting [" + Calendar.class.getName() + "], found [" + parameter.getParameterType().getName() + "]");
                }
                this.setParameter((Parameter<Calendar>)parameter, calendar, temporalType);
                return this;
            }

            public TypedQuery<X> setParameter(String name, Date date, TemporalType temporalType) {
                Parameter parameter = this.resolveExplicitCriteriaParameterName(name);
                if (!Date.class.isAssignableFrom(parameter.getParameterType())) {
                    throw new IllegalArgumentException("Named parameter [" + name + "] type mismatch; expecting [" + Date.class.getName() + "], found [" + parameter.getParameterType().getName() + "]");
                }
                this.setParameter((Parameter<Date>)parameter, date, temporalType);
                return this;
            }

            public int executeUpdate() {
                throw new IllegalArgumentException("Criteria queries do not support update queries");
            }

            public TypedQuery<X> setParameter(int i, Object o) {
                throw new IllegalArgumentException("Criteria queries do not support positioned parameters");
            }

            public TypedQuery<X> setParameter(int i, Calendar calendar, TemporalType temporalType) {
                throw new IllegalArgumentException("Criteria queries do not support positioned parameters");
            }

            public TypedQuery<X> setParameter(int i, Date date, TemporalType temporalType) {
                throw new IllegalArgumentException("Criteria queries do not support positioned parameters");
            }

            public Object getParameterValue(int position) {
                throw new IllegalArgumentException("Criteria queries do not support positioned parameters");
            }

            public Parameter<?> getParameter(int position) {
                throw new IllegalArgumentException("Criteria queries do not support positioned parameters");
            }

            public <T> Parameter<T> getParameter(int position, Class<T> type) {
                throw new IllegalArgumentException("Criteria queries do not support positioned parameters");
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface RenderedCriteriaQuery {
        public String getQueryString();

        public List<ValueHandlerFactory.ValueHandler> getValueHandlers();

        public HibernateEntityManagerImplementor.Options.ResultMetadataValidator getResultMetadataValidator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface RenderingContext {
        public String generateAlias();

        public String registerExplicitParameter(ParameterExpression<?> var1);

        public String registerLiteralParameterBinding(Object var1, Class var2);

        public String getCastType(Class var1);
    }

    public static interface ImplicitParameterBinding {
        public String getParameterName();

        public Class getJavaType();

        public void bind(TypedQuery var1);
    }
}

