/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb;

import java.util.Map;
import javax.persistence.PersistenceContextType;
import javax.persistence.PersistenceException;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.transaction.Synchronization;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.Session;
import org.hibernate.annotations.common.util.ReflectHelper;
import org.hibernate.ejb.AbstractEntityManagerImpl;
import org.hibernate.ejb.EntityManagerFactoryImpl;
import org.hibernate.engine.SessionImplementor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityManagerImpl
extends AbstractEntityManagerImpl {
    private static final Logger log = LoggerFactory.getLogger(EntityManagerImpl.class);
    protected Session session;
    protected boolean open = true;
    protected boolean discardOnClose;
    private Class sessionInterceptorClass;

    public EntityManagerImpl(EntityManagerFactoryImpl entityManagerFactory, PersistenceContextType pcType, PersistenceUnitTransactionType transactionType, boolean discardOnClose, Class sessionInterceptorClass, Map properties) {
        super(entityManagerFactory, pcType, transactionType, properties);
        this.discardOnClose = discardOnClose;
        Object localSessionInterceptor = null;
        if (properties != null) {
            localSessionInterceptor = properties.get("hibernate.ejb.interceptor.session_scoped");
        }
        if (localSessionInterceptor != null) {
            if (localSessionInterceptor instanceof Class) {
                sessionInterceptorClass = localSessionInterceptor;
            } else if (localSessionInterceptor instanceof String) {
                try {
                    sessionInterceptorClass = ReflectHelper.classForName((String)localSessionInterceptor, EntityManagerImpl.class);
                }
                catch (ClassNotFoundException e) {
                    throw new PersistenceException("Unable to instanciate interceptor: " + localSessionInterceptor, (Throwable)e);
                }
            } else {
                throw new PersistenceException("Unable to instanciate interceptor: " + localSessionInterceptor);
            }
        }
        this.sessionInterceptorClass = sessionInterceptorClass;
        this.postInit();
    }

    public Session getSession() {
        if (!this.open) {
            throw new IllegalStateException("EntityManager is closed");
        }
        return this.getRawSession();
    }

    protected Session getRawSession() {
        if (this.session == null) {
            Interceptor interceptor = null;
            if (this.sessionInterceptorClass != null) {
                try {
                    interceptor = (Interceptor)this.sessionInterceptorClass.newInstance();
                }
                catch (InstantiationException e) {
                    throw new PersistenceException("Unable to instanciate session interceptor: " + this.sessionInterceptorClass, (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    throw new PersistenceException("Unable to instanciate session interceptor: " + this.sessionInterceptorClass, (Throwable)e);
                }
                catch (ClassCastException e) {
                    throw new PersistenceException("Session interceptor does not implement Interceptor: " + this.sessionInterceptorClass, (Throwable)e);
                }
            }
            this.session = this.getEntityManagerFactory().getSessionFactory().openSession(interceptor);
            if (this.persistenceContextType == PersistenceContextType.TRANSACTION) {
                ((SessionImplementor)this.session).setAutoClear(true);
            }
        }
        return this.session;
    }

    public void close() {
        this.checkEntityManagerFactory();
        if (!this.open) {
            throw new IllegalStateException("EntityManager is closed");
        }
        if (!this.discardOnClose && this.isTransactionInProgress()) {
            this.getSession().getTransaction().registerSynchronization(new Synchronization(){

                public void beforeCompletion() {
                }

                public void afterCompletion(int i) {
                    if (EntityManagerImpl.this.session != null) {
                        if (EntityManagerImpl.this.session.isOpen()) {
                            log.debug("Closing entity manager after transaction completion");
                            EntityManagerImpl.this.session.close();
                        } else {
                            log.warn("Entity Manager closed by someone else ({} must not be used)", (Object)"hibernate.transaction.auto_close_session");
                        }
                    }
                }
            });
        } else if (this.session != null) {
            this.session.close();
        }
        this.open = false;
    }

    public boolean isOpen() {
        this.checkEntityManagerFactory();
        try {
            if (this.open) {
                this.getSession().isOpen();
            }
            return this.open;
        }
        catch (HibernateException he) {
            this.throwPersistenceException(he);
            return false;
        }
    }

    private void checkEntityManagerFactory() {
        if (!this.getEntityManagerFactory().isOpen()) {
            this.open = false;
        }
    }
}

