/*
 * Decompiled with CFR 0.152.
 */
package ch.hsr.geohash;

import ch.hsr.geohash.WGS84Point;
import java.io.Serializable;

public class BoundingBox
implements Serializable {
    private static final long serialVersionUID = -7145192134410261076L;
    private double minLat;
    private double maxLat;
    private double minLon;
    private double maxLon;

    public BoundingBox(WGS84Point p1, WGS84Point p2) {
        this(p1.getLatitude(), p2.getLatitude(), p1.getLongitude(), p2.getLongitude());
    }

    public BoundingBox(double y1, double y2, double x1, double x2) {
        this.minLon = Math.min(x1, x2);
        this.maxLon = Math.max(x1, x2);
        this.minLat = Math.min(y1, y2);
        this.maxLat = Math.max(y1, y2);
    }

    public BoundingBox(BoundingBox that) {
        this(that.minLat, that.maxLat, that.minLon, that.maxLon);
    }

    public WGS84Point getUpperLeft() {
        return new WGS84Point(this.maxLat, this.minLon);
    }

    public WGS84Point getLowerRight() {
        return new WGS84Point(this.minLat, this.maxLon);
    }

    public double getLatitudeSize() {
        return this.maxLat - this.minLat;
    }

    public double getLongitudeSize() {
        return this.maxLon - this.minLon;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BoundingBox) {
            BoundingBox that = (BoundingBox)obj;
            return this.minLat == that.minLat && this.minLon == that.minLon && this.maxLat == that.maxLat && this.maxLon == that.maxLon;
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + BoundingBox.hashCode(this.minLat);
        result = 37 * result + BoundingBox.hashCode(this.maxLat);
        result = 37 * result + BoundingBox.hashCode(this.minLon);
        result = 37 * result + BoundingBox.hashCode(this.maxLon);
        return result;
    }

    private static int hashCode(double x) {
        long f = Double.doubleToLongBits(x);
        return (int)(f ^ f >>> 32);
    }

    public boolean contains(WGS84Point point) {
        return point.getLatitude() >= this.minLat && point.getLongitude() >= this.minLon && point.getLatitude() <= this.maxLat && point.getLongitude() <= this.maxLon;
    }

    public boolean intersects(BoundingBox other) {
        return !(other.minLon > this.maxLon || other.maxLon < this.minLon || other.minLat > this.maxLat || other.maxLat < this.minLat);
    }

    public String toString() {
        return this.getUpperLeft() + " -> " + this.getLowerRight();
    }

    public WGS84Point getCenterPoint() {
        double centerLatitude = (this.minLat + this.maxLat) / 2.0;
        double centerLongitude = (this.minLon + this.maxLon) / 2.0;
        return new WGS84Point(centerLatitude, centerLongitude);
    }

    public void expandToInclude(BoundingBox other) {
        if (other.minLon < this.minLon) {
            this.minLon = other.minLon;
        }
        if (other.maxLon > this.maxLon) {
            this.maxLon = other.maxLon;
        }
        if (other.minLat < this.minLat) {
            this.minLat = other.minLat;
        }
        if (other.maxLat > this.maxLat) {
            this.maxLat = other.maxLat;
        }
    }

    public double getMinLon() {
        return this.minLon;
    }

    public double getMinLat() {
        return this.minLat;
    }

    public double getMaxLat() {
        return this.maxLat;
    }

    public double getMaxLon() {
        return this.maxLon;
    }
}

