/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.ref;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.sparql.algebra.AlgebraGenerator;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpSubstitute;
import com.hp.hpl.jena.sparql.algebra.Table;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.Plan;
import com.hp.hpl.jena.sparql.engine.QueryEngineBase;
import com.hp.hpl.jena.sparql.engine.QueryEngineFactory;
import com.hp.hpl.jena.sparql.engine.QueryEngineRegistry;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIteratorCheck;
import com.hp.hpl.jena.sparql.engine.ref.Eval;
import com.hp.hpl.jena.sparql.engine.ref.Evaluator;
import com.hp.hpl.jena.sparql.engine.ref.EvaluatorFactory;
import com.hp.hpl.jena.sparql.util.Context;

public class QueryEngineRef
extends QueryEngineBase {
    private static QueryEngineFactory factory = new QueryEngineFactory(){

        public boolean accept(Query query, DatasetGraph dataset, Context context) {
            return true;
        }

        public Plan create(Query query, DatasetGraph dataset, Binding binding, Context context) {
            QueryEngineRef engine = new QueryEngineRef(query, dataset, binding, context);
            return engine.getPlan();
        }

        public boolean accept(Op op, DatasetGraph dataset, Context context) {
            return true;
        }

        public Plan create(Op op, DatasetGraph dataset, Binding binding, Context context) {
            QueryEngineRef engine = new QueryEngineRef(op, dataset, binding, context);
            return engine.getPlan();
        }
    };

    public QueryEngineRef(Op op, DatasetGraph dataset, Context context) {
        this(op, dataset, null, context);
    }

    public QueryEngineRef(Op op, DatasetGraph dataset, Binding input, Context context) {
        super(op, dataset, input, context);
    }

    public QueryEngineRef(Query query, DatasetGraph dataset, Binding input, Context context) {
        this(query, dataset, new AlgebraGenerator(context), input, context);
    }

    protected QueryEngineRef(Query query, DatasetGraph dataset, AlgebraGenerator gen, Binding input, Context context) {
        super(query, dataset, gen, input, context);
    }

    public QueryIterator eval(Op op, DatasetGraph dsg, Binding binding, Context context) {
        if (binding.vars().hasNext()) {
            op = OpSubstitute.substitute(op, binding);
        }
        ExecutionContext execCxt = new ExecutionContext(context, dsg.getDefaultGraph(), dsg);
        Evaluator eval2 = EvaluatorFactory.create(execCxt);
        Table table = Eval.eval(eval2, op);
        QueryIterator qIter = table.iterator(execCxt);
        return QueryIteratorCheck.check(qIter, execCxt);
    }

    public static QueryEngineFactory getFactory() {
        return factory;
    }

    public static void register() {
        QueryEngineRegistry.addFactory(factory);
    }

    public static void unregister() {
        QueryEngineRegistry.removeFactory(factory);
    }
}

