/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.larq;

import com.hp.hpl.jena.query.larq.IndexBuilderLiteral;
import com.hp.hpl.jena.query.larq.LARQ;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Statement;
import java.io.File;
import org.apache.lucene.index.IndexWriter;

public class IndexBuilderString
extends IndexBuilderLiteral {
    private Property property = null;

    public IndexBuilderString() {
    }

    public IndexBuilderString(IndexWriter existingWriter) {
        super(existingWriter);
    }

    public IndexBuilderString(File fileDir) {
        super(fileDir);
    }

    public IndexBuilderString(String fileDir) {
        super(fileDir);
    }

    public IndexBuilderString(Property property) {
        this.setProperty(property);
    }

    public IndexBuilderString(Property property, IndexWriter existingWriter) {
        super(existingWriter);
        this.setProperty(property);
    }

    public IndexBuilderString(Property property, File fileDir) {
        super(fileDir);
        this.setProperty(property);
    }

    public IndexBuilderString(Property property, String fileDir) {
        super(fileDir);
        this.setProperty(property);
    }

    protected boolean indexThisStatement(Statement stmt) {
        if (this.property == null) {
            return true;
        }
        return stmt.getPredicate().equals(this.property);
    }

    private void setProperty(Property p) {
        this.property = p;
    }

    protected boolean indexThisLiteral(Literal literal) {
        return LARQ.isString(literal);
    }
}

