/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;

public class LazySequence<T extends Item<?>>
implements Sequence<T> {
    SequenceIterator<T> iterator;
    boolean used = false;

    public LazySequence(SequenceIterator<T> iterator) {
        this.iterator = iterator;
    }

    @Override
    public T head() throws XPathException {
        return this.iterate().next();
    }

    @Override
    public synchronized SequenceIterator<T> iterate() throws XPathException {
        if (this.used) {
            throw new IllegalStateException("A LazySequence can only be read once");
        }
        this.used = true;
        return this.iterator;
    }

    @Override
    public Sequence<T> makeRepeatable() throws XPathException {
        return this.materialize();
    }
}

