/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.sort;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.sort.GenericSorter;
import net.sf.saxon.expr.sort.ItemOrderComparer;
import net.sf.saxon.expr.sort.Sortable;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ListIterator;

public final class DocumentOrderIterator
implements SequenceIterator<NodeInfo>,
Sortable {
    private SequenceIterator<NodeInfo> iterator;
    private List<NodeInfo> sequence;
    private ItemOrderComparer comparer;
    private NodeInfo current = null;

    public DocumentOrderIterator(SequenceIterator<?> base, ItemOrderComparer comparer) throws XPathException {
        this.comparer = comparer;
        int len = (base.getProperties() & 2) == 0 ? 50 : ((LastPositionFinder)((Object)base)).getLength();
        this.sequence = new ArrayList<NodeInfo>(len);
        base.forEachOrFail(item -> {
            if (!(item instanceof NodeInfo)) {
                throw new XPathException("Item in input for sorting is not a node: " + Err.depict(item), "XPTY0004");
            }
            this.sequence.add((NodeInfo)item);
        });
        if (this.sequence.size() > 1) {
            GenericSorter.quickSort(0, this.sequence.size(), this);
        }
        this.iterator = new ListIterator<NodeInfo>(this.sequence);
    }

    private DocumentOrderIterator() {
    }

    @Override
    public int compare(int a, int b) {
        return this.comparer.compare(this.sequence.get(a), this.sequence.get(b));
    }

    @Override
    public void swap(int a, int b) {
        NodeInfo temp = this.sequence.get(a);
        this.sequence.set(a, this.sequence.get(b));
        this.sequence.set(b, temp);
    }

    @Override
    public NodeInfo next() throws XPathException {
        NodeInfo next;
        do {
            if ((next = this.iterator.next()) != null) continue;
            this.current = null;
            return null;
        } while (next.equals(this.current));
        this.current = next;
        return this.current;
    }

    @Override
    public int getProperties() {
        return 0;
    }

    @Override
    public void close() {
    }
}

