/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.bookkeeper.jdbi.mappers;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.dropwizard.jackson.Jackson;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import org.dataone.bookkeeper.api.Order;
import org.dataone.bookkeeper.api.OrderItem;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.statement.StatementContext;

public class OrderMapper
implements RowMapper<Order> {
    public Order map(ResultSet rs, StatementContext ctx) throws SQLException {
        Order order;
        ObjectMapper mapper = Jackson.newObjectMapper();
        LinkedList<Object> items = new LinkedList<Object>();
        try {
            ArrayNode itemsArray = (ArrayNode)mapper.readTree(rs.getString("o_items"));
            Iterator iterator = itemsArray.elements();
            while (iterator.hasNext()) {
                ObjectNode item = (ObjectNode)iterator.next();
                items.add(mapper.readValue(item.toString(), OrderItem.class));
            }
            order = new Order(new Integer(rs.getInt("o_id")), rs.getString("o_object"), new Integer(rs.getInt("o_amount")), new Integer(rs.getInt("o_amountReturned")), rs.getString("o_charge") != null ? (ObjectNode)mapper.readTree(rs.getString("o_charge")) : null, new Integer(rs.getInt("o_created")), rs.getString("o_currency"), rs.getString("o_subject"), new Integer(rs.getInt("o_customer")), rs.getString("o_email"), items, rs.getString("o_metadata") != null ? (ObjectNode)mapper.readTree(rs.getString("o_metadata")) : null, rs.getString("o_name"), rs.getString("o_status"), rs.getString("o_statusTransitions") != null ? (ObjectNode)mapper.readTree(rs.getString("o_statusTransitions")) : null, new Integer(rs.getInt("o_updated")), rs.getString("o_seriesId"), new Integer(rs.getInt("o_startDate")), new Integer(rs.getInt("o_endDate")), null);
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
        return order;
    }
}

