/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.logging;

import org.codehaus.plexus.logging.Logger;

public abstract class AbstractLogger
implements Logger {
    private final String name;
    private int threshold;

    public AbstractLogger(int threshold, String name) {
        this.name = name;
        if (threshold < 0 || 5 < threshold) {
            throw new IllegalArgumentException("Threshold " + threshold + " is not valid");
        }
        this.threshold = threshold;
    }

    public final void debug(String message) {
        this.debug(message, null);
    }

    public boolean isDebugEnabled() {
        return this.threshold <= 0;
    }

    public final void info(String message) {
        this.info(message, null);
    }

    public boolean isInfoEnabled() {
        return this.threshold <= 1;
    }

    public final void warn(String message) {
        this.warn(message, null);
    }

    public boolean isWarnEnabled() {
        return this.threshold <= 2;
    }

    public final void error(String message) {
        this.error(message, null);
    }

    public boolean isErrorEnabled() {
        return this.threshold <= 3;
    }

    public final void fatalError(String message) {
        this.fatalError(message, null);
    }

    public boolean isFatalErrorEnabled() {
        return this.threshold <= 4;
    }

    public final int getThreshold() {
        return this.threshold;
    }

    public final void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    public final String getName() {
        return this.name;
    }
}

