/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.main.iterator;

import com.hp.hpl.jena.sparql.algebra.JoinType;
import com.hp.hpl.jena.sparql.algebra.Table;
import com.hp.hpl.jena.sparql.algebra.TableFactory;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.TableJoin;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIter;
import com.hp.hpl.jena.sparql.expr.ExprList;

public class QueryIterJoinBase
extends QueryIter {
    private final QueryIterator left;
    private final QueryIterator right;
    private final QueryIterator result;

    protected QueryIterJoinBase(QueryIterator left, QueryIterator right, JoinType joinType, ExprList exprs, ExecutionContext execCxt) {
        super(execCxt);
        this.left = left;
        this.right = right;
        this.result = QueryIterJoinBase.calc(left, right, joinType, exprs, execCxt);
    }

    private static QueryIterator calc(QueryIterator left, QueryIterator right, JoinType joinType, ExprList exprs, ExecutionContext execCxt) {
        Table tableRight = TableFactory.create(right);
        return TableJoin.joinWorker(left, tableRight, joinType, exprs, execCxt);
    }

    @Override
    protected boolean hasNextBinding() {
        return this.result.hasNext();
    }

    @Override
    protected Binding moveToNextBinding() {
        return this.result.nextBinding();
    }

    @Override
    protected void closeIterator() {
        this.left.close();
        this.right.close();
        this.result.close();
    }

    @Override
    protected void requestCancel() {
        this.left.cancel();
        this.right.cancel();
        this.result.cancel();
    }
}

