/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.eml;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.client.v2.formats.ObjectFormatCache;
import org.dataone.eml.EMLDocument;
import org.dataone.service.exceptions.BaseException;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.types.v1.ObjectFormat;
import org.dataone.service.types.v1.ObjectFormatIdentifier;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DataoneEMLParser {
    private static DataoneEMLParser parser = null;
    protected static Log log = LogFactory.getLog(DataoneEMLParser.class);
    protected static TreeSet<String> supportedFormatIdentifiers;
    protected static String supportedNamespaceSummary;

    private DataoneEMLParser() {
        supportedFormatIdentifiers = new TreeSet();
        supportedFormatIdentifiers.add("eml://ecoinformatics.org/eml-2.0.0");
        supportedFormatIdentifiers.add("eml://ecoinformatics.org/eml-2.0.1");
        supportedFormatIdentifiers.add("eml://ecoinformatics.org/eml-2.1.0");
        supportedFormatIdentifiers.add("eml://ecoinformatics.org/eml-2.1.1");
        supportedNamespaceSummary = "EML 2.0.0, 2.0.1, 2.1.0, and 2.1.1";
    }

    public static DataoneEMLParser getInstance() {
        if (parser == null) {
            parser = new DataoneEMLParser();
        }
        return parser;
    }

    Iterator<String> getSupportedFormatIdentifierIterator() {
        return supportedFormatIdentifiers.iterator();
    }

    public EMLDocument parseDocument(InputStream is) throws ParserConfigurationException, IOException, SAXException, XPathExpressionException {
        log.debug((Object)"parsing EML document for any distribution urls");
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        builderFactory.setNamespaceAware(true);
        Document d = builderFactory.newDocumentBuilder().parse(is);
        String namespace = d.getFirstChild().getNamespaceURI();
        log.debug((Object)("namespace: " + namespace));
        if (namespace == null) {
            log.error((Object)"WARNING: No namespace is declared.  Cannot parse this document.");
            return null;
        }
        if (!supportedFormatIdentifiers.contains(namespace)) {
            throw new ParserConfigurationException("This parser only parses " + supportedNamespaceSummary + ".  Namespace " + namespace + " is not supported.");
        }
        ObjectFormatIdentifier namespaceFormatId = new ObjectFormatIdentifier();
        namespaceFormatId.setValue(namespace);
        EMLDocument emlDoc = null;
        try {
            org.dataone.service.types.v2.ObjectFormat format = ObjectFormatCache.getInstance().getFormat(namespaceFormatId);
            emlDoc = this.parseEMLDocument(d, (ObjectFormat)format);
        }
        catch (BaseException e) {
            throw new ParserConfigurationException("Unexpected Error validating the format:: " + ((Object)((Object)e)).getClass().getSimpleName() + "( " + e.getDetail_code() + " ): " + e.getDescription());
        }
        return emlDoc;
    }

    private NodeList runXPath(String expression, Node n) throws XPathExpressionException {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        XPathExpression expr = xpath.compile(expression);
        NodeList result = (NodeList)expr.evaluate(n, XPathConstants.NODESET);
        return result;
    }

    private EMLDocument parseEMLDocument(Document doc, ObjectFormat docType) throws XPathExpressionException, ServiceFailure, NotImplemented {
        log.debug((Object)"DataoneEMLParser.parseEMLDocument() called.");
        log.debug((Object)("Parsing a document of format: " + docType.getFormatName()));
        EMLDocument emlDoc = new EMLDocument();
        NodeList result = this.runXPath("//distribution", doc);
        log.debug((Object)("result: " + result));
        if (result != null) {
            for (int i = 0; i < result.getLength(); ++i) {
                Node firstChild;
                Node n = result.item(i);
                NodeList nl = this.runXPath("online/url", n);
                if (nl.getLength() == 0 || (firstChild = nl.item(0).getFirstChild()) == null) continue;
                String url = firstChild.getNodeValue();
                String mimeType = "";
                Node physicalNode = result.item(i).getParentNode();
                NodeList nlCompressionMethod = this.runXPath("compressionMethod", physicalNode);
                NodeList nl1 = this.runXPath("dataFormat/textFormat", physicalNode);
                NodeList nl2 = this.runXPath("dataFormat/binaryRasterFormat", physicalNode);
                NodeList nl3 = this.runXPath("dataFormat/externallyDefinedFormat", physicalNode);
                ObjectFormatIdentifier formatId = new ObjectFormatIdentifier();
                if (nl1.getLength() > 0) {
                    log.debug((Object)"Found a text format");
                    formatId.setValue("text/plain");
                    NodeList nl4 = this.runXPath("dataFormat/textFormat/simpleDelimited", physicalNode);
                    if (nl4.getLength() > 0) {
                        log.debug((Object)"Found a csv format");
                        formatId.setValue("text/csv");
                    }
                } else if (nl2.getLength() > 0) {
                    log.debug((Object)"Found a binary raster format");
                    formatId.setValue("application/octet-stream");
                } else if (nl3.getLength() > 0) {
                    log.debug((Object)"Found an externally defined format");
                    formatId.setValue("application/octet-stream");
                    NodeList nl5 = this.runXPath("dataFormat/externallyDefinedFormat/formatName", physicalNode);
                    if (nl5.getLength() > 0) {
                        Node childNode1 = nl5.item(0).getFirstChild();
                        String formatName = childNode1.getNodeValue();
                        formatId.setValue(formatName);
                    }
                }
                if (nlCompressionMethod != null && nlCompressionMethod.getLength() > 0) {
                    String compression = nlCompressionMethod.item(0).getFirstChild().getNodeValue();
                    if (compression.equals("zip")) {
                        formatId.setValue("application/zip");
                    }
                    if (compression.equals("gzip")) {
                        formatId.setValue("application/x-gzip");
                    }
                    if (compression.equals("bzip2")) {
                        formatId.setValue("application/x-bzip2");
                    }
                }
                if (formatId != null && formatId.getValue() != null) {
                    try {
                        mimeType = ObjectFormatCache.getInstance().getFormat(formatId).getFormatId().getValue();
                    }
                    catch (NotFound nfe) {
                        log.error((Object)("Could not find object format for: " + formatId));
                    }
                }
                log.debug((Object)("mime type: " + mimeType));
                log.debug((Object)("url:       " + url));
                emlDoc.addDistributionMetadata(url, mimeType);
            }
        }
        emlDoc.setObjectFormat(docType);
        log.debug((Object)("EML document type: " + emlDoc.format.toString()));
        return emlDoc;
    }
}

