/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.client;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang.StringUtils;
import org.dataone.client.D1Node;
import org.dataone.client.exception.ClientSideException;
import org.dataone.client.rest.MultipartRestClient;
import org.dataone.client.v1.types.D1TypeBuilder;
import org.dataone.client.v2.CNode;
import org.dataone.client.v2.MNode;
import org.dataone.client.v2.impl.MultipartCNode;
import org.dataone.client.v2.impl.MultipartMNode;
import org.dataone.service.cn.v1.CNAuthorization;
import org.dataone.service.cn.v1.CNRead;
import org.dataone.service.cn.v1.CNRegister;
import org.dataone.service.cn.v2.CNCore;
import org.dataone.service.cn.v2.CNDiagnostic;
import org.dataone.service.cn.v2.CNIdentity;
import org.dataone.service.cn.v2.CNReplication;
import org.dataone.service.cn.v2.CNView;
import org.dataone.service.mn.tier1.v1.MNCore;
import org.dataone.service.mn.tier1.v2.MNRead;
import org.dataone.service.mn.tier2.v1.MNAuthorization;
import org.dataone.service.mn.tier3.v2.MNStorage;
import org.dataone.service.mn.tier4.v1.MNReplication;
import org.dataone.service.mn.v2.MNPackage;
import org.dataone.service.mn.v2.MNQuery;
import org.dataone.service.mn.v2.MNView;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.NodeReference;
import org.dataone.service.types.v1.Subject;
import org.dataone.service.util.EncodingUtilities;

public class D1NodeFactory {
    private static final Map<Class<?>, INodeCreator<?>> nodeCreatorMap = new HashMap();

    private static <N extends D1Node> void registerService(Class serviceClass, INodeCreator<N> nodeCreator) {
        nodeCreatorMap.put(serviceClass, nodeCreator);
    }

    public static <N> N buildNode(Class<N> serviceClass, MultipartRestClient mrc, URI uri) throws ClientSideException {
        INodeCreator<?> nodeBuilder = nodeCreatorMap.get(serviceClass);
        if (nodeBuilder != null) {
            return (N)nodeBuilder.buildNode(mrc, uri);
        }
        throw new NotImplementedException("No INodeCreator exists for service class: " + serviceClass.getName());
    }

    private static org.dataone.client.v1.CNode build_v1_CNode(MultipartRestClient mrc, URI uri) throws ClientSideException {
        org.dataone.client.v1.CNode builtCNode = null;
        if (uri.getScheme() == null) {
            throw new ClientSideException("CN uri had no scheme");
        }
        if (uri.getScheme().equals("java")) {
            builtCNode = D1NodeFactory.buildJavaD1Node(org.dataone.client.v1.CNode.class, uri);
        } else if (uri.getScheme().equals("http") || uri.getScheme().equals("https")) {
            builtCNode = new org.dataone.client.v1.impl.MultipartCNode(mrc, uri.toString());
        } else {
            throw new ClientSideException("No corresponding builder for URI scheme: " + uri.getScheme());
        }
        return builtCNode;
    }

    private static org.dataone.client.v1.MNode build_v1_MNode(MultipartRestClient mrc, URI uri) throws ClientSideException {
        org.dataone.client.v1.MNode builtMNode = null;
        if (uri.getScheme() == null) {
            throw new ClientSideException("MN uri had no scheme");
        }
        if (uri.getScheme().equals("java")) {
            builtMNode = D1NodeFactory.buildJavaD1Node(org.dataone.client.v1.MNode.class, uri);
        } else if (uri.getScheme().equals("http") || uri.getScheme().equals("https")) {
            builtMNode = new org.dataone.client.v1.impl.MultipartMNode(mrc, uri.toString());
        } else {
            throw new ClientSideException("No corresponding builder for URI scheme: " + uri.getScheme());
        }
        return builtMNode;
    }

    private static CNode build_v2_CNode(MultipartRestClient mrc, URI uri) throws ClientSideException {
        CNode builtCNode = null;
        if (uri.getScheme() == null) {
            throw new ClientSideException("URI had no scheme");
        }
        if (uri.getScheme().equals("java")) {
            builtCNode = D1NodeFactory.buildJavaD1Node(CNode.class, uri);
        } else if (uri.getScheme().equals("http") || uri.getScheme().equals("https")) {
            builtCNode = new MultipartCNode(mrc, uri.toString());
        } else {
            throw new ClientSideException("No corresponding builder for URI scheme: " + uri.getScheme());
        }
        return builtCNode;
    }

    private static MNode build_v2_MNode(MultipartRestClient mrc, URI uri) throws ClientSideException {
        MNode builtMNode = null;
        if (uri.getScheme() == null) {
            throw new ClientSideException("URI had no scheme");
        }
        if (uri.getScheme().equals("java")) {
            builtMNode = D1NodeFactory.buildJavaD1Node(MNode.class, uri);
        } else if (uri.getScheme().equals("http") || uri.getScheme().equals("https")) {
            builtMNode = new MultipartMNode(mrc, uri.toString());
        } else {
            throw new ClientSideException("No corresponding builder for URI scheme: " + uri.getScheme());
        }
        return builtMNode;
    }

    private static <T> T buildJavaD1Node(Class<T> domainClass, URI uri) throws ClientSideException {
        try {
            String frag = EncodingUtilities.decodeString((String)uri.getFragment());
            String[] kvPairs = StringUtils.split((String)frag, (String)"&");
            if (kvPairs != null) {
                Class[] constructorParamTypes = new Class[kvPairs.length];
                Object[] initargs = new Object[kvPairs.length];
                for (int i = 0; i < kvPairs.length; ++i) {
                    String[] pair = StringUtils.split((String)kvPairs[i], (String)"=");
                    if (pair[0].equals("Identifier")) {
                        constructorParamTypes[i] = Identifier.class;
                        initargs[i] = D1TypeBuilder.buildIdentifier((String)pair[1]);
                        continue;
                    }
                    if (pair[0].equals("Subject")) {
                        constructorParamTypes[i] = Subject.class;
                        initargs[i] = D1TypeBuilder.buildSubject((String)pair[1]);
                        continue;
                    }
                    if (pair[0].equals("NodeReference")) {
                        constructorParamTypes[i] = NodeReference.class;
                        initargs[i] = D1TypeBuilder.buildNodeReference((String)pair[1]);
                        continue;
                    }
                    if (pair[0].equals("String")) {
                        constructorParamTypes[i] = String.class;
                        initargs[i] = pair[1];
                        continue;
                    }
                    if (pair[0].equals("Integer")) {
                        constructorParamTypes[i] = Integer.class;
                        initargs[i] = new Integer(pair[1]);
                        continue;
                    }
                    throw new ClientSideException("Malformed fragment in nodeBaseUrl to form constructor arguments");
                }
                Constructor<?> c = Class.forName(uri.getSchemeSpecificPart()).getConstructor(constructorParamTypes);
                return (T)c.newInstance(initargs);
            }
            Constructor<?> c = Class.forName(uri.getSchemeSpecificPart()).getConstructor(null);
            return (T)c.newInstance(new Object[0]);
        }
        catch (UnsupportedEncodingException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            String cause = null;
            if (e.getCause() != null) {
                cause = e.getCause().getClass().getCanonicalName();
            }
            throw new ClientSideException("Error in buildJavaD1Node: " + e.getClass().getCanonicalName() + ":" + cause);
        }
    }

    static {
        D1NodeFactory.registerService(org.dataone.service.cn.v1.CNCore.class, new V1CnBuilder());
        D1NodeFactory.registerService(CNRead.class, new V1CnBuilder());
        D1NodeFactory.registerService(CNAuthorization.class, new V1CnBuilder());
        D1NodeFactory.registerService(org.dataone.service.cn.v1.CNIdentity.class, new V1CnBuilder());
        D1NodeFactory.registerService(CNRegister.class, new V1CnBuilder());
        D1NodeFactory.registerService(org.dataone.service.cn.v1.CNReplication.class, new V1CnBuilder());
        D1NodeFactory.registerService(org.dataone.client.v1.CNode.class, new V1CnBuilder());
        D1NodeFactory.registerService(CNCore.class, new V2CnBuilder());
        D1NodeFactory.registerService(org.dataone.service.cn.v2.CNRead.class, new V2CnBuilder());
        D1NodeFactory.registerService(org.dataone.service.cn.v2.CNAuthorization.class, new V2CnBuilder());
        D1NodeFactory.registerService(CNIdentity.class, new V2CnBuilder());
        D1NodeFactory.registerService(org.dataone.service.cn.v2.CNRegister.class, new V2CnBuilder());
        D1NodeFactory.registerService(CNReplication.class, new V2CnBuilder());
        D1NodeFactory.registerService(CNView.class, new V2CnBuilder());
        D1NodeFactory.registerService(CNDiagnostic.class, new V2CnBuilder());
        D1NodeFactory.registerService(CNode.class, new V2CnBuilder());
        D1NodeFactory.registerService(MNCore.class, new V1MnBuilder());
        D1NodeFactory.registerService(org.dataone.service.mn.tier1.v1.MNRead.class, new V1MnBuilder());
        D1NodeFactory.registerService(MNAuthorization.class, new V1MnBuilder());
        D1NodeFactory.registerService(org.dataone.service.mn.tier3.v1.MNStorage.class, new V1MnBuilder());
        D1NodeFactory.registerService(MNReplication.class, new V1MnBuilder());
        D1NodeFactory.registerService(org.dataone.service.mn.v1.MNQuery.class, new V1MnBuilder());
        D1NodeFactory.registerService(org.dataone.client.v1.MNode.class, new V1MnBuilder());
        D1NodeFactory.registerService(org.dataone.service.mn.tier1.v2.MNCore.class, new V2MnBuilder());
        D1NodeFactory.registerService(MNRead.class, new V2MnBuilder());
        D1NodeFactory.registerService(org.dataone.service.mn.tier2.v2.MNAuthorization.class, new V2MnBuilder());
        D1NodeFactory.registerService(MNStorage.class, new V2MnBuilder());
        D1NodeFactory.registerService(org.dataone.service.mn.tier4.v2.MNReplication.class, new V2MnBuilder());
        D1NodeFactory.registerService(MNPackage.class, new V2MnBuilder());
        D1NodeFactory.registerService(MNQuery.class, new V2MnBuilder());
        D1NodeFactory.registerService(MNView.class, new V2MnBuilder());
        D1NodeFactory.registerService(MNode.class, new V2MnBuilder());
    }

    private static class V2MnBuilder
    implements INodeCreator<MNode> {
        private V2MnBuilder() {
        }

        @Override
        public MNode buildNode(MultipartRestClient mrc, URI uri) throws ClientSideException {
            return D1NodeFactory.build_v2_MNode(mrc, uri);
        }
    }

    private static class V1MnBuilder
    implements INodeCreator<org.dataone.client.v1.MNode> {
        private V1MnBuilder() {
        }

        @Override
        public org.dataone.client.v1.MNode buildNode(MultipartRestClient mrc, URI uri) throws ClientSideException {
            return D1NodeFactory.build_v1_MNode(mrc, uri);
        }
    }

    private static class V2CnBuilder
    implements INodeCreator<CNode> {
        private V2CnBuilder() {
        }

        @Override
        public CNode buildNode(MultipartRestClient mrc, URI uri) throws ClientSideException {
            return D1NodeFactory.build_v2_CNode(mrc, uri);
        }
    }

    private static class V1CnBuilder
    implements INodeCreator<org.dataone.client.v1.CNode> {
        private V1CnBuilder() {
        }

        @Override
        public org.dataone.client.v1.CNode buildNode(MultipartRestClient mrc, URI uri) throws ClientSideException {
            return D1NodeFactory.build_v1_CNode(mrc, uri);
        }
    }

    private static interface INodeCreator<N> {
        public N buildNode(MultipartRestClient var1, URI var2) throws ClientSideException;
    }
}

